/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.verb;

import ORG.oclc.oai.util.OAIUtil;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public abstract class ServerVerb {
    private static final boolean debug = false;
    private int statusCode = 200;
    private String message = null;
    protected String xmlText = null;
    static /* synthetic */ Class class$ORG$oclc$oai$server$verb$ListRecords;
    static /* synthetic */ Class class$ORG$oclc$oai$server$verb$ListIdentifiers;
    static /* synthetic */ Class class$ORG$oclc$oai$server$verb$GetRecord;
    static /* synthetic */ Class class$ORG$oclc$oai$server$verb$Identify;
    static /* synthetic */ Class class$ORG$oclc$oai$server$verb$ListMetadataFormats;
    static /* synthetic */ Class class$ORG$oclc$oai$server$verb$ListSets;
    static /* synthetic */ Class class$java$util$Properties;

    protected ServerVerb() {
    }

    public static void init(Properties properties) throws Exception {
    }

    protected void init(String xmlText) {
        this.xmlText = xmlText;
    }

    public ServerVerb(String xmlText) {
        this.init(xmlText);
    }

    public int getStatus() {
        return this.statusCode;
    }

    public String getMessage() {
        return this.message;
    }

    protected void setError(int statusCode, String message) {
        this.statusCode = statusCode;
        this.message = message;
    }

    public static String createResponseDate(Date date) {
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        TimeZone tz = TimeZone.getTimeZone("UTC");
        formatter.setTimeZone(tz);
        sb.append(formatter.format(date));
        return sb.toString();
    }

    protected static String getRequestElement(HttpServletRequest request, List validParamNames, String baseURL) {
        return ServerVerb.getRequestElement(request, validParamNames, baseURL, false);
    }

    protected static String getRequestElement(HttpServletRequest request, List validParamNames, String baseURL, boolean xmlEncodeSetSpec) {
        StringBuffer sb = new StringBuffer();
        sb.append("<request");
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String value;
            String name = (String)params.nextElement();
            if (!validParamNames.contains(name) || (value = request.getParameter(name)) == null || value.length() <= 0) continue;
            sb.append(" ");
            sb.append(name);
            sb.append("=\"");
            if (!xmlEncodeSetSpec && "set".equals(name)) {
                sb.append(value);
            } else {
                sb.append(OAIUtil.xmlEncode(value));
            }
            sb.append("\"");
        }
        sb.append(">");
        sb.append(baseURL);
        sb.append("</request>");
        return sb.toString();
    }

    protected static boolean hasBadArguments(HttpServletRequest request, Iterator requiredParamNames, List validParamNames) {
        while (requiredParamNames.hasNext()) {
            String name = (String)requiredParamNames.next();
            String value = request.getParameter(name);
            if (value != null && value.length() != 0) continue;
            return true;
        }
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String name = (String)params.nextElement();
            if (!validParamNames.contains(name)) {
                return true;
            }
            if (request.getParameterValues(name).length <= 1) continue;
            return true;
        }
        String identifier = request.getParameter("identifier");
        try {
            if (identifier != null && identifier.length() > 0) {
                new URI(identifier);
            }
        }
        catch (URISyntaxException e) {
            return true;
        }
        return false;
    }

    public String toString() {
        return this.xmlText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String render(HttpServletResponse response, String contentType, String result, Transformer transformer) throws TransformerException {
        String renderedResult = null;
        if (transformer != null) {
            response.setContentType("text/html; charset=UTF-8");
            StringReader stringReader = new StringReader(result);
            StreamSource streamSource = new StreamSource(stringReader);
            StringWriter stringWriter = new StringWriter();
            Transformer transformer2 = transformer;
            synchronized (transformer2) {
                transformer.transform(streamSource, new StreamResult(stringWriter));
            }
            renderedResult = stringWriter.toString();
        } else {
            response.setContentType(contentType);
            renderedResult = result;
        }
        return renderedResult;
    }

    public static HashMap getVerbs(Properties properties) {
        HashMap<String, Class> serverVerbsMap = new HashMap<String, Class>();
        serverVerbsMap.put("ListRecords", class$ORG$oclc$oai$server$verb$ListRecords == null ? (class$ORG$oclc$oai$server$verb$ListRecords = ServerVerb.class$("ORG.oclc.oai.server.verb.ListRecords")) : class$ORG$oclc$oai$server$verb$ListRecords);
        serverVerbsMap.put("ListIdentifiers", class$ORG$oclc$oai$server$verb$ListIdentifiers == null ? (class$ORG$oclc$oai$server$verb$ListIdentifiers = ServerVerb.class$("ORG.oclc.oai.server.verb.ListIdentifiers")) : class$ORG$oclc$oai$server$verb$ListIdentifiers);
        serverVerbsMap.put("GetRecord", class$ORG$oclc$oai$server$verb$GetRecord == null ? (class$ORG$oclc$oai$server$verb$GetRecord = ServerVerb.class$("ORG.oclc.oai.server.verb.GetRecord")) : class$ORG$oclc$oai$server$verb$GetRecord);
        serverVerbsMap.put("Identify", class$ORG$oclc$oai$server$verb$Identify == null ? (class$ORG$oclc$oai$server$verb$Identify = ServerVerb.class$("ORG.oclc.oai.server.verb.Identify")) : class$ORG$oclc$oai$server$verb$Identify);
        serverVerbsMap.put("ListMetadataFormats", class$ORG$oclc$oai$server$verb$ListMetadataFormats == null ? (class$ORG$oclc$oai$server$verb$ListMetadataFormats = ServerVerb.class$("ORG.oclc.oai.server.verb.ListMetadataFormats")) : class$ORG$oclc$oai$server$verb$ListMetadataFormats);
        serverVerbsMap.put("ListSets", class$ORG$oclc$oai$server$verb$ListSets == null ? (class$ORG$oclc$oai$server$verb$ListSets = ServerVerb.class$("ORG.oclc.oai.server.verb.ListSets")) : class$ORG$oclc$oai$server$verb$ListSets);
        return serverVerbsMap;
    }

    public static HashMap getExtensionVerbs(Properties properties) {
        HashMap extensionVerbsMap = new HashMap();
        String propertyPrefix = "ExtensionVerbs.";
        Enumeration<?> propNames = properties.propertyNames();
        while (propNames.hasMoreElements()) {
            String propertyName = (String)propNames.nextElement();
            if (!propertyName.startsWith(propertyPrefix)) continue;
            String verb = propertyName.substring(propertyPrefix.length());
            String verbClassName = (String)properties.get(propertyName);
            try {
                Class<?> serverVerbClass = Class.forName(verbClassName);
                Method init = serverVerbClass.getMethod("init", class$java$util$Properties == null ? ServerVerb.class$("java.util.Properties") : class$java$util$Properties);
                try {
                    init.invoke(null, properties);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
                extensionVerbsMap.put(verb, serverVerbClass);
            }
            catch (Throwable e) {
                System.err.println("ExtensionVerb: couldn't construct: " + verbClassName);
                e.printStackTrace();
            }
        }
        return extensionVerbsMap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

