/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.navigation.paging;

import org.apache.wicket.Page;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.navigation.paging.IPageable;

public class PagingNavigationLink<T>
extends Link<T> {
    private static final long serialVersionUID = 1L;
    protected final IPageable pageable;
    private final long pageNumber;

    public PagingNavigationLink(String id, IPageable pageable, long pageNumber) {
        super(id);
        this.setAutoEnable(true);
        this.pageNumber = pageNumber;
        this.pageable = pageable;
    }

    @Override
    public void onClick() {
        this.pageable.setCurrentPage(this.getPageNumber());
    }

    public final long getPageNumber() {
        return this.cullPageNumber(this.pageNumber);
    }

    protected long cullPageNumber(long pageNumber) {
        long idx = pageNumber;
        if (idx < 0L) {
            idx = this.pageable.getPageCount() + idx;
        }
        if (idx > this.pageable.getPageCount() - 1L) {
            idx = this.pageable.getPageCount() - 1L;
        }
        if (idx < 0L) {
            idx = 0L;
        }
        return idx;
    }

    public final boolean isFirst() {
        return this.getPageNumber() == 0L;
    }

    public final boolean isLast() {
        return this.getPageNumber() == this.pageable.getPageCount() - 1L;
    }

    @Override
    public final boolean linksTo(Page page) {
        return this.getPageNumber() == this.pageable.getCurrentPage();
    }
}

