/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.solr.search.function.ConstNumberSource;
import org.apache.solr.search.function.DocValues;

public class ConstValueSource
extends ConstNumberSource {
    final float constant;
    private final double dv;

    public ConstValueSource(float constant) {
        this.constant = constant;
        this.dv = constant;
    }

    public String description() {
        return "const(" + this.constant + ")";
    }

    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        return new DocValues(){

            public float floatVal(int doc) {
                return ConstValueSource.this.constant;
            }

            public int intVal(int doc) {
                return (int)ConstValueSource.this.constant;
            }

            public long longVal(int doc) {
                return (long)ConstValueSource.this.constant;
            }

            public double doubleVal(int doc) {
                return ConstValueSource.this.dv;
            }

            public String strVal(int doc) {
                return Float.toString(ConstValueSource.this.constant);
            }

            public String toString(int doc) {
                return ConstValueSource.this.description();
            }
        };
    }

    public int hashCode() {
        return Float.floatToIntBits(this.constant) * 31;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConstValueSource)) {
            return false;
        }
        ConstValueSource other = (ConstValueSource)o;
        return this.constant == other.constant;
    }

    public int getInt() {
        return (int)this.constant;
    }

    public long getLong() {
        return (long)this.constant;
    }

    public float getFloat() {
        return this.constant;
    }

    public double getDouble() {
        return this.dv;
    }

    public Number getNumber() {
        return Float.valueOf(this.constant);
    }
}

