/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function.distance;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.spatial.geohash.GeoHashUtils;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;

public class GeohashFunction
extends ValueSource {
    protected ValueSource lat;
    protected ValueSource lon;

    public GeohashFunction(ValueSource lat, ValueSource lon) {
        this.lat = lat;
        this.lon = lon;
    }

    protected String name() {
        return "geohash";
    }

    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        final DocValues latDV = this.lat.getValues(context, reader);
        final DocValues lonDV = this.lon.getValues(context, reader);
        return new DocValues(){

            public String strVal(int doc) {
                return GeoHashUtils.encode((double)latDV.doubleVal(doc), (double)lonDV.doubleVal(doc));
            }

            public String toString(int doc) {
                StringBuilder sb = new StringBuilder();
                sb.append(GeohashFunction.this.name()).append('(');
                sb.append(latDV.toString(doc)).append(',').append(lonDV.toString(doc));
                sb.append(')');
                return sb.toString();
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeohashFunction)) {
            return false;
        }
        GeohashFunction that = (GeohashFunction)o;
        if (!this.lat.equals(that.lat)) {
            return false;
        }
        return this.lon.equals(that.lon);
    }

    public int hashCode() {
        int result = this.lat.hashCode();
        result = 29 * result - this.lon.hashCode();
        return result;
    }

    public String description() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name()).append('(');
        sb.append(this.lat).append(',').append(this.lon);
        sb.append(')');
        return sb.toString();
    }
}

