/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import com.vividsolutions.jts.geom.Geometry;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.indexed.IndexType;
import org.geotools.data.shapefile.indexed.IndexedShapefileDataStore;
import org.geotools.util.KVP;
import org.geotools.util.logging.Logging;

public class ShapefileDataStoreFactory
implements FileDataStoreFactorySpi {
    public static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.shapefile");
    public static final DataAccessFactory.Param URLP = new DataAccessFactory.Param("url", (Class)URL.class, "url to a .shp file", true, (Object)null, (Map<String, ?>)new KVP(new Object[]{"ext", "shp"}));
    public static final DataAccessFactory.Param NAMESPACEP = new DataAccessFactory.Param("namespace", (Class)URI.class, "uri to a the namespace", false, (Object)null, (Map<String, ?>)new KVP(new Object[]{"level", "advanced"}));
    public static final DataAccessFactory.Param MEMORY_MAPPED = new DataAccessFactory.Param("memory mapped buffer", (Class)Boolean.class, "enable/disable the use of memory-mapped io", false, (Object)true, (Map<String, ?>)new KVP(new Object[]{"level", "advanced"}));
    public static final DataAccessFactory.Param CREATE_SPATIAL_INDEX = new DataAccessFactory.Param("create spatial index", (Class)Boolean.class, "enable/disable the automatic creation of spatial index", false, (Object)true, (Map<String, ?>)new KVP(new Object[]{"level", "advanced"}));
    public static final DataAccessFactory.Param DBFCHARSET = new DataAccessFactory.Param("charset", (Class)Charset.class, "character used to decode strings from the DBF file", false, (Object)Charset.forName("ISO-8859-1"), (Map)new KVP(new Object[]{"level", "advanced"})){

        public Object parse(String text) throws IOException {
            return Charset.forName(text);
        }

        public String text(Object value) {
            return ((Charset)value).name();
        }
    };

    public boolean canProcess(Map params) {
        boolean accept = false;
        if (params.containsKey(ShapefileDataStoreFactory.URLP.key)) {
            try {
                URL url = (URL)URLP.lookUp(params);
                accept = this.canProcess(url);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return accept;
    }

    public ShapefileDataStore createDataStore(Map params) throws IOException {
        ShpFiles shpFiles;
        boolean isLocal;
        URL url = (URL)URLP.lookUp(params);
        Boolean isMemoryMapped = (Boolean)MEMORY_MAPPED.lookUp(params);
        URI namespace = (URI)NAMESPACEP.lookUp(params);
        Charset dbfCharset = (Charset)DBFCHARSET.lookUp(params);
        Boolean isCreateSpatialIndex = (Boolean)CREATE_SPATIAL_INDEX.lookUp(params);
        if (isCreateSpatialIndex == null) {
            isCreateSpatialIndex = Boolean.TRUE;
        }
        if (dbfCharset == null) {
            dbfCharset = Charset.forName("ISO-8859-1");
        }
        if (isMemoryMapped == null) {
            isMemoryMapped = Boolean.FALSE;
        }
        if ((isLocal = (shpFiles = new ShpFiles(url)).isLocal()) && !shpFiles.exists(ShpFileType.SHP)) {
            throw new FileNotFoundException("Shapefile not found:" + shpFiles.get(ShpFileType.SHP));
        }
        boolean useMemoryMappedBuffer = isLocal && shpFiles.exists(ShpFileType.SHP) && isMemoryMapped != false;
        boolean createIndex = isCreateSpatialIndex != false && isLocal;
        IndexType treeIndex = IndexType.NONE;
        if (isLocal) {
            if (createIndex) {
                treeIndex = IndexType.QIX;
            } else if (shpFiles.exists(ShpFileType.QIX)) {
                treeIndex = IndexType.QIX;
            }
        }
        try {
            if (createIndex) {
                return new IndexedShapefileDataStore(url, namespace, useMemoryMappedBuffer, createIndex, IndexType.QIX, dbfCharset);
            }
            if (treeIndex != IndexType.NONE) {
                return new IndexedShapefileDataStore(url, namespace, useMemoryMappedBuffer, false, treeIndex, dbfCharset);
            }
            return new ShapefileDataStore(url, namespace, useMemoryMappedBuffer, dbfCharset);
        }
        catch (MalformedURLException mue) {
            throw new DataSourceException("Url for shapefile malformed: " + url, mue);
        }
    }

    public FileDataStore createNewDataStore(Map params) throws IOException {
        ShpFiles shpFiles;
        boolean isLocal;
        URL url = (URL)URLP.lookUp(params);
        Boolean isMemoryMapped = (Boolean)MEMORY_MAPPED.lookUp(params);
        URI namespace = (URI)NAMESPACEP.lookUp(params);
        Charset dbfCharset = (Charset)DBFCHARSET.lookUp(params);
        Boolean isCreateSpatialIndex = (Boolean)CREATE_SPATIAL_INDEX.lookUp(params);
        if (isCreateSpatialIndex == null) {
            isCreateSpatialIndex = Boolean.TRUE;
        }
        if (dbfCharset == null) {
            dbfCharset = Charset.forName("ISO-8859-1");
        }
        if (isMemoryMapped == null) {
            isMemoryMapped = Boolean.FALSE;
        }
        if (!(isLocal = (shpFiles = new ShpFiles(url)).isLocal()) || shpFiles.exists(ShpFileType.SHP)) {
            LOGGER.warning("File already exists: " + shpFiles.get(ShpFileType.SHP));
        }
        boolean useMemoryMappedBuffer = isLocal && isMemoryMapped != false;
        boolean createIndex = isCreateSpatialIndex != false && isLocal;
        try {
            if (createIndex) {
                return new IndexedShapefileDataStore(url, namespace, useMemoryMappedBuffer, true, IndexType.QIX, dbfCharset);
            }
            return new ShapefileDataStore(url, namespace, useMemoryMappedBuffer, dbfCharset);
        }
        catch (MalformedURLException mue) {
            throw new DataSourceException("Url for shapefile malformed: " + url, mue);
        }
    }

    public String getDisplayName() {
        return "Shapefile";
    }

    public String getDescription() {
        return "ESRI(tm) Shapefiles (*.shp)";
    }

    public boolean isAvailable() {
        try {
            ShapefileDataStore.class.getName();
            IndexedShapefileDataStore.class.getName();
            Geometry.class.getName();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{URLP, NAMESPACEP, CREATE_SPATIAL_INDEX, DBFCHARSET, MEMORY_MAPPED};
    }

    public String[] getFileExtensions() {
        return new String[]{".shp"};
    }

    public boolean canProcess(URL f) {
        return f.getFile().toUpperCase().endsWith("SHP");
    }

    public FileDataStore createDataStore(URL url) throws IOException {
        HashMap<String, URL> params = new HashMap<String, URL>();
        params.put(ShapefileDataStoreFactory.URLP.key, url);
        boolean isLocal = url.getProtocol().equalsIgnoreCase("file");
        if (isLocal && !DataUtilities.urlToFile(url).exists()) {
            return this.createNewDataStore(params);
        }
        return this.createDataStore(params);
    }

    public DataStore createDataStore(URL url, boolean memorymapped) throws IOException {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put(ShapefileDataStoreFactory.URLP.key, url);
        params.put(ShapefileDataStoreFactory.MEMORY_MAPPED.key, new Boolean(memorymapped));
        return this.createDataStore(params);
    }

    public String getTypeName(URL url) throws IOException {
        FileDataStore ds = this.createDataStore(url);
        String[] names = ds.getTypeNames();
        return names == null || names.length == 0 ? null : names[0];
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

