/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core.assembler;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.assemblers.AssemblerGroup;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.assembler.DatasetAssembler;
import com.hp.hpl.jena.sparql.core.assembler.DatasetAssemblerVocab;
import com.hp.hpl.jena.sparql.core.assembler.DatasetNullAssembler;
import com.hp.hpl.jena.sparql.core.assembler.GraphStoreAssembler;
import com.hp.hpl.jena.sparql.mgt.Explain;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.MappingRegistry;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.sparql.util.TypeNotUniqueException;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import com.hp.hpl.jena.util.FileManager;

public class AssemblerUtils {
    private static boolean initialized = false;

    public static PrefixMapping readPrefixMapping(String file) {
        PrefixMapping pm = (PrefixMapping)AssemblerUtils.build(file, JA.PrefixMapping);
        return pm;
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        AssemblerUtils.registerWith(Assembler.general);
    }

    public static void registerWith(AssemblerGroup g) {
        g.implementWith(DatasetAssembler.getType(), (Assembler)new DatasetAssembler());
        g.implementWith(GraphStoreAssembler.getType(), (Assembler)new GraphStoreAssembler());
        g.implementWith(DatasetNullAssembler.getType(), (Assembler)new DatasetNullAssembler());
    }

    private static void assemblerClass(AssemblerGroup g, Resource r, Assembler a) {
        g.implementWith(r, a);
    }

    public static Object build(String assemblerFile, String typeURI) {
        Resource type = ResourceFactory.createResource((String)typeURI);
        return AssemblerUtils.build(assemblerFile, type);
    }

    public static Object build(String assemblerFile, Resource type) {
        if (assemblerFile == null) {
            throw new ARQException("No assembler file");
        }
        Model spec = null;
        try {
            spec = FileManager.get().loadModel(assemblerFile);
        }
        catch (Exception ex) {
            throw new ARQException("Failed reading assembler description: " + ex.getMessage());
        }
        Resource root = null;
        Explain.InfoLevel level = ARQ.getExecutionLogging();
        ARQ.setExecutionLogging(Explain.InfoLevel.NONE);
        try {
            root = GraphUtils.findRootByType(spec, type);
            if (root == null) {
                Object var5_6 = null;
                return var5_6;
            }
        }
        catch (TypeNotUniqueException ex) {
            throw new ARQException("Multiple types for: " + DatasetAssemblerVocab.tDataset);
        }
        finally {
            ARQ.setExecutionLogging(level);
        }
        return Assembler.general.open(root);
    }

    public static void setContext(Resource r, Context context) {
        String qs = "PREFIX ja: <" + JA.getURI() + ">\nSELECT * { ?x ja:context [ ja:cxtName ?name ; ja:cxtValue ?value ] }";
        QuerySolutionMap qsm = new QuerySolutionMap();
        qsm.add("x", (RDFNode)r);
        QueryExecution qExec = QueryExecutionFactory.create(qs, r.getModel(), (QuerySolution)qsm);
        ResultSet rs = qExec.execSelect();
        while (rs.hasNext()) {
            QuerySolution soln = rs.next();
            String name = soln.getLiteral("name").getLexicalForm();
            String value = soln.getLiteral("value").getLexicalForm();
            name = MappingRegistry.mapPrefixName(name);
            Symbol symbol = Symbol.create(name);
            if ("undef".equalsIgnoreCase(value)) {
                context.remove(symbol);
                continue;
            }
            context.set(symbol, value);
        }
    }

    static {
        ARQ.init();
        AssemblerUtils.init();
    }
}

