/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.ButtonBase;
import com.google.gwt.user.client.ui.HasName;

public class CheckBox
extends ButtonBase
implements HasName {
    private static int uniqueId;
    private Element inputElem;
    private Element labelElem;

    public CheckBox() {
        this(DOM.createInputCheck());
        this.setStyleName("gwt-CheckBox");
    }

    public CheckBox(String label) {
        this();
        this.setText(label);
    }

    public CheckBox(String label, boolean asHTML) {
        this();
        if (asHTML) {
            this.setHTML(label);
        } else {
            this.setText(label);
        }
    }

    protected CheckBox(Element elem) {
        super(DOM.createSpan());
        this.inputElem = elem;
        this.labelElem = DOM.createLabel();
        this.unsinkEvents(6145);
        DOM.sinkEvents(this.inputElem, 0x1801 | DOM.getEventsSunk(this.inputElem));
        DOM.appendChild(this.getElement(), this.inputElem);
        DOM.appendChild(this.getElement(), this.labelElem);
        String uid = "check" + ++uniqueId;
        DOM.setAttribute(this.inputElem, "id", uid);
        DOM.setAttribute(this.labelElem, "htmlFor", uid);
    }

    public String getHTML() {
        return DOM.getInnerHTML(this.labelElem);
    }

    public String getName() {
        return DOM.getAttribute(this.inputElem, "name");
    }

    public String getText() {
        return DOM.getInnerText(this.labelElem);
    }

    public boolean isChecked() {
        String propName = this.isAttached() ? "checked" : "defaultChecked";
        return DOM.getBooleanAttribute(this.inputElem, propName);
    }

    public boolean isEnabled() {
        return !DOM.getBooleanAttribute(this.inputElem, "disabled");
    }

    public void setChecked(boolean checked) {
        DOM.setBooleanAttribute(this.inputElem, "checked", checked);
        DOM.setBooleanAttribute(this.inputElem, "defaultChecked", checked);
    }

    public void setEnabled(boolean enabled) {
        DOM.setBooleanAttribute(this.inputElem, "disabled", !enabled);
    }

    public void setFocus(boolean focused) {
        if (focused) {
            CheckBox.getFocusImpl().focus(this.inputElem);
        } else {
            CheckBox.getFocusImpl().blur(this.inputElem);
        }
    }

    public void setHTML(String html) {
        DOM.setInnerHTML(this.labelElem, html);
    }

    public void setName(String name) {
        DOM.setAttribute(this.inputElem, "name", name);
    }

    public void setTabIndex(int index) {
        CheckBox.getFocusImpl().setTabIndex(this.inputElem, index);
    }

    public void setText(String text) {
        DOM.setInnerText(this.labelElem, text);
    }

    protected void onDetach() {
        this.setChecked(this.isChecked());
        super.onDetach();
    }
}

