/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc.impl;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.SerializationStreamReader;
import com.google.gwt.user.client.rpc.impl.AbstractSerializationStreamReader;
import com.google.gwt.user.server.rpc.impl.SerializedInstanceReference;
import com.google.gwt.user.server.rpc.impl.ServerSerializableTypeOracle;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public final class ServerSerializationStreamReader
extends AbstractSerializationStreamReader {
    private ServerSerializableTypeOracle serializableTypeOracle;
    private String[] stringTable;
    private ArrayList tokenList = new ArrayList();
    private int tokenListIndex;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ServerSerializationStreamReader(ServerSerializableTypeOracle serializableTypeOracle) {
        this.serializableTypeOracle = serializableTypeOracle;
    }

    public Object deserializeValue(Class type) throws SerializationException {
        if (type == Boolean.TYPE) {
            return this.readBoolean();
        }
        if (type == Byte.TYPE) {
            return new Byte(this.readByte());
        }
        if (type == Character.TYPE) {
            return new Character(this.readChar());
        }
        if (type == Double.TYPE) {
            return new Double(this.readDouble());
        }
        if (type == Float.TYPE) {
            return new Float(this.readFloat());
        }
        if (type == Integer.TYPE) {
            return new Integer(this.readInt());
        }
        if (type == Long.TYPE) {
            return new Long(this.readLong());
        }
        if (type == Short.TYPE) {
            return new Short(this.readShort());
        }
        if (type == String.class) {
            return this.readString();
        }
        return this.readObject();
    }

    public void prepareToRead(String encodedTokens) throws SerializationException {
        int nextIdx;
        this.tokenList.clear();
        this.tokenListIndex = 0;
        this.stringTable = null;
        int idx = 0;
        while (-1 != (nextIdx = encodedTokens.indexOf(65535, idx))) {
            String current = encodedTokens.substring(idx, nextIdx);
            this.tokenList.add(current);
            idx = nextIdx + 1;
        }
        super.prepareToRead(encodedTokens);
        this.deserializeStringTable();
    }

    public boolean readBoolean() {
        return !this.extract().equals("0");
    }

    public byte readByte() {
        return Byte.parseByte(this.extract());
    }

    public char readChar() {
        return (char)Integer.parseInt(this.extract());
    }

    public double readDouble() {
        return Double.parseDouble(this.extract());
    }

    public float readFloat() {
        return Float.parseFloat(this.extract());
    }

    public int readInt() {
        return Integer.parseInt(this.extract());
    }

    public long readLong() {
        return Long.parseLong(this.extract());
    }

    public short readShort() {
        return Short.parseShort(this.extract());
    }

    public String readString() throws SerializationException {
        return this.getString(this.readInt());
    }

    protected Object deserialize(String typeSignature) throws SerializationException {
        Object instance = null;
        SerializedInstanceReference serializedInstRef = this.serializableTypeOracle.decodeSerializedInstanceReference(typeSignature);
        try {
            Class<?> instanceClass = Class.forName(serializedInstRef.getName(), false, this.getClass().getClassLoader());
            if (!this.serializableTypeOracle.isSerializable(instanceClass)) {
                throw new SerializationException("Class '" + instanceClass.getName() + "' is not serializable");
            }
            this.validateTypeVersions(instanceClass, serializedInstRef);
            Class customSerializer = this.serializableTypeOracle.hasCustomFieldSerializer(instanceClass);
            instance = this.instantiate(customSerializer, instanceClass);
            this.rememberDecodedObject(instance);
            this.deserializeImpl(customSerializer, instanceClass, instance);
            return instance;
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException(e);
        }
        catch (InstantiationException e) {
            throw new SerializationException(e);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException(e);
        }
        catch (IllegalArgumentException e) {
            throw new SerializationException(e);
        }
        catch (InvocationTargetException e) {
            throw new SerializationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new SerializationException(e);
        }
    }

    protected String getString(int index) {
        if (index == 0) {
            return null;
        }
        if (!$assertionsDisabled && index <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && index > this.stringTable.length) {
            throw new AssertionError();
        }
        return this.stringTable[index - 1];
    }

    private void deserializeImpl(Class customSerializer, Class instanceClass, Object instance) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, SerializationException, ClassNotFoundException {
        if (customSerializer != null) {
            this.deserializeWithCustomFieldDeserializer(customSerializer, instanceClass, instance);
        } else {
            this.deserializeWithDefaultFieldDeserializer(instanceClass, instance);
        }
    }

    private void deserializeStringTable() {
        int typeNameCount = this.readInt();
        this.stringTable = new String[typeNameCount];
        for (int typeNameIndex = 0; typeNameIndex < typeNameCount; ++typeNameIndex) {
            this.stringTable[typeNameIndex] = this.extract();
        }
    }

    private void deserializeWithCustomFieldDeserializer(Class customSerializer, Class instanceClass, Object instance) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> componentType;
        if (instanceClass.isArray() && !(componentType = instanceClass.getComponentType()).isPrimitive()) {
            instanceClass = Class.forName("[Ljava.lang.Object;");
        }
        Method deserialize = customSerializer.getMethod("deserialize", SerializationStreamReader.class, instanceClass);
        deserialize.invoke(null, this, instance);
    }

    private void deserializeWithDefaultFieldDeserializer(Class instanceClass, Object instance) throws SerializationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        Field[] declFields = instanceClass.getDeclaredFields();
        Field[] serializableFields = this.serializableTypeOracle.applyFieldSerializationPolicy(declFields);
        for (int index = 0; index < serializableFields.length; ++index) {
            boolean needsAccessOverride;
            Field declField = serializableFields[index];
            if (!$assertionsDisabled && declField == null) {
                throw new AssertionError();
            }
            Object value = this.deserializeValue(declField.getType());
            boolean isAccessible = declField.isAccessible();
            boolean bl = needsAccessOverride = !isAccessible && !Modifier.isPublic(declField.getModifiers());
            if (needsAccessOverride) {
                declField.setAccessible(true);
            }
            declField.set(instance, value);
            if (!needsAccessOverride) continue;
            declField.setAccessible(isAccessible);
        }
        Class superClass = instanceClass.getSuperclass();
        if (superClass != null && this.serializableTypeOracle.isSerializable(superClass)) {
            this.deserializeImpl(this.serializableTypeOracle.hasCustomFieldSerializer(superClass), superClass, instance);
        }
    }

    private String extract() {
        return (String)this.tokenList.get(this.tokenListIndex++);
    }

    private Object instantiate(Class customSerializer, Class instanceClass) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (customSerializer != null) {
            try {
                Method instantiate = customSerializer.getMethod("instantiate", SerializationStreamReader.class);
                return instantiate.invoke(null, this);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (instanceClass.isArray()) {
            int length = this.readInt();
            Class<?> componentType = instanceClass.getComponentType();
            return Array.newInstance(componentType, length);
        }
        return instanceClass.newInstance();
    }

    private void validateTypeVersions(Class instanceClass, SerializedInstanceReference serializedInstRef) throws SerializationException {
        String clientTypeSignature = serializedInstRef.getSignature();
        if (clientTypeSignature.length() == 0) {
            if (this.shouldEnforceTypeVersioning()) {
                throw new SerializationException();
            }
            return;
        }
        String serverTypeSignature = this.serializableTypeOracle.getSerializationSignature(instanceClass);
        if (!clientTypeSignature.equals(serverTypeSignature)) {
            throw new SerializationException("Invalid type signature for " + instanceClass.getName());
        }
    }

    static {
        $assertionsDisabled = !ServerSerializationStreamReader.class.desiredAssertionStatus();
    }
}

