/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.common.query;

import edu.ucsb.nceas.metacat.common.query.SolrQueryResponseTransformer;
import edu.ucsb.nceas.metacat.common.query.SolrQueryService;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.XML;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.servlet.SolrRequestParsers;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Subject;
import org.xml.sax.SAXException;

public class EmbeddedSolrQueryService
extends SolrQueryService {
    private EmbeddedSolrServer solrServer = null;
    private CoreContainer coreContainer = null;
    private String collectionName = null;
    private SolrCore solrCore = null;

    public EmbeddedSolrQueryService(EmbeddedSolrServer solrServer, CoreContainer coreContainer, String collectionName) throws NotFound {
        if (solrServer == null) {
            throw new NullPointerException("EmbeddedSolrQueryService.constructor - the EmbeddedSolrServer parameter can't be null.");
        }
        if (coreContainer == null) {
            throw new NullPointerException("EmbeddedSolrQueryService.constructor - the CoreContainer parameter can't be null.");
        }
        if (collectionName == null || collectionName.trim().equals("")) {
            throw new NullPointerException("EmbeddedSolrQueryService.constructor - the name of Collection parameter can't be null or empty.");
        }
        this.solrServer = solrServer;
        this.coreContainer = coreContainer;
        this.collectionName = collectionName;
        this.solrCore = this.coreContainer.getCore(collectionName);
        if (this.solrCore == null) {
            throw new NotFound("0000", "EmbeddedSolrQueryService.constructor - There is no SolrCore named " + collectionName + ".");
        }
        this.schema = this.solrCore.getSchema();
        this.fieldMap = this.schema.getFields();
    }

    @Override
    public InputStream query(SolrParams query, Set<Subject> subjects) throws ParserConfigurationException, IOException, SAXException, SolrServerException, UnsupportedType {
        InputStream inputStream = null;
        String wt = query.get("wt");
        query = this.appendAccessFilterParams(query, subjects);
        SolrQueryResponseTransformer solrTransformer = new SolrQueryResponseTransformer(this.solrCore);
        if (!EmbeddedSolrQueryService.isSupportedWT(wt)) {
            throw new UnsupportedType("0000", "EmbeddSolrQueryService.query - the wt type " + wt + " in the solr query is not supported");
        }
        this.coreContainer.reload(this.collectionName);
        QueryResponse response = this.solrServer.query(query);
        inputStream = solrTransformer.transformResults(query, response, wt);
        return inputStream;
    }

    @Override
    public Map<String, SchemaField> getIndexSchemaFields() {
        return this.fieldMap;
    }

    public List<String> getValidSchemaField() {
        return super.getValidSchemaFields();
    }

    @Override
    public String getSolrServerVersion() {
        if (this.solrSpecVersion != null) {
            return this.solrSpecVersion;
        }
        Package p = SolrCore.class.getPackage();
        StringWriter tmp = new StringWriter();
        this.solrSpecVersion = p.getSpecificationVersion();
        if (null != this.solrSpecVersion) {
            try {
                XML.escapeCharData((String)this.solrSpecVersion, (Writer)tmp);
                this.solrSpecVersion = tmp.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.solrSpecVersion == null || this.solrSpecVersion.trim().equals("")) {
            this.solrSpecVersion = "Unknown";
        }
        return this.solrSpecVersion;
    }

    public boolean hasSolrDoc(Identifier id) throws ParserConfigurationException, SolrServerException, IOException, SAXException {
        boolean hasIt = false;
        if (id != null && id.getValue() != null && !id.getValue().trim().equals("")) {
            SolrParams query = EmbeddedSolrQueryService.buildIdQuery(id.getValue());
            this.coreContainer.reload(this.collectionName);
            QueryResponse response = this.solrServer.query(query);
            hasIt = EmbeddedSolrQueryService.hasResult(response);
        }
        return hasIt;
    }

    public static SolrParams buildIdQuery(String id) {
        String query = "select?q=id:" + id;
        query = query.replaceAll("\\+", "%2B");
        MultiMapSolrParams solrParams = SolrRequestParsers.parseQueryString((String)query);
        return solrParams;
    }

    public static boolean hasResult(QueryResponse response) {
        SolrDocumentList list;
        boolean hasResult = false;
        if (response != null && (list = response.getResults()) != null && list.getNumFound() > 0L) {
            hasResult = true;
        }
        return hasResult;
    }
}

