/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.common.query;

import edu.ucsb.nceas.metacat.common.SolrServerFactory;
import edu.ucsb.nceas.metacat.common.query.EmbeddedSolrQueryService;
import edu.ucsb.nceas.metacat.common.query.HttpSolrQueryService;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Subject;
import org.xml.sax.SAXException;

public class SolrQueryServiceController {
    private static SolrQueryServiceController controller = null;
    private boolean isEmbeddedSolrServer = false;
    private EmbeddedSolrQueryService embeddedQueryService = null;
    private HttpSolrQueryService httpQueryService = null;

    private SolrQueryServiceController() throws UnsupportedType, ParserConfigurationException, IOException, SAXException, NotFound {
        SolrServer solrServer = SolrServerFactory.createSolrServer();
        if (solrServer instanceof EmbeddedSolrServer) {
            this.isEmbeddedSolrServer = true;
            EmbeddedSolrServer embeddedServer = (EmbeddedSolrServer)solrServer;
            CoreContainer coreContainer = SolrServerFactory.getCoreContainer();
            String collectionName = SolrServerFactory.getCollectionName();
            this.embeddedQueryService = new EmbeddedSolrQueryService(embeddedServer, coreContainer, collectionName);
        } else {
            this.isEmbeddedSolrServer = false;
            CommonsHttpSolrServer httpServer = (CommonsHttpSolrServer)solrServer;
            this.httpQueryService = new HttpSolrQueryService(httpServer);
        }
    }

    public static SolrQueryServiceController getInstance() throws UnsupportedType, NotFound, ParserConfigurationException, IOException, SAXException {
        if (controller == null) {
            controller = new SolrQueryServiceController();
        }
        return controller;
    }

    public InputStream query(SolrParams params, Set<Subject> subjects) throws NotImplemented, NotFound, IOException, UnsupportedType, ParserConfigurationException, SAXException, SolrServerException {
        if (this.isEmbeddedSolrServer) {
            return this.embeddedQueryService.query(params, subjects);
        }
        return this.httpQueryService.query(params, subjects);
    }

    public String getSolrSpecVersion() {
        if (this.isEmbeddedSolrServer) {
            return this.embeddedQueryService.getSolrServerVersion();
        }
        return this.httpQueryService.getSolrServerVersion();
    }

    public Map<String, SchemaField> getIndexSchemaFields() throws MalformedURLException, ParserConfigurationException, IOException, SAXException {
        if (this.isEmbeddedSolrServer) {
            return this.embeddedQueryService.getIndexSchemaFields();
        }
        return this.httpQueryService.getIndexSchemaFields();
    }

    public IndexSchema getSchema() throws MalformedURLException, ParserConfigurationException, IOException, SAXException {
        if (this.isEmbeddedSolrServer) {
            return this.embeddedQueryService.getSchema();
        }
        return this.httpQueryService.getSchema();
    }

    public boolean isEmbeddedSolrServer() {
        return this.isEmbeddedSolrServer;
    }

    public boolean hasSolrDoc(Identifier id) throws ParserConfigurationException, SolrServerException, IOException, SAXException {
        if (this.isEmbeddedSolrServer) {
            return this.embeddedQueryService.hasSolrDoc(id);
        }
        return this.httpQueryService.hasSolrDoc(id);
    }
}

