/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.types.v2.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.NodeState;
import org.dataone.service.types.v1.NodeType;
import org.dataone.service.types.v1.Service;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.NodeList;
import org.dataone.service.util.TypeMarshaller;
import org.jibx.runtime.JiBXException;

public class NodelistUtil {
    public static Map<String, String> mapNodeList(InputStream nodeListStream) throws InstantiationException, IllegalAccessException, JiBXException, IOException {
        NodeList nodeList = TypeMarshaller.unmarshalTypeFromStream(NodeList.class, nodeListStream);
        return NodelistUtil.mapNodeList(nodeList);
    }

    public static Map<String, String> mapNodeList(NodeList nodeList) {
        ConcurrentHashMap<String, String> baseUrlMap = new ConcurrentHashMap<String, String>();
        for (Node node : nodeList.getNodeList()) {
            baseUrlMap.put(node.getIdentifier().getValue(), node.getBaseURL());
        }
        return baseUrlMap;
    }

    public static Node findNode(NodeList nodeList, NodeReference nodeRef) {
        Node node = null;
        for (int i = 0; i < nodeList.sizeNodeList() && !(node = nodeList.getNode(i)).getIdentifier().equals(nodeRef); ++i) {
            node = null;
        }
        return node;
    }

    public static Set<Node> selectNode(NodeList nodeList, Subject subject) {
        HashSet<Node> nodeSet = new HashSet<Node>();
        for (int i = 0; i < nodeList.sizeNodeList(); ++i) {
            Node node = nodeList.getNode(i);
            if (!node.getSubjectList().contains(subject)) continue;
            nodeSet.add(node);
        }
        return nodeSet;
    }

    public static Set<Node> selectNodes(NodeList nodeList, NodeType nodeType) {
        HashSet<Node> nodeSet = new HashSet<Node>();
        for (int i = 0; i < nodeList.sizeNodeList(); ++i) {
            Node node = nodeList.getNode(i);
            if (nodeType == null) {
                nodeSet.add(node);
                continue;
            }
            if (node.getType() != nodeType) continue;
            nodeSet.add(node);
        }
        return nodeSet;
    }

    public static Set<Node> selectNodes(NodeList nodeList, NodeState nodeState) {
        HashSet<Node> nodeSet = new HashSet<Node>();
        for (int i = 0; i < nodeList.sizeNodeList(); ++i) {
            Node node = nodeList.getNode(i);
            if (nodeState == null) {
                nodeSet.add(node);
                continue;
            }
            if (node.getState() != nodeState) continue;
            nodeSet.add(node);
        }
        return nodeSet;
    }

    public static Set<Node> selectNodesByService(NodeList nodeList, String serviceName, String version, boolean isAvailable) {
        HashSet<Node> nodeSet = new HashSet<Node>();
        block0: for (int i = 0; i < nodeList.sizeNodeList(); ++i) {
            Node node = nodeList.getNode(i);
            for (Service service : node.getServices().getServiceList()) {
                if (!service.getName().equalsIgnoreCase(serviceName)) continue;
                boolean availability = true;
                if (service.getAvailable() != null) {
                    availability = service.getAvailable();
                }
                if (availability != isAvailable) continue;
                if (version != null) {
                    if (!service.getVersion().equalsIgnoreCase(version)) continue;
                    nodeSet.add(node);
                    continue;
                }
                nodeSet.add(node);
                continue block0;
            }
        }
        return nodeSet;
    }
}

