/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.util.ArrayList;
import java.util.List;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.RRset;

public class SetResponse {
    static final byte UNKNOWN = 0;
    static final byte NXDOMAIN = 1;
    static final byte NXRRSET = 2;
    static final byte DELEGATION = 3;
    static final byte CNAME = 4;
    static final byte DNAME = 5;
    static final byte SUCCESSFUL = 6;
    private static final SetResponse unknown = new SetResponse(0);
    private static final SetResponse nxdomain = new SetResponse(1);
    private static final SetResponse nxrrset = new SetResponse(2);
    private byte type;
    private Object data;

    private SetResponse() {
    }

    SetResponse(byte type, RRset rrset) {
        if (type < 0 || type > 6) {
            throw new IllegalArgumentException("invalid type");
        }
        this.type = type;
        this.data = rrset;
    }

    SetResponse(byte type) {
        if (type < 0 || type > 6) {
            throw new IllegalArgumentException("invalid type");
        }
        this.type = type;
        this.data = null;
    }

    static SetResponse ofType(byte type) {
        switch (type) {
            case 0: {
                return unknown;
            }
            case 1: {
                return nxdomain;
            }
            case 2: {
                return nxrrset;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                SetResponse sr = new SetResponse();
                sr.type = type;
                sr.data = null;
                return sr;
            }
        }
        throw new IllegalArgumentException("invalid type");
    }

    void addRRset(RRset rrset) {
        if (this.data == null) {
            this.data = new ArrayList();
        }
        List l = (List)this.data;
        l.add(rrset);
    }

    public boolean isUnknown() {
        return this.type == 0;
    }

    public boolean isNXDOMAIN() {
        return this.type == 1;
    }

    public boolean isNXRRSET() {
        return this.type == 2;
    }

    public boolean isDelegation() {
        return this.type == 3;
    }

    public boolean isCNAME() {
        return this.type == 4;
    }

    public boolean isDNAME() {
        return this.type == 5;
    }

    public boolean isSuccessful() {
        return this.type == 6;
    }

    public RRset[] answers() {
        if (this.type != 6) {
            return null;
        }
        List l = (List)this.data;
        return l.toArray(new RRset[l.size()]);
    }

    public CNAMERecord getCNAME() {
        return (CNAMERecord)((RRset)this.data).first();
    }

    public DNAMERecord getDNAME() {
        return (DNAMERecord)((RRset)this.data).first();
    }

    public RRset getNS() {
        return (RRset)this.data;
    }

    public String toString() {
        switch (this.type) {
            case 0: {
                return "unknown";
            }
            case 1: {
                return "NXDOMAIN";
            }
            case 2: {
                return "NXRRSET";
            }
            case 3: {
                return "delegation: " + this.data;
            }
            case 4: {
                return "CNAME: " + this.data;
            }
            case 5: {
                return "DNAME: " + this.data;
            }
            case 6: {
                return "successful";
            }
        }
        return null;
    }
}

