/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

public final class TTL {
    private TTL() {
    }

    public static int parseTTL(String s) throws NumberFormatException {
        if (s == null || !Character.isDigit(s.charAt(0))) {
            throw new NumberFormatException();
        }
        int value = 0;
        int ttl = 0;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (Character.isDigit(c)) {
                value = value * 10 + Character.getNumericValue(c);
            } else {
                switch (Character.toUpperCase(c)) {
                    case 'W': {
                        value *= 7;
                    }
                    case 'D': {
                        value *= 24;
                    }
                    case 'H': {
                        value *= 60;
                    }
                    case 'M': {
                        value *= 60;
                    }
                    case 'S': {
                        break;
                    }
                    default: {
                        throw new NumberFormatException();
                    }
                }
                ttl += value;
                value = 0;
            }
            ++i;
        }
        if (ttl == 0) {
            ttl = value;
        }
        return ttl;
    }

    public static String format(int ttl) {
        StringBuffer sb = new StringBuffer();
        int secs = ttl % 60;
        int mins = (ttl /= 60) % 60;
        int hours = (ttl /= 60) % 24;
        int days = (ttl /= 24) % 7;
        int weeks = ttl /= 7;
        if (weeks > 0) {
            sb.append(weeks + "W");
        }
        if (days > 0) {
            sb.append(days + "D");
        }
        if (hours > 0) {
            sb.append(hours + "H");
        }
        if (mins > 0) {
            sb.append(mins + "M");
        }
        if (secs > 0 || weeks == 0 && days == 0 && hours == 0 && mins == 0) {
            sb.append(secs + "S");
        }
        return sb.toString();
    }
}

