/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.security;

import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xbill.DNS.Cache;
import org.xbill.DNS.DNSSEC;
import org.xbill.DNS.KEYRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.RRset;
import org.xbill.DNS.SIGRecord;
import org.xbill.DNS.Type;
import org.xbill.DNS.Verifier;
import org.xbill.DNS.security.DSASignature;
import org.xbill.DNS.security.KEYConverter;
import org.xbill.DNS.utils.DataByteOutputStream;

public class DNSSECVerifier
implements Verifier {
    private Map trustedKeys = new HashMap();

    public synchronized void addTrustedKey(KEYRecord key) {
        Name name = key.getName();
        LinkedList<KEYRecord> list = (LinkedList<KEYRecord>)this.trustedKeys.get(name);
        if (list == null) {
            list = new LinkedList<KEYRecord>();
            this.trustedKeys.put(name, list);
        }
        list.add(key);
    }

    public void addTrustedKey(Name name, PublicKey key) {
        KEYRecord keyrec = KEYConverter.buildRecord(name, (short)1, 0, 0, 3, key);
        if (keyrec != null) {
            this.addTrustedKey(keyrec);
        }
    }

    private PublicKey findMatchingKey(Iterator it, int algorithm, int footprint) {
        while (it.hasNext()) {
            KEYRecord keyrec = (KEYRecord)it.next();
            if (keyrec.getAlgorithm() != algorithm || keyrec.getFootprint() != footprint) continue;
            return KEYConverter.parseRecord(keyrec);
        }
        return null;
    }

    private synchronized PublicKey findTrustedKey(Name name, int algorithm, int footprint) {
        List list = (List)this.trustedKeys.get(name);
        if (list == null) {
            return null;
        }
        return this.findMatchingKey(list.iterator(), algorithm, footprint);
    }

    private PublicKey findCachedKey(Cache cache, Name name, int algorithm, int footprint) {
        RRset[] keysets = cache.findAnyRecords(name, (short)25);
        if (keysets == null) {
            return null;
        }
        RRset keys = keysets[0];
        if (keys.getSecurity() < 1) {
            return null;
        }
        return this.findMatchingKey(keys.rrs(), algorithm, footprint);
    }

    private PublicKey findKey(Cache cache, Name name, int algorithm, int footprint) {
        PublicKey key = this.findTrustedKey(name, algorithm, footprint);
        if (key == null && cache != null) {
            return this.findCachedKey(cache, name, algorithm, footprint);
        }
        return key;
    }

    private byte verifySIG(RRset set, SIGRecord sigrec, Cache cache) {
        String algString;
        byte[] sig;
        PublicKey key = this.findKey(cache, sigrec.getSigner(), sigrec.getAlgorithm(), sigrec.getFootprint());
        if (key == null) {
            return 0;
        }
        DataByteOutputStream out = new DataByteOutputStream();
        Date now = new Date();
        if (now.compareTo(sigrec.getExpire()) > 0 || now.compareTo(sigrec.getTimeSigned()) < 0) {
            System.err.println("Outside of validity period");
            return -1;
        }
        byte[] data = DNSSEC.digestRRset(sigrec, set);
        switch (sigrec.getAlgorithm()) {
            case 1: {
                sig = sigrec.getSignature();
                algString = "MD5withRSA";
                break;
            }
            case 3: {
                sig = DSASignature.create(sigrec);
                algString = "SHA1withDSA";
                break;
            }
            case 5: {
                sig = sigrec.getSignature();
                algString = "SHA1withRSA";
                break;
            }
            default: {
                return -1;
            }
        }
        try {
            Signature s = Signature.getInstance(algString);
            s.initVerify(key);
            s.update(data);
            return s.verify(sig) ? (byte)1 : -1;
        }
        catch (GeneralSecurityException e) {
            if (Options.check("verboseexceptions")) {
                System.err.println("Signing data: " + e);
            }
            return -1;
        }
    }

    /*
     * Unable to fully structure code
     */
    public byte verify(RRset set, Cache cache) {
        sigs = set.sigs();
        if (Options.check("verbosesec")) {
            System.out.print("Verifying " + set.getName() + "/" + Type.string(set.getType()) + ": ");
        }
        if (sigs.hasNext()) ** GOTO lbl13
        if (Options.check("verbosesec")) {
            System.out.println("Insecure");
        }
        return 0;
lbl-1000:
        // 1 sources

        {
            sigrec = (SIGRecord)sigs.next();
            if (this.verifySIG(set, sigrec, cache) != 1) continue;
            if (Options.check("verbosesec")) {
                System.out.println("Secure");
            }
            return 1;
lbl13:
            // 2 sources

            ** while (sigs.hasNext())
        }
lbl14:
        // 1 sources

        if (Options.check("verbosesec")) {
            System.out.println("Failed");
        }
        return -1;
    }
}

