/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.server.impl;

import com.ibm.lsid.LSID;
import com.ibm.lsid.MalformedLSIDException;
import com.ibm.lsid.MetadataResponse;
import com.ibm.lsid.server.LSIDMetadataService;
import com.ibm.lsid.server.LSIDRequestContext;
import com.ibm.lsid.server.LSIDServerException;
import com.ibm.lsid.server.LSIDServiceConfig;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import javax.xml.transform.TransformerException;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class InlineMetadataService
implements LSIDMetadataService {
    public static final String NAMESPACE = "http://www.ibm.com/LSID/Standard/msdl";
    public static final String PREFIX = "msdl";
    public static final String ROOT = "metadata";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final String LSID_ELT = "lsid";
    private static final String LOCATION_ATTR = "location";
    private static final String URI_ATTR = "uri";
    private static final String FORMAT_ATTR = "format";
    private static final String EXPIRES_ATTR = "expires";
    private static final String INLINE = "inline";
    private static final String FILE = "file";
    private static final String URL = "url";
    private Hashtable metadata = new Hashtable();

    public void load(URL uri) throws LSIDServerException {
        try {
            this.load(uri.openStream());
        }
        catch (IOException e) {
            throw new LSIDServerException(e, "Error getting MSDL at: " + uri);
        }
    }

    public void load(File file) throws LSIDServerException {
        try {
            this.load(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new LSIDServerException(e, "MSDL file not found: " + file);
        }
    }

    public void load(String xml) throws LSIDServerException {
        this.load(new ByteArrayInputStream(xml.getBytes()));
    }

    /*
     * Loose catch block
     */
    public void load(InputStream xml) throws LSIDServerException {
        block11: {
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(xml));
            Node root = parser.getDocument().getFirstChild();
            while (!(root instanceof Element)) {
                root = root.getNextSibling();
            }
            this.load((Element)root);
            Object var6_5 = null;
            try {
                if (xml != null) {
                    xml.close();
                }
                break block11;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            break block11;
            {
                catch (IOException e) {
                    throw new LSIDServerException(e, "Error parsing MSDL");
                }
                catch (SAXException e) {
                    throw new LSIDServerException(e, "Error parsing MSDL");
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    if (xml != null) {
                        xml.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public void load(Element MSDL) throws LSIDServerException {
        String dateStr = MSDL.getAttribute(EXPIRES_ATTR);
        Date expr = null;
        if (dateStr != null && !dateStr.equals("")) {
            try {
                expr = DATE_FORMAT.parse(dateStr);
            }
            catch (ParseException e) {
                throw new LSIDServerException(e, "Error reading expiration date in MSDL: " + dateStr);
            }
        }
        Element envNS = MSDL.getOwnerDocument().createElement("nsmappings");
        envNS.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:msdl", NAMESPACE);
        String xpathStr = "msdl:lsid";
        try {
            NodeList lsids = XPathAPI.selectNodeList((Node)MSDL, (String)xpathStr, (Node)envNS);
            int i = 0;
            while (i < lsids.getLength()) {
                Element lsidElt = (Element)lsids.item(i);
                Date lsidExp = expr;
                String expStr = null;
                try {
                    expStr = lsidElt.getAttribute(EXPIRES_ATTR);
                    if (expStr != null && expStr != "") {
                        Date d = DATE_FORMAT.parse(expStr);
                        if (lsidExp == null) {
                            lsidExp = d;
                        } else if (d.before(lsidExp)) {
                            lsidExp = d;
                        }
                    }
                }
                catch (ParseException e) {
                    throw new LSIDServerException(e, "Error reading expiration date in MSDL: " + expStr);
                }
                String location = lsidElt.getAttribute(LOCATION_ATTR);
                LSID lsid = null;
                try {
                    lsid = new LSID(lsidElt.getAttribute(URI_ATTR));
                }
                catch (MalformedLSIDException e) {
                    throw new LSIDServerException((Exception)((Object)e), "Bad LSID in MSDL");
                }
                if (location.equals(INLINE)) {
                    Element elt = null;
                    NodeList kids = lsidElt.getChildNodes();
                    int j = 0;
                    while (j < kids.getLength()) {
                        Node node = kids.item(j);
                        if (node instanceof Element) {
                            elt = (Element)node;
                            break;
                        }
                        ++j;
                    }
                    this.loadMetaData(lsid, elt, lsidExp, lsidElt.getAttribute(FORMAT_ATTR));
                } else {
                    String loc = null;
                    try {
                        xpathStr = "child::text()";
                        loc = XPathAPI.selectSingleNode((Node)lsidElt, (String)xpathStr).getNodeValue();
                        if (location.equals(FILE)) {
                            this.loadMetaData(lsid, new FileInputStream(loc), lsidExp, lsidElt.getAttribute(FORMAT_ATTR));
                        } else if (location.equals(URL)) {
                            this.loadMetaData(lsid, new URL(loc).openStream(), lsidExp, lsidElt.getAttribute(FORMAT_ATTR));
                        }
                    }
                    catch (TransformerException e) {
                        throw new LSIDServerException(e, "Error reading metadata file specified in MSDL:  " + loc);
                    }
                    catch (IOException e) {
                        throw new LSIDServerException(e, "Error reading metadata file specified in MSDL:  " + loc);
                    }
                }
                ++i;
            }
        }
        catch (TransformerException e) {
            throw new LSIDServerException(e, "Error reading metadata file specified in MSDL");
        }
    }

    public MetadataResponse getMetadata(LSIDRequestContext ctx, String[] formats) throws LSIDServerException {
        LSID lsid = ctx.getLsid();
        Entry entry = (Entry)this.metadata.get(lsid.toString());
        if (entry == null) {
            throw new LSIDServerException(400, "No metadata in msdl for " + lsid);
        }
        byte[] bytes = entry.metadata;
        if (formats != null) {
            boolean found = false;
            int i = 0;
            if (i < formats.length) {
                if (formats[i].equals(entry.format)) {
                    found = true;
                }
            }
            if (!found) {
                throw new LSIDServerException(401, "No metadata found for given format");
            }
        }
        if (bytes == null) {
            throw new LSIDServerException(400, "No metadata in msdl for " + lsid);
        }
        return new MetadataResponse((Object)new ByteArrayInputStream(bytes), entry.expires, entry.format);
    }

    public void initService(LSIDServiceConfig config) throws LSIDServerException {
    }

    private void loadMetaData(LSID lsid, Element md, Date expr, String format) throws LSIDServerException {
        OutputFormat fmt = new OutputFormat();
        StringWriter writer = new StringWriter();
        XMLSerializer ser = new XMLSerializer((Writer)writer, fmt);
        ser.setNamespaces(true);
        try {
            ser.serialize(md);
            Entry entry = new Entry(writer.getBuffer().toString().getBytes(), expr);
            if (format != null && !format.equals("")) {
                entry.format = format;
            }
            this.metadata.put(lsid.toString(), entry);
        }
        catch (IOException e) {
            throw new LSIDServerException(e, "Error serializing RDF Document");
        }
    }

    /*
     * Loose catch block
     */
    private void loadMetaData(LSID lsid, InputStream xml, Date expr, String format) throws LSIDServerException {
        block10: {
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(xml));
            this.loadMetaData(lsid, (Element)parser.getDocument().getFirstChild(), expr, format);
            Object var9_6 = null;
            try {
                if (xml != null) {
                    xml.close();
                }
                break block10;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            break block10;
            {
                catch (IOException e) {
                    throw new LSIDServerException(e, "Error parsing metadata in MSDL");
                }
                catch (SAXException e) {
                    throw new LSIDServerException(e, "Error parsing metadata in MSDL");
                }
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                try {
                    if (xml != null) {
                        xml.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    private class Entry {
        byte[] metadata;
        String format = "application/xml+rdf";
        Date expires;

        Entry(byte[] metadata, Date expires) {
            this.metadata = metadata;
            this.expires = expires;
        }
    }
}

