/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.client.conf;

import com.ibm.lsid.LSID;
import com.ibm.lsid.client.LSIDAuthority;
import com.ibm.lsid.client.conf.credentials.castor.Basic;
import com.ibm.lsid.client.conf.credentials.castor.Lsid;
import com.ibm.lsid.client.conf.credentials.castor.LsidCredentials;
import com.ibm.lsid.client.conf.credentials.castor.Port;
import com.ibm.lsid.wsdl.LSIDPort;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class LSIDCredentialConfig {
    public static final String LSID_CLIENT_HOME = "LSID_CLIENT_HOME";
    private static final String CREDENTIAL_FILE_NAME = "lsid-credentials.xml";
    private static final String LSID_CLIENT_HOME_DEFAULT_WIN32 = "/lsid-client";
    private static final String LSID_CLIENT_HOME_DEFAULT_UNIX = ".lsid-client";
    private static Hashtable knownPorts = new Hashtable();
    private static Hashtable knownLSIDs = new Hashtable();
    private File lsidHome = null;
    private static LSIDCredentialConfig instance = new LSIDCredentialConfig();

    public static LSIDCredentialConfig getInstance() {
        return instance;
    }

    public static Hashtable getCredentials(LSID lsid) {
        String lsidkey = lsid.toString();
        if (knownLSIDs.containsKey(lsidkey)) {
            return LSIDCredentialConfig.addBasicAuth((String)knownLSIDs.get(lsidkey));
        }
        lsidkey = "urn:lsid:" + lsid.getAuthority() + ":" + lsid.getNamespace() + ":" + lsid.getObject();
        if (knownLSIDs.containsKey(lsidkey)) {
            return LSIDCredentialConfig.addBasicAuth((String)knownLSIDs.get(lsidkey));
        }
        lsidkey = "urn:lsid:" + lsid.getAuthority() + ":" + lsid.getNamespace();
        if (knownLSIDs.containsKey(lsidkey)) {
            return LSIDCredentialConfig.addBasicAuth((String)knownLSIDs.get(lsidkey));
        }
        lsidkey = "urn:lsid:" + lsid.getAuthority();
        if (knownLSIDs.containsKey(lsidkey)) {
            return LSIDCredentialConfig.addBasicAuth((String)knownLSIDs.get(lsidkey));
        }
        return new Hashtable();
    }

    public static Hashtable getCredentials(LSIDAuthority authority) {
        String lsidkey = "urn:lsid:" + authority;
        if (knownLSIDs.containsKey(lsidkey)) {
            return LSIDCredentialConfig.addBasicAuth((String)knownLSIDs.get(lsidkey));
        }
        return new Hashtable();
    }

    public static Hashtable getCredentials(LSIDPort port) {
        String portkey = port.getServiceName() + ":" + port.getName();
        if (!knownPorts.containsKey(portkey) && port.getServiceName() != null) {
            portkey = (String)knownPorts.get(port.getServiceName());
        }
        if (portkey != null && knownPorts.containsKey(portkey)) {
            String auth = (String)knownPorts.get(portkey);
            return LSIDCredentialConfig.addBasicAuth(auth);
        }
        return new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LSIDCredentialConfig() {
        File credxml;
        String lsidHomeStr = System.getProperty(LSID_CLIENT_HOME);
        if (lsidHomeStr == null) {
            char sep = File.separatorChar;
            lsidHomeStr = sep == '/' ? LSID_CLIENT_HOME_DEFAULT_UNIX : LSID_CLIENT_HOME_DEFAULT_WIN32;
            System.err.println("No LSID_CLIENT_HOME specified, using default: " + lsidHomeStr);
        }
        this.lsidHome = new File(lsidHomeStr);
        if (!this.lsidHome.exists()) {
            this.lsidHome.mkdirs();
        }
        if ((credxml = new File(this.lsidHome, CREDENTIAL_FILE_NAME)).exists()) {
            InputStream in = null;
            BufferedReader br = new BufferedReader(new FileReader(credxml));
            LsidCredentials credentials = LsidCredentials.unmarshalLsidCredentials(br);
            Port[] ports = credentials.getPort();
            int i = 0;
            while (i < ports.length) {
                Basic basic = ports[i].getBasic();
                knownPorts.put(ports[i].getMap(), basic.getUsername() + ":" + basic.getPassword());
                ++i;
            }
            Lsid[] lsids = credentials.getLsid();
            int i2 = 0;
            while (i2 < lsids.length) {
                Basic basic = lsids[i2].getBasic();
                knownLSIDs.put(lsids[i2].getMap(), basic.getUsername() + ":" + basic.getPassword());
                ++i2;
            }
            Object var12_15 = null;
            if (in == null) return;
            try {
                in.close();
                return;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            return;
            {
                catch (IOException e) {
                    System.err.println("Error loading credential file, using default settings, exception trace follows");
                    e.printStackTrace();
                    this.writeDefaultCredentials();
                    Object var12_16 = null;
                    if (in == null) return;
                    try {
                        in.close();
                        return;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    return;
                }
                catch (MarshalException e) {
                    System.err.println("Error parsing credential file, using default settings, exception trace follows");
                    e.printStackTrace();
                    Object var12_17 = null;
                    if (in == null) return;
                    try {
                        in.close();
                        return;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    return;
                }
                catch (ValidationException e) {
                    System.err.println("Error parsing credential file, using default settings, exception trace follows");
                    e.printStackTrace();
                    Object var12_18 = null;
                    if (in == null) return;
                    try {
                        in.close();
                        return;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var12_19 = null;
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
        System.err.println("Credential file: " + credxml + " does not exist, using default settings");
        this.writeDefaultCredentials();
    }

    private static Hashtable addBasicAuth(String auth) {
        Hashtable bag = new Hashtable();
        if (auth != null) {
            StringTokenizer st = new StringTokenizer(auth, ":");
            ArrayList<String> tokens = new ArrayList<String>(3);
            while (st.hasMoreTokens()) {
                tokens.add(st.nextToken());
            }
            if (tokens.size() > 1) {
                bag.put("basicUsername", tokens.get(0));
                bag.put("basicPassword", tokens.get(1));
            }
        }
        return bag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDefaultCredentials() {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = this.getClass().getResourceAsStream(CREDENTIAL_FILE_NAME);
            if (in == null) {
                System.err.println("Non fatal error: no default credential exists in client installation");
                return;
            }
            out = new FileOutputStream(new File(this.lsidHome, CREDENTIAL_FILE_NAME));
            byte[] bytes = new byte[1024];
            int numbytes = in.read(bytes);
            while (numbytes != -1) {
                out.write(bytes, 0, numbytes);
                numbytes = in.read(bytes);
            }
            out.flush();
        }
        catch (IOException e) {
            System.err.println("No fatal error: could not write default credentials file, stack trace follows");
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

