/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server;

import ORG.oclc.oai.server.catalog.AbstractCatalog;
import ORG.oclc.oai.server.verb.BadVerb;
import ORG.oclc.oai.server.verb.OAIInternalServerError;
import ORG.oclc.oai.server.verb.ServerVerb;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;

public class OAIHandler
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTIES_SERVLET_CONTEXT_ATTRIBUTE = (class$ORG$oclc$oai$server$OAIHandler == null ? (class$ORG$oclc$oai$server$OAIHandler = OAIHandler.class$("ORG.oclc.oai.server.OAIHandler")) : class$ORG$oclc$oai$server$OAIHandler).getName() + ".properties";
    private static final String VERSION = "1.5.48";
    private static boolean debug = false;
    private HashMap attributesMap = new HashMap();
    static /* synthetic */ Class class$ORG$oclc$oai$server$OAIHandler;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletResponse;
    static /* synthetic */ Class class$javax$xml$transform$Transformer;

    public static String getVERSION() {
        return VERSION;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            HashMap attributes = null;
            ServletContext context = this.getServletContext();
            Properties properties = (Properties)context.getAttribute(PROPERTIES_SERVLET_CONTEXT_ATTRIBUTE);
            if (properties == null) {
                InputStream in;
                String PROPERTIES_INIT_PARAMETER = "properties";
                if (debug) {
                    System.out.println("OAIHandler.init(..): No '" + PROPERTIES_SERVLET_CONTEXT_ATTRIBUTE + "' servlet context attribute. Trying to use init parameter '" + "properties" + "'");
                }
                String fileName = config.getServletContext().getInitParameter("properties");
                try {
                    in = new FileInputStream(fileName);
                }
                catch (FileNotFoundException e) {
                    in = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
                }
                if (in != null) {
                    properties = new Properties();
                    properties.load(in);
                    attributes = this.getAttributes(properties);
                    if (debug) {
                        System.out.println("OAIHandler.init: fileName=" + fileName);
                    }
                }
            } else {
                attributes = this.getAttributes(properties);
            }
            this.attributesMap.put("global", attributes);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new ServletException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new ServletException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new ServletException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ServletException(e.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new ServletException(e.getMessage());
        }
    }

    private HashMap getAttributes(Properties properties) throws Throwable {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Enumeration attrNames = this.getServletContext().getAttributeNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            attributes.put(attrName, this.getServletContext().getAttribute(attrName));
        }
        attributes.put("OAIHandler.properties", properties);
        if (!"true".equals(properties.getProperty("OAIHandler.serviceUnavailable"))) {
            attributes.put("OAIHandler.version", VERSION);
            AbstractCatalog abstractCatalog = AbstractCatalog.factory(properties);
            attributes.put("OAIHandler.catalog", abstractCatalog);
        }
        boolean forceRender = false;
        if ("true".equals(properties.getProperty("OAIHandler.forceRender"))) {
            forceRender = true;
        }
        String xsltName = properties.getProperty("OAIHandler.styleSheet");
        String appBase = properties.getProperty("OAIHandler.appBase");
        if (appBase == null) {
            appBase = "webapps";
        }
        if (xsltName != null && ("true".equalsIgnoreCase(properties.getProperty("OAIHandler.renderForOldBrowsers")) || forceRender)) {
            FileInputStream is;
            try {
                is = new FileInputStream(appBase + "/" + xsltName);
            }
            catch (FileNotFoundException e) {
                is = new FileInputStream(this.getServletContext().getRealPath(xsltName.substring(xsltName.indexOf("/", 1) + 1)));
            }
            StreamSource xslSource = new StreamSource(is);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(xslSource);
            attributes.put("OAIHandler.transformer", transformer);
        }
        return attributes;
    }

    private HashMap getAttributes(String pathInfo) {
        HashMap attributes = null;
        if (pathInfo != null && pathInfo.length() > 0) {
            if (this.attributesMap.containsKey(pathInfo)) {
                attributes = (HashMap)this.attributesMap.get(pathInfo);
            } else {
                try {
                    String fileName = pathInfo.substring(1) + ".properties";
                    InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
                    if (in != null) {
                        Properties properties = new Properties();
                        properties.load(in);
                        attributes = this.getAttributes(properties);
                    }
                    this.attributesMap.put(pathInfo, attributes);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        if (attributes == null) {
            attributes = (HashMap)this.attributesMap.get("global");
        }
        return attributes;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap attributes = this.getAttributes(request.getPathInfo());
        Properties properties = (Properties)attributes.get("OAIHandler.properties");
        boolean monitor = false;
        if (properties.getProperty("OAIHandler.monitor") != null) {
            monitor = true;
        }
        boolean serviceUnavailable = false;
        if (properties.getProperty("OAIHandler.serviceUnavailable") != null) {
            serviceUnavailable = true;
        }
        String extensionPath = properties.getProperty("OAIHandler.extensionPath", "/extension");
        HashMap serverVerbs = ServerVerb.getVerbs(properties);
        HashMap extensionVerbs = ServerVerb.getExtensionVerbs(properties);
        Transformer transformer = (Transformer)attributes.get("OAIHandler.transformer");
        boolean forceRender = false;
        if ("true".equals(properties.getProperty("OAIHandler.forceRender"))) {
            forceRender = true;
        }
        request.setCharacterEncoding("UTF-8");
        Date then = null;
        if (monitor) {
            then = new Date();
        }
        if (debug) {
            Enumeration headerNames = request.getHeaderNames();
            System.out.println("OAIHandler.doGet: ");
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                System.out.print(headerName);
                System.out.print(": ");
                System.out.println(request.getHeader(headerName));
            }
        }
        if (serviceUnavailable) {
            response.sendError(503, "Sorry. This server is down for maintenance");
        } else {
            try {
                String userAgent = request.getHeader("User-Agent");
                userAgent = userAgent == null ? "" : userAgent.toLowerCase();
                Transformer serverTransformer = null;
                if (transformer != null && (forceRender || userAgent.indexOf("opera") != -1 || userAgent.startsWith("mozilla") && userAgent.indexOf("msie 6") == -1)) {
                    serverTransformer = transformer;
                }
                String result = OAIHandler.getResult(attributes, request, response, serverTransformer, serverVerbs, extensionVerbs, extensionPath);
                Writer out = OAIHandler.getWriter(request, response);
                out.write(result);
                out.close();
            }
            catch (FileNotFoundException e) {
                if (debug) {
                    e.printStackTrace();
                    System.out.println("SC_NOT_FOUND: " + e.getMessage());
                }
                response.sendError(404, e.getMessage());
            }
            catch (TransformerException e) {
                response.sendError(500, e.getMessage());
            }
            catch (OAIInternalServerError e) {
                response.sendError(500, e.getMessage());
            }
            catch (SocketException e) {
                System.out.println(e.getMessage());
                response.sendError(500, e.getMessage());
            }
            catch (Throwable e) {
                e.printStackTrace();
                response.sendError(500, e.getMessage());
            }
        }
        if (monitor) {
            StringBuffer reqUri = new StringBuffer(request.getRequestURI().toString());
            String queryString = request.getQueryString();
            if (queryString != null) {
                reqUri.append("?").append(queryString);
            }
            Runtime rt = Runtime.getRuntime();
            System.out.println(rt.freeMemory() + "/" + rt.totalMemory() + " " + (new Date().getTime() - then.getTime()) + "ms: " + reqUri.toString());
        }
    }

    public static String getResult(HashMap attributes, HttpServletRequest request, HttpServletResponse response, Transformer serverTransformer, HashMap serverVerbs, HashMap extensionVerbs, String extensionPath) throws Throwable {
        try {
            String result;
            boolean isExtensionVerb = extensionPath.equals(request.getPathInfo());
            String verb = request.getParameter("verb");
            if (debug) {
                System.out.println("OAIHandler.getResult: verb=>" + verb + "<");
            }
            Class verbClass = null;
            verbClass = isExtensionVerb ? (Class)extensionVerbs.get(verb) : (Class)serverVerbs.get(verb);
            if (verbClass == null) {
                if (debug) {
                    System.out.println("verb not found among:");
                    Iterator keySet = null;
                    keySet = isExtensionVerb ? extensionVerbs.keySet().iterator() : serverVerbs.keySet().iterator();
                    while (keySet.hasNext()) {
                        System.out.println(keySet.next());
                    }
                }
                result = BadVerb.construct(attributes, request, response, serverTransformer);
            } else {
                Method construct = verbClass.getMethod("construct", class$java$util$HashMap == null ? (class$java$util$HashMap = OAIHandler.class$("java.util.HashMap")) : class$java$util$HashMap, class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = OAIHandler.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest, class$javax$servlet$http$HttpServletResponse == null ? (class$javax$servlet$http$HttpServletResponse = OAIHandler.class$("javax.servlet.http.HttpServletResponse")) : class$javax$servlet$http$HttpServletResponse, class$javax$xml$transform$Transformer == null ? (class$javax$xml$transform$Transformer = OAIHandler.class$("javax.xml.transform.Transformer")) : class$javax$xml$transform$Transformer);
                try {
                    result = (String)construct.invoke(null, attributes, request, response, serverTransformer);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            if (debug) {
                System.out.println(result);
            }
            return result;
        }
        catch (NoSuchMethodException e) {
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new OAIInternalServerError(e.getMessage());
        }
    }

    public static Writer getWriter(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Writer out;
        String encodings = request.getHeader("Accept-Encoding");
        if (debug) {
            System.out.println("encodings=" + encodings);
        }
        if (encodings != null && encodings.indexOf("gzip") != -1) {
            response.setHeader("Content-Encoding", "gzip");
            out = new OutputStreamWriter((OutputStream)new GZIPOutputStream((OutputStream)response.getOutputStream()), "UTF-8");
        } else if (encodings != null && encodings.indexOf("deflate") != -1) {
            response.setHeader("Content-Encoding", "deflate");
            out = new OutputStreamWriter((OutputStream)new DeflaterOutputStream((OutputStream)response.getOutputStream()), "UTF-8");
        } else {
            out = response.getWriter();
        }
        return out;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doGet(request, response);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

