/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.vocabulary;

import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import org.dspace.foresite.Predicate;

public class PROV {
    public static final String namespace = "http://www.w3.org/ns/prov#";
    public static final String prefix = "prov";
    public static final List<String> classes = Arrays.asList("Usage", "Generation", "Association", "Collection");
    public static final List<String> properties = Arrays.asList("wasDerivedFrom", "used", "wasGeneratedBy", "wasAssociatedWith", "wasInformedBy", "qualifiedGeneration", "qualifiedAssociation", "agent", "hadPlan", "qualifiedUsage", "hadMember");
    public static final Resource Usage = PROV.resource("Usage");
    public static final Resource Generation = PROV.resource("Generation");
    public static final Resource Association = PROV.resource("Association");
    public static final Resource Collection = PROV.resource("Collection");
    public static final Property wasDerivedFrom = PROV.property("wasDerivedFrom");
    public static final Property used = PROV.property("used");
    public static final Property wasGeneratedBy = PROV.property("wasGeneratedBy");
    public static final Property wasAssociatedWith = PROV.property("wasAssociatedWith");
    public static final Property wasInformedBy = PROV.property("wasInformedBy");
    public static final Property qualifiedGeneration = PROV.property("qualifiedGeneration");
    public static final Property qualifiedAssociation = PROV.property("qualifiedAssociation");
    public static final Property agent = PROV.property("agent");
    public static final Property hadPlan = PROV.property("hadPlan");
    public static final Property qualifiedUsage = PROV.property("qualifiedUsage");
    public static final Property hadMember = PROV.property("hadMember");

    public static Predicate predicate(String property) throws IllegalArgumentException, URISyntaxException {
        if (!properties.contains(property)) {
            throw new IllegalArgumentException("The given argument: " + property + " is not a PROV property. Please use one of the follwing to " + "create a Predicate: " + Arrays.toString(properties.toArray()));
        }
        Predicate predicate = new Predicate();
        predicate.setPrefix(prefix);
        predicate.setName(property);
        predicate.setNamespace(namespace);
        predicate.setURI(new URI(namespace + property));
        return predicate;
    }

    protected static Resource resource(String localName) {
        return ResourceFactory.createResource((String)(namespace + localName));
    }

    protected static Property property(String localName) {
        return ResourceFactory.createProperty((String)namespace, (String)localName);
    }
}

