/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.index.processor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.cn.index.processor.IndexTaskProcessingStrategy;
import org.dataone.cn.index.task.IndexTask;
import org.dataone.cn.indexer.SolrIndexService;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.util.TypeMarshaller;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.SAXParseException;

public class IndexTaskUpdateProcessor
implements IndexTaskProcessingStrategy {
    private static Logger logger = Logger.getLogger((String)IndexTaskUpdateProcessor.class.getName());
    @Autowired
    private SolrIndexService solrIndexService;

    @Override
    public void process(IndexTask task) throws Exception {
        ByteArrayInputStream smdStream = new ByteArrayInputStream(task.getSysMetadata().getBytes());
        try {
            this.solrIndexService.insertIntoIndex(task.getPid(), smdStream, task.getObjectPath());
        }
        catch (SAXParseException spe) {
            logger.error((Object)spe);
            logger.error((Object)("Caught SAX parse exception on: " + task.getPid() + ". re-trying with fresh copy of system metadata."));
            Identifier pid = new Identifier();
            pid.setValue(task.getPid());
            SystemMetadata smd = (SystemMetadata)HazelcastClientFactory.getSystemMetadataMap().get((Object)pid);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            TypeMarshaller.marshalTypeToOutputStream((Object)smd, (OutputStream)os);
            this.solrIndexService.insertIntoIndex(task.getPid(), new ByteArrayInputStream(os.toByteArray()), task.getObjectPath());
            logger.error((Object)"Retry with fresh system metadata successful!");
        }
    }
}

