/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.FieldCache;
import org.apache.solr.handler.component.StatsValues;
import org.apache.solr.schema.FieldType;

public class FieldFacetStats {
    public final String name;
    final FieldCache.StringIndex si;
    final FieldType ft;
    final String[] terms;
    final int[] termNum;
    final int startTermIndex;
    final int endTermIndex;
    final int nTerms;
    final int numStatsTerms;
    public final Map<String, StatsValues> facetStatsValues;
    final List<HashMap<String, Integer>> facetStatsTerms;

    public FieldFacetStats(String name, FieldCache.StringIndex si, FieldType ft, int numStatsTerms) {
        this.name = name;
        this.si = si;
        this.ft = ft;
        this.numStatsTerms = numStatsTerms;
        this.terms = si.lookup;
        this.termNum = si.order;
        this.startTermIndex = 1;
        this.endTermIndex = this.terms.length;
        this.nTerms = this.endTermIndex - this.startTermIndex;
        this.facetStatsValues = new HashMap<String, StatsValues>();
        this.facetStatsTerms = new ArrayList<HashMap<String, Integer>>();
        if (numStatsTerms == 0) {
            return;
        }
        for (int i = 0; i < numStatsTerms; ++i) {
            this.facetStatsTerms.add(new HashMap());
        }
    }

    String getTermText(int docID) {
        return this.terms[this.termNum[docID]];
    }

    public boolean facet(int docID, Double v) {
        int term = this.termNum[docID];
        int arrIdx = term - this.startTermIndex;
        if (arrIdx >= 0 && arrIdx < this.nTerms) {
            String key = this.ft.indexedToReadable(this.terms[term]);
            StatsValues stats = this.facetStatsValues.get(key);
            if (stats == null) {
                stats = new StatsValues();
                this.facetStatsValues.put(key, stats);
            }
            if (v == null) {
                ++stats.missing;
                return false;
            }
            stats.accumulate(v);
            return true;
        }
        return false;
    }

    public boolean facetTermNum(int docID, int statsTermNum) {
        int term = this.termNum[docID];
        int arrIdx = term - this.startTermIndex;
        if (arrIdx >= 0 && arrIdx < this.nTerms) {
            String key = this.ft.indexedToReadable(this.terms[term]);
            HashMap<String, Integer> statsTermCounts = this.facetStatsTerms.get(statsTermNum);
            Integer statsTermCount = statsTermCounts.get(key);
            if (statsTermCount == null) {
                statsTermCounts.put(key, 1);
            } else {
                statsTermCounts.put(key, statsTermCount + 1);
            }
            return true;
        }
        return false;
    }

    public boolean accumulateTermNum(int statsTermNum, Double value) {
        if (value == null) {
            return false;
        }
        for (Map.Entry<String, Integer> stringIntegerEntry : this.facetStatsTerms.get(statsTermNum).entrySet()) {
            Integer count;
            Map.Entry<String, Integer> pairs = stringIntegerEntry;
            String key = pairs.getKey();
            StatsValues facetStats = this.facetStatsValues.get(key);
            if (facetStats == null) {
                facetStats = new StatsValues();
                this.facetStatsValues.put(key, facetStats);
            }
            if ((count = pairs.getValue()) == null) continue;
            facetStats.accumulate(value, count);
        }
        return true;
    }
}

