/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralNames;

public class IssuerSerial
implements DEREncodable {
    GeneralNames issuer;
    DERInteger serial;
    DERBitString issuerUID;

    public IssuerSerial(ASN1Sequence aSN1Sequence) {
        this.issuer = GeneralNames.getInstance(aSN1Sequence.getObjectAt(0));
        this.serial = (DERInteger)aSN1Sequence.getObjectAt(1);
        if (aSN1Sequence.size() == 3) {
            this.issuerUID = (DERBitString)aSN1Sequence.getObjectAt(2);
        }
    }

    public GeneralNames getIssuer() {
        return this.issuer;
    }

    public DERInteger getSerial() {
        return this.serial;
    }

    public DERBitString getIssuerUID() {
        return this.issuerUID;
    }

    public DERObject getDERObject() {
        DEREncodableVector dEREncodableVector = new DEREncodableVector();
        dEREncodableVector.add(this.issuer);
        dEREncodableVector.add(this.serial);
        if (this.issuerUID != null) {
            dEREncodableVector.add(this.issuerUID);
        }
        return new DERSequence(dEREncodableVector);
    }
}

