/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid;

import java.io.Reader;
import java.io.Serializable;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis.types.URI;
import org.apache.xpath.XPathAPI;
import org.ecoinformatics.ecogrid.ANDType;
import org.ecoinformatics.ecogrid.ConditionType;
import org.ecoinformatics.ecogrid.LimitedXPathExpression;
import org.ecoinformatics.ecogrid.ORType;
import org.ecoinformatics.ecogrid.OperatorType;
import org.ecoinformatics.ecogrid.QueryType;
import org.ecoinformatics.ecogrid.QueryType_namespace;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class EcogridQueryParser {
    private QueryType _ecogridQuery = new QueryType();
    private Node _queryNode;
    private static final String QUERYIDATTRIBUTE = "@queryId";
    private static final String SYSTEMATTRIBUTE = "@system";
    private static final String NAMESPACE = "namespace";
    private static final String PREFIX = "prefix";
    private static final String RETURNFIELD = "returnField";
    private static final String TITLE = "title";
    private static final String FIRSTAND = "AND";
    private static final String FIRSTOR = "OR";
    private static final String FIRSTCONDITION = "condition";
    private static final String AND = "AND";
    private static final String OR = "OR";
    private static final String CON = "condition";
    private static final String OPERATOR = "operator";
    private static final String CONCEPT = "concept";

    public EcogridQueryParser(Reader xmlInput) throws Exception {
        InputSource in = new InputSource(xmlInput);
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        dfactory.setNamespaceAware(false);
        Document doc = dfactory.newDocumentBuilder().parse(in);
        NodeList queryIdList = XPathAPI.selectNodeList((Node)doc, (String)"/query");
        this._queryNode = queryIdList.item(0);
    }

    public EcogridQueryParser(Node aQueryDOMNode) {
        this._queryNode = aQueryDOMNode;
    }

    public QueryType getEcogridQuery() {
        return this._ecogridQuery;
    }

    public void setEcogridQuery(QueryType query) {
        this._ecogridQuery = query;
    }

    public void parseXML() throws Exception {
        this.setupQueryIdAndSystem();
        this.setupNamespace();
        this.setupReturnField();
        this.setupTitle();
        this.setupFirstRelation();
    }

    private Node getAttrNode(String aDocXPath, String aNodeXPath) {
        Node node = this._queryNode;
        try {
            if (this._queryNode.getNodeType() == 9) {
                NodeList queryIdList = XPathAPI.selectNodeList((Node)this._queryNode, (String)aDocXPath);
                node = queryIdList.item(0);
            } else {
                NodeList queryIdList = XPathAPI.selectNodeList((Node)this._queryNode, (String)aNodeXPath);
                node = queryIdList.item(0);
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return node;
    }

    private void setupQueryIdAndSystem() throws Exception {
        NodeList queryIdList = XPathAPI.selectNodeList((Node)this._queryNode, (String)QUERYIDATTRIBUTE);
        String queryId = queryIdList.item(0).getNodeValue();
        this._ecogridQuery.setQueryId(queryId);
        NodeList systemList = XPathAPI.selectNodeList((Node)this._queryNode, (String)SYSTEMATTRIBUTE);
        String system = systemList.item(0).getNodeValue();
        URI systemUri = new URI(system);
        this._ecogridQuery.setSystem(systemUri);
    }

    private void setupNamespace() throws Exception {
        NodeList namespaceList = XPathAPI.selectNodeList((Node)this._queryNode, (String)NAMESPACE);
        int length = namespaceList.getLength();
        if (length != 0) {
            QueryType_namespace[] namespaceArray = new QueryType_namespace[length];
            for (int i = 0; i < length; ++i) {
                Element namespace = (Element)namespaceList.item(i);
                String namespaceString = namespace.getFirstChild().getNodeValue();
                String prefix = namespace.getAttribute(PREFIX);
                QueryType_namespace queryNamespace = new QueryType_namespace(namespaceString);
                queryNamespace.setPrefix(prefix);
                namespaceArray[i] = queryNamespace;
            }
            this._ecogridQuery.setNamespace(namespaceArray);
        }
    }

    private void setupReturnField() throws Exception {
        NodeList returnFieldList = XPathAPI.selectNodeList((Node)this._queryNode, (String)RETURNFIELD);
        int length = returnFieldList.getLength();
        if (length != 0) {
            String[] returnFieldArray = new String[length];
            for (int i = 0; i < length; ++i) {
                String returnfieldString;
                Node returnfield = returnFieldList.item(i);
                returnFieldArray[i] = returnfieldString = returnfield.getFirstChild().getNodeValue();
            }
            this._ecogridQuery.setReturnfield(returnFieldArray);
        }
    }

    private void setupTitle() throws Exception {
        NodeList titleList = XPathAPI.selectNodeList((Node)this._queryNode, (String)TITLE);
        int length = titleList.getLength();
        if (length != 0) {
            String[] titleArray = new String[length];
            for (int i = 0; i < length; ++i) {
                String titleString;
                Node title = titleList.item(i);
                titleArray[i] = titleString = title.getFirstChild().getNodeValue();
            }
            this._ecogridQuery.setTitle(titleArray);
        }
    }

    private void setupFirstRelation() throws Exception {
        NodeList firstAND = XPathAPI.selectNodeList((Node)this._queryNode, (String)"AND");
        NodeList firstOR = XPathAPI.selectNodeList((Node)this._queryNode, (String)"OR");
        NodeList firstCondition = XPathAPI.selectNodeList((Node)this._queryNode, (String)"condition");
        int andLength = firstAND.getLength();
        int orLength = firstOR.getLength();
        int conLength = firstCondition.getLength();
        if (andLength != 0 && orLength == 0 && conLength == 0) {
            ANDType and = new ANDType();
            this.handleANDType(and, firstAND.item(0));
            this._ecogridQuery.setAND(and);
        } else if (orLength != 0 && andLength == 0 && conLength == 0) {
            ORType or = new ORType();
            this.handleORType(or, firstOR.item(0));
            this._ecogridQuery.setOR(or);
        } else if (conLength != 0 && orLength == 0 && andLength == 0) {
            ConditionType condition = this.handleConditionType(firstCondition.item(0));
            this._ecogridQuery.setCondition(condition);
        } else {
            throw new Exception("Invalid ecogrid query!");
        }
    }

    private void handleANDType(ANDType and, Node andNode) throws Exception {
        Node childNode;
        Serializable child;
        int i;
        if (and == null || andNode == null) {
            return;
        }
        NodeList andList = XPathAPI.selectNodeList((Node)andNode, (String)"AND");
        NodeList orList = XPathAPI.selectNodeList((Node)andNode, (String)"OR");
        NodeList conList = XPathAPI.selectNodeList((Node)andNode, (String)"condition");
        int andLength = andList.getLength();
        int orLength = orList.getLength();
        int conLength = conList.getLength();
        if (andLength != 0) {
            ANDType[] andArray = new ANDType[andLength];
            for (i = 0; i < andLength; ++i) {
                andArray[i] = child = new ANDType();
                childNode = andList.item(i);
                this.handleANDType((ANDType)child, childNode);
            }
            and.setAND(andArray);
        }
        if (orLength != 0) {
            ORType[] orArray = new ORType[orLength];
            for (i = 0; i < orLength; ++i) {
                child = new ORType();
                orArray[i] = child;
                childNode = orList.item(i);
                this.handleORType((ORType)child, childNode);
            }
            and.setOR(orArray);
        }
        if (conLength != 0) {
            ConditionType[] conditionArray = new ConditionType[conLength];
            for (i = 0; i < conLength; ++i) {
                ConditionType condition;
                Node childNode2 = conList.item(i);
                conditionArray[i] = condition = this.handleConditionType(childNode2);
            }
            and.setCondition(conditionArray);
        }
    }

    private void handleORType(ORType or, Node orNode) throws Exception {
        Node childNode;
        Serializable child;
        int i;
        if (or == null || orNode == null) {
            return;
        }
        NodeList andList = XPathAPI.selectNodeList((Node)orNode, (String)"AND");
        NodeList orList = XPathAPI.selectNodeList((Node)orNode, (String)"OR");
        NodeList conList = XPathAPI.selectNodeList((Node)orNode, (String)"condition");
        int andLength = andList.getLength();
        int orLength = orList.getLength();
        int conLength = conList.getLength();
        if (andLength != 0) {
            ANDType[] andArray = new ANDType[andLength];
            for (i = 0; i < andLength; ++i) {
                andArray[i] = child = new ANDType();
                childNode = andList.item(i);
                this.handleANDType((ANDType)child, childNode);
            }
            or.setAND(andArray);
        }
        if (orLength != 0) {
            ORType[] orArray = new ORType[orLength];
            for (i = 0; i < orLength; ++i) {
                child = new ORType();
                orArray[i] = child;
                childNode = orList.item(i);
                this.handleORType((ORType)child, childNode);
            }
            or.setOR(orArray);
        }
        if (conLength != 0) {
            ConditionType[] conditionArray = new ConditionType[conLength];
            for (i = 0; i < conLength; ++i) {
                ConditionType condition;
                Node childNode2 = conList.item(i);
                conditionArray[i] = condition = this.handleConditionType(childNode2);
            }
            or.setCondition(conditionArray);
        }
    }

    private ConditionType handleConditionType(Node condition) throws Exception {
        ConditionType conditionObject = new ConditionType();
        Object andObject = null;
        Object orObject = null;
        OperatorType operatorObject = null;
        LimitedXPathExpression conceptObject = new LimitedXPathExpression();
        if (condition == null) {
            return conditionObject;
        }
        Element coditionElement = (Element)condition;
        String operatorString = coditionElement.getAttribute(OPERATOR);
        operatorObject = OperatorType.fromString(operatorString);
        String conceptString = coditionElement.getAttribute(CONCEPT);
        conceptObject.setValue(conceptString);
        String value = coditionElement.getFirstChild().getNodeValue();
        conditionObject.setValue(value);
        conditionObject.setOperator(operatorObject);
        conditionObject.setConcept(conceptObject);
        return conditionObject;
    }
}

