/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.storage;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Initializable;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.UninitializedException;
import edu.uiuc.ncsa.security.storage.XMLMap;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StreamCorruptedException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

public abstract class IndexedStreamStore<V extends Identifiable>
implements Store<V> {
    protected MapConverter<V> converter;
    protected IdentifiableProvider<V> identifiableProvider;
    protected Initializable initializer;
    HashMap<Identifier, V> createdItems;
    public static String DIGEST_ALGORITHM = "SHA-1";
    public static String CHARSET = "US-ASCII";
    static char[] HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    MessageDigest messageDigest;

    public HashMap<Identifier, V> getCreatedItems() {
        if (this.createdItems == null) {
            this.createdItems = new HashMap();
        }
        return this.createdItems;
    }

    protected void put(V t) {
        if (t.getIdentifier() == null) {
            throw new UninitializedException("Error: There is no identifier for this store entry");
        }
        this.put(t.getIdentifier(), t);
    }

    public V put(Identifier key, V value) {
        Identifiable oldValue = null;
        if (!this.containsKey(value.getIdentifier())) {
            this.save((Identifiable)value);
        } else {
            oldValue = (Identifiable)this.get(value.getIdentifier());
            this.update((Identifiable)value);
        }
        return (V)oldValue;
    }

    protected String hashString(String identifier) {
        return this.getDigest(identifier);
    }

    String getDigest(String identifier) {
        byte[] digest = this.getDigestBytes(identifier);
        if (digest == null) {
            return null;
        }
        return IndexedStreamStore.hexEncode(digest);
    }

    public static String hexEncode(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (byte aByte : bytes) {
            sb.append(HEX_CHAR[(aByte & 0xF0) >>> 4]);
            sb.append(HEX_CHAR[aByte & 0xF]);
        }
        return sb.toString();
    }

    byte[] getDigestBytes(String input) {
        try {
            MessageDigest md = this.getMessageDigest();
            if (md == null) {
                return null;
            }
            byte[] inputBytes = input.getBytes(CHARSET);
            return md.digest(inputBytes);
        }
        catch (UnsupportedEncodingException x) {
            System.err.println("Unsupported encoding: " + CHARSET);
            return null;
        }
    }

    MessageDigest getMessageDigest() {
        if (this.messageDigest == null) {
            try {
                this.messageDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
            }
            catch (NoSuchAlgorithmException x) {
                System.err.println("No such algorithm: " + DIGEST_ALGORITHM);
            }
        }
        return this.messageDigest;
    }

    protected void serializeObject(V obj, OutputStream outputStream) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(outputStream);
        oos.writeObject(obj);
        oos.flush();
        oos.close();
    }

    protected V objectDeserialize(InputStream is) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(is);
        Identifiable t = (Identifiable)ois.readObject();
        ois.close();
        return (V)t;
    }

    protected V loadStream(InputStream fis) {
        Identifiable t = null;
        try {
            if (this.converter != null) {
                try {
                    XMLMap map = new XMLMap();
                    map.fromXML(fis);
                    t = (Identifiable)this.identifiableProvider.get(false);
                    this.converter.fromMap(map, t);
                    fis.close();
                }
                catch (Throwable zzz) {
                    zzz.printStackTrace();
                    t = (Identifiable)this.objectDeserialize(fis);
                }
            } else {
                t = (Identifiable)this.objectDeserialize(fis);
            }
            return (V)t;
        }
        catch (StreamCorruptedException q) {
            throw new GeneralException("Error: Could not load stream. This exception usually means either that you have an out of date library for items you want to store or that the operating system could not find the something (e.g. a file). Is your file store configured correctly?", (Throwable)q);
        }
        catch (IOException x) {
            x.printStackTrace();
            throw new GeneralException("Error: Could not load the stream. Is your store configured correctly?", (Throwable)x);
        }
        catch (ClassNotFoundException e) {
            throw new GeneralException("Error: Cannot find the item's class");
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected void createIndexEntry(String otherKey, String identifier, OutputStream outputStream) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(outputStream);
        osw.write(this.hashString(identifier));
        osw.flush();
        osw.close();
    }

    public V create() {
        return (V)((Identifiable)this.identifiableProvider.get());
    }
}

