/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.BasicNode;
import edu.ucsb.nceas.metacat.CommentNode;
import edu.ucsb.nceas.metacat.NodeRecord;
import edu.ucsb.nceas.metacat.PINode;
import edu.ucsb.nceas.metacat.TextNode;
import java.util.Enumeration;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class ElementNode
extends BasicNode {
    private static Logger logMetacat = Logger.getLogger(ElementNode.class);

    public ElementNode(TreeSet nodeRecordList, long nodeid) {
        for (NodeRecord currentNode : nodeRecordList) {
            if (currentNode.getNodeId() == nodeid) {
                logMetacat.info((Object)("Got Node ID: " + currentNode.getNodeId() + " (" + currentNode.getParentNodeId() + ", " + currentNode.getNodeIndex() + ", " + currentNode.getNodeType() + ")"));
                this.setNodeType(currentNode.getNodeType());
                this.setNodeID(currentNode.getNodeId());
                this.setParentID(currentNode.getParentNodeId());
                this.setTagName(currentNode.getNodeName());
                continue;
            }
            if (currentNode.getParentNodeId() == this.getNodeID()) {
                BasicNode child;
                logMetacat.info((Object)("  Processing child: " + currentNode.getNodeId() + " (" + currentNode.getParentNodeId() + ", " + currentNode.getNodeIndex() + ", " + currentNode.getNodeType() + ")"));
                if (currentNode.getNodeType().equals("ELEMENT")) {
                    logMetacat.info((Object)("Creating child node: " + currentNode.getNodeId()));
                    child = new ElementNode(nodeRecordList, currentNode.getNodeId());
                    this.addChildNode(child);
                    continue;
                }
                if (currentNode.getNodeType().equals("ATTRIBUTE")) {
                    this.setAttribute(currentNode.getNodeName(), currentNode.getNodeData());
                    continue;
                }
                if (currentNode.getNodeType().equals("TEXT")) {
                    child = new TextNode(currentNode.getNodeId(), currentNode.getParentNodeId(), currentNode.getNodeData());
                    this.addChildNode(child);
                    continue;
                }
                if (currentNode.getNodeType().equals("COMMENT")) {
                    child = new CommentNode(currentNode.getNodeId(), currentNode.getParentNodeId(), currentNode.getNodeData());
                    this.addChildNode(child);
                    continue;
                }
                if (!currentNode.getNodeType().equals("PI")) continue;
                child = new PINode(currentNode.getNodeId(), currentNode.getParentNodeId(), currentNode.getNodeName(), currentNode.getNodeData());
                this.addChildNode(child);
                continue;
            }
            logMetacat.info((Object)("  Discarding child: " + currentNode.getNodeId() + " (" + currentNode.getParentNodeId() + ", " + currentNode.getNodeIndex() + ", " + currentNode.getNodeType() + ")"));
        }
    }

    public String toString() {
        StringBuffer value = new StringBuffer();
        String nodetype = this.getNodeType();
        if (nodetype.equals("ELEMENT")) {
            value.append('<');
            value.append(this.getTagName());
            value.append(this.getAttributes().toString());
            value.append('>');
        }
        BasicNode child = null;
        Enumeration e = this.getChildren();
        while (e.hasMoreElements()) {
            child = (BasicNode)e.nextElement();
            value.append(child);
        }
        if (nodetype.equals("ELEMENT")) {
            value.append("</");
            value.append(this.getTagName());
            value.append('>');
        }
        return value.toString();
    }
}

