/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataone.hazelcast;

import com.hazelcast.core.MapLoader;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.McdbException;
import edu.ucsb.nceas.metacat.accesscontrol.AccessControlException;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.replication.ReplicationService;
import edu.ucsb.nceas.metacat.shared.HandlerException;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dataone.service.types.v1.Identifier;
import org.jibx.runtime.JiBXException;
import org.xml.sax.SAXException;

public class ObjectPathMap
implements MapLoader<Identifier, String> {
    private static IdentifierManager im;
    private static String dataPath;
    private static String metadataPath;
    private Logger logMetacat = Logger.getLogger(ObjectPathMap.class);

    public ObjectPathMap() {
        try {
            PropertyService ps = PropertyService.getInstance();
            dataPath = PropertyService.getProperty("application.datafilepath");
            metadataPath = PropertyService.getProperty("application.documentfilepath");
        }
        catch (PropertyNotFoundException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        im = IdentifierManager.getInstance();
    }

    private String pathToDocid(String localid) throws AccessControlException, HandlerException, JiBXException, IOException, McdbException, SAXException {
        Hashtable<String, String> ht = ReplicationService.getDocumentInfoMap(localid);
        if (ht.get("doctype").equals("BIN")) {
            return dataPath + FileUtil.getFS() + localid;
        }
        return metadataPath + FileUtil.getFS() + localid;
    }

    public String load(Identifier key) {
        String docid = null;
        String path = null;
        try {
            docid = im.getLocalId(key.getValue());
            path = this.pathToDocid(docid);
        }
        catch (Exception e) {
            if (this.logMetacat.isDebugEnabled()) {
                e.printStackTrace();
            }
            return null;
        }
        return path;
    }

    public Map<Identifier, String> loadAll(Collection<Identifier> identifiers) {
        Hashtable<Identifier, String> map = new Hashtable<Identifier, String>();
        for (Identifier id : identifiers) {
            try {
                String docid = im.getLocalId(id.getValue());
                map.put(id, this.pathToDocid(docid));
            }
            catch (Exception e) {
                if (!this.logMetacat.isDebugEnabled()) continue;
                e.printStackTrace();
            }
        }
        return map;
    }

    public Set<Identifier> loadAllKeys() {
        return null;
    }
}

