/*
 * Decompiled with CFR 0.152.
 */
package org.globus.common;

import java.util.StringTokenizer;

public class ResourceManagerContact {
    public static final String DEFAULT_SERVICE = "/jobmanager";
    public static final int DEFAULT_PORT = 2119;
    protected String hostName = null;
    protected int portNumber = -1;
    protected String serviceName = null;
    protected String globusDN = null;

    protected ResourceManagerContact() {
    }

    public ResourceManagerContact(String contact) {
        this.parse(contact);
    }

    protected void parse(String contact) {
        int i = this.getToken(contact, 0);
        if (i == -1) {
            this.hostName = contact;
            return;
        }
        this.hostName = contact.substring(0, i);
        char c = contact.charAt(i);
        if (c == '/') {
            this.parseService(contact, i);
        } else {
            int j = this.getToken(contact, i + 1);
            if (j == -1) {
                this.portNumber = this.parsePort(contact.substring(i + 1));
                return;
            }
            this.portNumber = this.parsePort(contact.substring(i + 1, j));
            c = contact.charAt(j);
            if (c == ':') {
                this.globusDN = contact.substring(j + 1);
                return;
            }
            if (c == '/') {
                this.parseService(contact, j);
            }
        }
    }

    private int parsePort(String port) {
        if (port.length() == 0) {
            return 2119;
        }
        return Integer.parseInt(port);
    }

    private void parseService(String contact, int from) {
        int pos = contact.indexOf(":", from);
        if (pos == -1) {
            this.serviceName = contact.substring(from);
        } else {
            this.serviceName = contact.substring(from, pos);
            this.globusDN = contact.substring(pos + 1);
        }
    }

    private int getToken(String contact, int from) {
        int len = contact.length();
        int i = from;
        while (i < len) {
            char c = contact.charAt(i);
            if (c == '/' || c == ':') {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String convertDN(String globusDN) {
        if (globusDN == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(globusDN, "/");
        StringBuffer buf = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            buf.insert(0, tokens.nextToken());
            if (!tokens.hasMoreTokens()) continue;
            buf.insert(0, ", ");
        }
        return buf.toString();
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPortNumber() {
        if (this.portNumber == -1) {
            return 2119;
        }
        return this.portNumber;
    }

    public String getServiceName() {
        if (this.serviceName == null) {
            return DEFAULT_SERVICE;
        }
        return this.serviceName;
    }

    public String getSubject() {
        return this.globusDN;
    }

    public String getGlobusDN() {
        return this.globusDN;
    }

    public String getDN() {
        return this.globusDN;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Host name   : " + this.hostName + "\n");
        buf.append("Port number : " + this.getPortNumber() + "\n");
        buf.append("Service     : " + this.getServiceName() + "\n");
        buf.append("DN          : " + this.getGlobusDN() + "\n");
        return buf.toString();
    }

    public static void main(String[] args) {
        ResourceManagerContact c = null;
        c = new ResourceManagerContact("pitcairn.mcs.anl.gov");
        System.out.println(c);
        c = new ResourceManagerContact("pitcairn.mcs.anl.gov:123");
        System.out.println(c);
        c = new ResourceManagerContact("pitcairn.mcs.anl.gov:123/job");
        System.out.println(c);
        c = new ResourceManagerContact("pitcairn.mcs.anl.gov/job");
        System.out.println(c);
        c = new ResourceManagerContact("pitcairn.mcs.anl.gov:/job");
        System.out.println(c);
        c = new ResourceManagerContact("pitcairn.mcs.anl.gov::cn=jarek");
        System.out.println(c);
        c = new ResourceManagerContact("pitcairn.mcs.anl.gov:123:cn=jarek");
        System.out.println(c);
        c = new ResourceManagerContact("pitcairn.mcs.anl.gov:/job:cn=jarek");
        System.out.println(c);
        c = new ResourceManagerContact("pitcairn.mcs.anl.gov/job:cn=jarek");
        System.out.println(c);
        c = new ResourceManagerContact("pitcairn.mcs.anl.gov:123/job:cn=jarek");
        System.out.println(c);
    }
}

