/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp;

import java.util.StringTokenizer;
import org.globus.ftp.exception.FTPException;

public class FileInfo {
    public static final byte UNKNOWN_TYPE = 0;
    public static final byte FILE_TYPE = 1;
    public static final byte DIRECTORY_TYPE = 2;
    public static final byte SOFTLINK_TYPE = 3;
    public static final byte DEVICE_TYPE = 4;
    public static final String UNKNOWN_STRING = "?";
    public static final int UNKNOWN_NUMBER = -1;
    private long size = -1L;
    private String name = "?";
    private String date = "?";
    private String time = "?";
    private byte fileType;

    public FileInfo() {
    }

    public FileInfo(String unixListReply) throws FTPException {
        this.parseUnixListReply(unixListReply);
    }

    public void parseUnixListReply(String reply) throws FTPException {
        if (reply == null) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(reply);
        int numTokens = tokens.countTokens();
        if (numTokens < 8) {
            throw new FTPException(0, "Invalid number of tokens in the list reply [" + reply + "]");
        }
        String token = tokens.nextToken();
        switch (token.charAt(0)) {
            case 'd': {
                this.setFileType((byte)2);
                break;
            }
            case '-': {
                this.setFileType((byte)1);
                break;
            }
            case 'l': {
                this.setFileType((byte)3);
                break;
            }
            case 'b': 
            case 'c': {
                this.setFileType((byte)4);
                return;
            }
            default: {
                this.setFileType((byte)0);
            }
        }
        tokens.nextToken();
        tokens.nextToken();
        String previousToken = tokens.nextToken();
        token = tokens.nextToken();
        try {
            this.setSize(Long.parseLong(token));
            token = null;
        }
        catch (NumberFormatException e) {
            try {
                this.setSize(Long.parseLong(previousToken));
            }
            catch (NumberFormatException ee) {
                throw new FTPException(0, "Invalid size number in the ftp reply [" + previousToken + ", " + token + "]");
            }
        }
        if (token == null) {
            token = tokens.nextToken();
        }
        String month = token;
        this.setDate(token + " " + tokens.nextToken());
        token = tokens.nextToken();
        this.setTime(token);
        int ps = reply.indexOf(month);
        if (ps == -1) {
            throw new FTPException(0, "Could not find date token");
        }
        if ((ps = reply.indexOf(this.time, ps + month.length())) == -1) {
            throw new FTPException(0, "Could not find time token");
        }
        this.setName(reply.substring(1 + ps + this.time.length()));
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public void setFileType(byte type) {
        this.fileType = type;
    }

    public long getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public String getDate() {
        return this.date;
    }

    public String getTime() {
        return this.time;
    }

    public boolean isFile() {
        return this.fileType == 1;
    }

    public boolean isDirectory() {
        return this.fileType == 2;
    }

    public boolean isSoftLink() {
        return this.fileType == 3;
    }

    public boolean isDevice() {
        return this.fileType == 4;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("FileInfo: ");
        buf.append(this.getName() + " ");
        buf.append(this.getSize() + " ");
        buf.append(this.getDate() + " ");
        buf.append(this.getTime() + " ");
        switch (this.fileType) {
            case 2: {
                buf.append("directory");
                break;
            }
            case 1: {
                buf.append("file");
                break;
            }
            case 3: {
                buf.append("softlink");
                break;
            }
            default: {
                buf.append("unknown type");
            }
        }
        return buf.toString();
    }
}

