/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp;

import java.net.InetAddress;
import java.util.StringTokenizer;

public class HostPort {
    private int[] datainfo = new int[6];

    public HostPort(String passiveReplyMessage) {
        int i = 0;
        StringTokenizer tokens = new StringTokenizer(passiveReplyMessage, ",");
        while (tokens.hasMoreTokens()) {
            this.datainfo[i] = Integer.parseInt(tokens.nextToken().trim());
            ++i;
        }
    }

    public HostPort(InetAddress addr, int port) {
        this(addr.getHostAddress(), port);
    }

    public HostPort(String ipAddress, int port) {
        int i = 0;
        StringTokenizer tokens = new StringTokenizer(ipAddress, ".");
        while (tokens.hasMoreTokens()) {
            this.datainfo[i] = Integer.parseInt(tokens.nextToken());
            ++i;
        }
        if (i != 4) {
            throw new IllegalArgumentException("Invalid ip address: " + ipAddress);
        }
        this.datainfo[4] = port / 256;
        this.datainfo[5] = port - this.datainfo[4] * 256;
    }

    public int getPort() {
        return this.datainfo[4] * 256 + this.datainfo[5];
    }

    public String getHost() {
        return this.datainfo[0] + "." + this.datainfo[1] + "." + this.datainfo[2] + "." + this.datainfo[3];
    }

    public String toFtpCmdArgument() {
        StringBuffer msg = new StringBuffer();
        int i = 0;
        while (i < this.datainfo.length) {
            msg.append(String.valueOf(this.datainfo[i]));
            if (i + 1 != this.datainfo.length) {
                msg.append(",");
            }
            ++i;
        }
        return msg.toString();
    }
}

