/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp;

import java.util.StringTokenizer;
import java.util.Vector;
import org.globus.ftp.HostPort;

public class HostPortList {
    static String nl = System.getProperty("line.separator");
    protected static boolean UP_TO_DATE = true;
    protected static boolean OUT_OF_DATE = false;
    private boolean stringStatus = OUT_OF_DATE;
    private String sporCommandParam;
    private Vector vector = null;

    public HostPortList(String spasReplyMsg) {
        this.sporCommandParam = "";
        int previousEnds = 0;
        while (true) {
            String currentLine;
            int currentEnds;
            if ((currentEnds = spasReplyMsg.indexOf(nl, (previousEnds = spasReplyMsg.indexOf(nl, previousEnds + 1)) + 1)) == -1) {
                currentEnds = spasReplyMsg.length();
            }
            if (!(currentLine = spasReplyMsg.substring(previousEnds + nl.length(), currentEnds)).startsWith(" ")) {
                if (currentLine.startsWith("229")) break;
                throw new IllegalArgumentException("Argument to HostPortList constructor is not a 229 reply message: last line ->" + currentLine + "<-");
            }
            currentLine = currentLine.trim();
            this.sporCommandParam = this.sporCommandParam + " " + currentLine;
        }
        this.sporCommandParam = this.sporCommandParam.substring(1, this.sporCommandParam.length());
        this.stringStatus = UP_TO_DATE;
    }

    public HostPortList() {
        this.stringStatus = OUT_OF_DATE;
    }

    protected void updateString() {
        this.sporCommandParam = "";
        int i = 0;
        while (i < this.vector.size()) {
            HostPort hp = (HostPort)this.vector.get(i);
            if (i != 0) {
                this.sporCommandParam = this.sporCommandParam + " ";
            }
            this.sporCommandParam = this.sporCommandParam + hp.toFtpCmdArgument();
            ++i;
        }
    }

    protected void updateVector() {
        if (this.vector == null) {
            this.parse();
        }
    }

    private void parse() {
        this.vector = new Vector();
        if (this.sporCommandParam != null) {
            StringTokenizer tokens = new StringTokenizer(this.sporCommandParam, nl);
            while (tokens.hasMoreTokens()) {
                this.vector.add(new HostPort(tokens.nextToken()));
            }
        }
    }

    public void add(HostPort hp) {
        this.updateVector();
        this.vector.add(hp);
        this.stringStatus = OUT_OF_DATE;
    }

    public int size() {
        this.updateVector();
        return this.vector.size();
    }

    public HostPort get(int index) {
        this.updateVector();
        return (HostPort)this.vector.elementAt(index);
    }

    public String toFtpCmdArgument() {
        if (this.stringStatus == OUT_OF_DATE) {
            this.updateString();
        }
        return this.sporCommandParam;
    }
}

