/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.dc;

import java.net.ServerSocket;
import java.net.Socket;
import org.globus.ftp.DataChannelAuthentication;
import org.globus.ftp.DataSink;
import org.globus.ftp.DataSource;
import org.globus.ftp.GridFTPSession;
import org.globus.ftp.Session;
import org.globus.ftp.dc.DataChannelFactory;
import org.globus.ftp.dc.PassiveConnectTask;
import org.globus.ftp.dc.TransferContext;
import org.globus.ftp.extended.GridFTPServerFacade;
import org.globus.ftp.vanilla.BasicServerControlChannel;

public class GridFTPPassiveConnectTask
extends PassiveConnectTask {
    GridFTPSession gSession;

    public GridFTPPassiveConnectTask(ServerSocket myServer, DataSink sink, BasicServerControlChannel control, GridFTPSession session, DataChannelFactory factory, TransferContext context) {
        super(myServer, sink, control, (Session)session, factory, context);
        this.gSession = session;
    }

    public GridFTPPassiveConnectTask(ServerSocket myServer, DataSource source, BasicServerControlChannel control, GridFTPSession session, DataChannelFactory factory, TransferContext context) {
        super(myServer, source, control, (Session)session, factory, context);
        this.gSession = session;
    }

    protected Socket openSocket() throws Exception {
        PassiveConnectTask.logger.debug((Object)"GridFTPPassiveConnectTask server.accept()");
        Socket newSocket = this.myServer.accept();
        if (this.gSession.TCPBufferSize != -1) {
            newSocket.setReceiveBufferSize(this.gSession.TCPBufferSize);
            newSocket.setSendBufferSize(this.gSession.TCPBufferSize);
        }
        PassiveConnectTask.logger.debug((Object)"server.accept() returned");
        if (this.gSession.dataChannelAuthentication.equals(DataChannelAuthentication.SELF)) {
            newSocket = GridFTPServerFacade.authenticate(newSocket, false, this.gSession.credential, this.gSession.dataChannelProtection, this.gSession.dataChannelAuthentication);
        } else if (!this.gSession.dataChannelAuthentication.equals(DataChannelAuthentication.NONE)) {
            throw new Exception("data channel authentication mode not supported");
        }
        return newSocket;
    }
}

