/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.exception;

import org.globus.ftp.exception.FTPException;
import org.globus.ftp.exception.FTPReplyParseException;
import org.globus.ftp.exception.UnexpectedReplyCodeException;

public class ServerException
extends FTPException {
    public static final int SERVER_REFUSED = 1;
    public static final int WRONG_PROTOCOL = 2;
    public static final int UNSUPPORTED_FEATURE = 3;
    public static final int REPLY_TIMEOUT = 4;
    private static String[] codeExplained = new String[]{"Unspecified category.", "Server refused performing the request.", "The server uses unknown communication protool.", "Server does not support feature.", "Reply wait timeout."};
    protected int code = 0;
    protected String customMessage;

    public String getCodeExplanation(int code) {
        if (codeExplained.length > code) {
            return codeExplained[code];
        }
        return "";
    }

    public ServerException(int code, String message) {
        super(code, message);
        this.customMessage = message;
    }

    public ServerException(int code) {
        super(code);
    }

    public static ServerException embedFTPReplyParseException(FTPReplyParseException rpe, String message) {
        ServerException se = new ServerException(2, message);
        se.setRootCause(rpe);
        return se;
    }

    public static ServerException embedFTPReplyParseException(FTPReplyParseException rpe) {
        return ServerException.embedFTPReplyParseException(rpe, "");
    }

    public static ServerException embedUnexpectedReplyCodeException(UnexpectedReplyCodeException urce, String message) {
        ServerException se = new ServerException(1, message);
        se.setRootCause(urce);
        return se;
    }

    public static ServerException embedUnexpectedReplyCodeException(UnexpectedReplyCodeException urce) {
        return ServerException.embedUnexpectedReplyCodeException(urce, "");
    }
}

