/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gram;

import java.net.MalformedURLException;
import java.util.Vector;
import org.globus.gram.Gram;
import org.globus.gram.GramException;
import org.globus.gram.GramJobListener;
import org.globus.gram.internal.GRAMConstants;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public class GramJob
implements GRAMConstants {
    private GSSCredential credential;
    private String rsl;
    private GlobusURL id;
    protected int status;
    protected int error;
    private Vector listeners;

    public GramJob(String rsl) {
        this.rsl = rsl;
        this.credential = null;
        this.id = null;
        this.status = 0;
    }

    public GramJob(GSSCredential cred, String rsl) {
        this.rsl = rsl;
        this.credential = cred;
        this.id = null;
        this.status = 0;
    }

    public void addListener(GramJobListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(listener);
    }

    public void removeListener(GramJobListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(listener);
    }

    public String getRSL() {
        return this.rsl;
    }

    public GSSCredential getCredentials() {
        return this.credential;
    }

    public void setCredentials(GSSCredential credential) {
        if (this.credential != null) {
            throw new IllegalArgumentException("Credentials already set");
        }
        this.credential = credential;
    }

    public void setID(String jobUrl) throws MalformedURLException {
        this.id = new GlobusURL(jobUrl);
    }

    public GlobusURL getID() {
        return this.id;
    }

    public String getIDAsString() {
        if (this.id == null) {
            return null;
        }
        return this.id.getURL();
    }

    public int getStatus() {
        return this.status;
    }

    protected void setStatus(int status) {
        if (this.status == status) {
            return;
        }
        this.status = status;
        if (this.listeners == null) {
            return;
        }
        int size = this.listeners.size();
        int i = 0;
        while (i < size) {
            GramJobListener listener = (GramJobListener)this.listeners.elementAt(i);
            listener.statusChanged(this);
            ++i;
        }
    }

    public void request(String contact) throws GramException, GSSException {
        Gram.request(contact, this, false);
    }

    public void request(String contact, boolean batch) throws GramException, GSSException {
        Gram.request(contact, this, batch);
    }

    public void request(String contact, boolean batch, boolean limitedDelegation) throws GramException, GSSException {
        Gram.request(contact, this, batch, limitedDelegation);
    }

    public void cancel() throws GramException, GSSException {
        Gram.cancel(this);
    }

    public void bind() throws GramException, GSSException {
        Gram.registerListener(this);
    }

    public void unbind() throws GramException, GSSException {
        Gram.unregisterListener(this);
    }

    public int signal(int signal, String arg) throws GramException, GSSException {
        return Gram.jobSignal(this, signal, arg);
    }

    public int signal(int signal) throws GramException, GSSException {
        return Gram.jobSignal(this, signal, "");
    }

    protected void setError(int code) {
        this.error = code;
    }

    public int getError() {
        return this.error;
    }

    public String toString() {
        return "RSL: " + this.rsl + " id: " + this.id;
    }

    public String getStatusAsString() {
        return GramJob.getStatusAsString(this.status);
    }

    public static String getStatusAsString(int status) {
        if (status == 1) {
            return "PENDING";
        }
        if (status == 2) {
            return "ACTIVE";
        }
        if (status == 8) {
            return "DONE";
        }
        if (status == 4) {
            return "FAILED";
        }
        if (status == 16) {
            return "SUSPENDED";
        }
        if (status == 32) {
            return "UNSUBMITTED";
        }
        if (status == 64) {
            return "STAGE_IN";
        }
        if (status == 128) {
            return "STAGE_OUT";
        }
        return "Unknown";
    }
}

