/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.StringTokenizer;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.globus.common.CoGProperties;
import org.globus.util.Base64;
import org.globus.util.log4j.NullAppender;

public class CertUtil {
    private static Logger logger = Logger.getLogger((String)(class$org$globus$gsi$CertUtil == null ? (class$org$globus$gsi$CertUtil = CertUtil.class$("org.globus.gsi.CertUtil")) : class$org$globus$gsi$CertUtil).getName());
    private static String provider;
    private static CertificateFactory certFact;
    static /* synthetic */ Class class$org$globus$gsi$CertUtil;

    public static void init() {
    }

    public static void setProvider(String providerName) {
        provider = providerName;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Provider set to : " + providerName));
        }
    }

    protected static synchronized CertificateFactory getCertificateFactory() throws GeneralSecurityException {
        if (certFact == null) {
            certFact = provider == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", provider);
        }
        return certFact;
    }

    public static X509Certificate loadCertificate(InputStream in) throws GeneralSecurityException {
        return (X509Certificate)CertUtil.getCertificateFactory().generateCertificate(in);
    }

    public static X509Certificate loadCertificate(String file) throws IOException, GeneralSecurityException {
        if (file == null) {
            throw new IllegalArgumentException("Certificate file is null");
        }
        boolean isCert = false;
        X509Certificate cert = null;
        BufferedReader reader = null;
        String line = null;
        StringBuffer buff = new StringBuffer();
        reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            if (line.indexOf("BEGIN CERTIFICATE") != -1) {
                isCert = true;
                continue;
            }
            if (isCert && line.indexOf("END CERTIFICATE") != -1) {
                byte[] data = Base64.decode(buff.toString().getBytes());
                cert = CertUtil.loadCertificate(new ByteArrayInputStream(data));
                continue;
            }
            if (!isCert) continue;
            buff.append(line);
        }
        reader.close();
        if (cert == null) {
            throw new GeneralSecurityException("Certificate data not found.");
        }
        return cert;
    }

    public static String toGlobusID(String dn) {
        return CertUtil.toGlobusID(dn, true);
    }

    public static String toGlobusID(String dn, boolean reverse) {
        if (dn == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(dn, ",");
        StringBuffer buf = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (reverse) {
                buf.append("/");
                buf.append(token);
                continue;
            }
            buf.insert(0, token);
            buf.insert(0, "/");
        }
        return buf.toString();
    }

    public static void installSecureRandomProvider() {
        CoGProperties props = CoGProperties.getDefault();
        String providerName = props.getSecureRandomProvider();
        try {
            logger.debug((Object)("Loading SecureRandom provider: " + providerName));
            Class<?> providerClass = Class.forName(providerName);
            Security.insertProviderAt((Provider)providerClass.newInstance(), 1);
        }
        catch (Exception e) {
            logger.debug((Object)"Unable to install PRNG. Using default PRNG.", (Throwable)e);
        }
    }

    public static KeyPair generateKeyPair(String algorithm, int bits) throws GeneralSecurityException {
        KeyPairGenerator generator = null;
        generator = provider == null ? KeyPairGenerator.getInstance(algorithm) : KeyPairGenerator.getInstance(algorithm, provider);
        generator.initialize(bits);
        return generator.generateKeyPair();
    }

    public static boolean isProxy(int certType) {
        return CertUtil.isGsi2Proxy(certType) || CertUtil.isGsi3Proxy(certType);
    }

    public static boolean isGsi3Proxy(int certType) {
        return certType == 14 || certType == 13 || certType == 12 || certType == 15;
    }

    public static boolean isGsi2Proxy(int certType) {
        return certType == 10 || certType == 11;
    }

    public static boolean isLimitedProxy(int certType) {
        return certType == 15 || certType == 11;
    }

    public static boolean isImpersonationProxy(int certType) {
        return certType == 14 || certType == 15 || certType == 11 || certType == 10;
    }

    public static String getProxyTypeAsString(int proxyType) {
        switch (proxyType) {
            case 14: {
                return "Proxy draft compliant impersonation proxy";
            }
            case 13: {
                return "Proxy draft compliant independent proxy";
            }
            case 15: {
                return "Proxy draft compliant limited proxy";
            }
            case 12: {
                return "Proxy draft compliant restricted proxy";
            }
            case 10: {
                return "full legacy globus proxy";
            }
            case 11: {
                return "limited legacy globus proxy";
            }
        }
        return "not a proxy";
    }

    public static boolean isGsi3Enabled() {
        String ver = System.getProperty("org.globus.gsi.version");
        return ver != null && ver.equals("3");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Logger.getRootLogger().addAppender((Appender)NullAppender.getInstance());
        Security.addProvider(new BouncyCastleProvider());
        CertUtil.setProvider("BC");
        CertUtil.installSecureRandomProvider();
    }
}

