/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.globus.common.ChainedIOException;
import org.globus.common.CoGProperties;
import org.globus.gsi.CertUtil;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.bc.BouncyCastleOpenSSLKey;
import org.globus.gsi.bc.BouncyCastleUtil;
import org.globus.util.Base64;
import org.globus.util.PEMUtils;

public class GlobusCredential {
    private static Logger logger = Logger.getLogger((String)(class$org$globus$gsi$GlobusCredential == null ? (class$org$globus$gsi$GlobusCredential = GlobusCredential.class$("org.globus.gsi.GlobusCredential")) : class$org$globus$gsi$GlobusCredential).getName());
    private static GlobusCredential defaultCred = null;
    private static boolean credentialSet = false;
    private PrivateKey key;
    private X509Certificate[] certs;
    static /* synthetic */ Class class$org$globus$gsi$GlobusCredential;

    public GlobusCredential(PrivateKey key, X509Certificate[] certs) {
        this.key = key;
        this.certs = certs;
    }

    public GlobusCredential(String proxyFile) throws GlobusCredentialException {
        if (proxyFile == null) {
            throw new IllegalArgumentException("proxyFile == null");
        }
        logger.debug((Object)("Loading proxy file: " + proxyFile));
        try {
            FileInputStream in = new FileInputStream(proxyFile);
            this.load(in);
        }
        catch (FileNotFoundException f) {
            throw new GlobusCredentialException(3, "proxyNotFound", new Object[]{proxyFile});
        }
    }

    public GlobusCredential(String certFile, String unencryptedKeyFile) throws GlobusCredentialException {
        if (certFile == null || unencryptedKeyFile == null) {
            throw new IllegalArgumentException();
        }
        try {
            X509Certificate cert = CertUtil.loadCertificate(certFile);
            BouncyCastleOpenSSLKey k = new BouncyCastleOpenSSLKey(unencryptedKeyFile);
            if (k.isEncrypted()) {
                throw new GlobusCredentialException(2, "encPrivKey", new Object[]{unencryptedKeyFile});
            }
            this.key = k.getPrivateKey();
            this.certs = new X509Certificate[]{cert};
        }
        catch (IOException e) {
            throw new GlobusCredentialException(3, "ioError00", e);
        }
        catch (GeneralSecurityException e) {
            throw new GlobusCredentialException(3, "secError00", e);
        }
        catch (Exception e) {
            throw new GlobusCredentialException(-1, "error00", e);
        }
    }

    public GlobusCredential(InputStream input) throws GlobusCredentialException {
        this.load(input);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void load(InputStream input) throws GlobusCredentialException {
        int size;
        Vector<X509Certificate> chain;
        PrivateKey key;
        block14: {
            if (input == null) {
                throw new IllegalArgumentException("input stream cannot be null");
            }
            key = null;
            X509Certificate cert = null;
            chain = new Vector<X509Certificate>(3);
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(input));
                    while ((line = reader.readLine()) != null) {
                        byte[] data;
                        void var5_6;
                        if (var5_6.indexOf("BEGIN CERTIFICATE") != -1) {
                            data = GlobusCredential.getDecodedPEMObject(reader);
                            cert = CertUtil.loadCertificate(new ByteArrayInputStream(data));
                            chain.addElement(cert);
                            continue;
                        }
                        if (var5_6.indexOf("BEGIN RSA PRIVATE KEY") == -1) continue;
                        data = GlobusCredential.getDecodedPEMObject(reader);
                        BouncyCastleOpenSSLKey k = new BouncyCastleOpenSSLKey("RSA", data);
                        key = k.getPrivateKey();
                    }
                }
                catch (IOException e) {
                    throw new GlobusCredentialException(3, "ioError00", e);
                }
                catch (GeneralSecurityException e) {
                    throw new GlobusCredentialException(3, "secError00", e);
                }
                catch (Exception e) {
                    throw new GlobusCredentialException(-1, "error00", e);
                }
                Object var11_12 = null;
                if (reader == null) break block14;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            reader.close();
        }
        if ((size = chain.size()) == 0) {
            throw new GlobusCredentialException(3, "noCerts00", (Throwable)null);
        }
        if (key == null) {
            throw new GlobusCredentialException(3, "noKey00", (Throwable)null);
        }
        this.certs = new X509Certificate[size];
        chain.copyInto(this.certs);
        this.key = key;
    }

    /*
     * WARNING - void declaration
     */
    private static final byte[] getDecodedPEMObject(BufferedReader reader) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            void var1_2;
            if (var1_2.indexOf("--END") != -1) {
                return Base64.decode(buf.toString().getBytes());
            }
            buf.append((String)var1_2);
        }
        throw new EOFException("PEM footer missing");
    }

    public void save(OutputStream out) throws IOException {
        try {
            GlobusCredential.writePEM(out, this.certs[0]);
            BouncyCastleOpenSSLKey k = new BouncyCastleOpenSSLKey(this.key);
            k.writeTo(out);
            int i = 1;
            while (i < this.certs.length) {
                if (!this.certs[i].getSubjectDN().equals(this.certs[i].getIssuerDN())) {
                    GlobusCredential.writePEM(out, this.certs[i]);
                }
                ++i;
            }
        }
        catch (CertificateEncodingException e) {
            throw new ChainedIOException(e.getMessage(), e);
        }
        out.flush();
    }

    private static final void writePEM(OutputStream out, X509Certificate cert) throws IOException, CertificateEncodingException {
        PEMUtils.writeBase64(out, "-----BEGIN CERTIFICATE-----", Base64.encode(cert.getEncoded()), "-----END CERTIFICATE-----");
    }

    public void verify() throws GlobusCredentialException {
        int i = 0;
        while (i < this.certs.length) {
            try {
                this.certs[i].checkValidity();
            }
            catch (CertificateExpiredException e) {
                String dn = this.certs[i].getSubjectDN().getName();
                throw new GlobusCredentialException(1, "expired00", new Object[]{dn});
            }
            catch (GeneralSecurityException e) {
                throw new GlobusCredentialException(3, "secError00", e);
            }
            ++i;
        }
    }

    public X509Certificate getIdentityCertificate() {
        try {
            return BouncyCastleUtil.getIdentityCertificate(this.certs);
        }
        catch (CertificateException e) {
            return null;
        }
    }

    public String getIdentity() {
        try {
            return BouncyCastleUtil.getIdentity(this.certs);
        }
        catch (CertificateException e) {
            return null;
        }
    }

    public PrivateKey getPrivateKey() {
        return this.key;
    }

    public X509Certificate[] getCertificateChain() {
        return this.certs;
    }

    public int getCertNum() {
        int i = this.certs.length - 1;
        while (i >= 0) {
            if (!this.certs[i].getSubjectDN().equals(this.certs[i].getIssuerDN())) {
                return i + 1;
            }
            --i;
        }
        return this.certs.length;
    }

    public int getStrength() {
        if (this.key == null) {
            return -1;
        }
        return ((RSAPrivateKey)this.key).getModulus().bitLength();
    }

    public String getSubject() {
        return this.certs[0].getSubjectDN().getName();
    }

    public String getIssuer() {
        return this.certs[0].getIssuerDN().getName();
    }

    public int getProxyType() {
        try {
            return BouncyCastleUtil.getCertificateType(this.certs[0]);
        }
        catch (CertificateException e) {
            return -1;
        }
    }

    public long getTimeLeft() {
        Date certTime = this.certs[0].getNotAfter();
        long diff = (certTime.getTime() - System.currentTimeMillis()) / 1000L;
        return diff < 0L ? 0L : diff;
    }

    public static synchronized GlobusCredential getDefaultCredential() throws GlobusCredentialException {
        if (defaultCred == null || !credentialSet && defaultCred.getTimeLeft() <= 0L) {
            String proxyLocation = CoGProperties.getDefault().getProxyFile();
            defaultCred = new GlobusCredential(proxyLocation);
            defaultCred.verify();
        }
        return defaultCred;
    }

    public static synchronized void setDefaultCredential(GlobusCredential cred) {
        defaultCred = cred;
        credentialSet = cred != null;
    }

    public String toString() {
        String lineSep = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("subject    : ").append(this.getSubject()).append(lineSep);
        buf.append("issuer     : ").append(this.getIssuer()).append(lineSep);
        buf.append("strength   : ").append(this.getStrength() + " bits").append(lineSep);
        buf.append("timeleft   : ").append(this.getTimeLeft() + " sec").append(lineSep);
        buf.append("proxy type : ").append(CertUtil.getProxyTypeAsString(this.getProxyType()));
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

