/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi.net.impl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.globus.gsi.gssapi.SSLUtil;
import org.globus.gsi.gssapi.net.GssInputStream;
import org.ietf.jgss.GSSContext;

public class GSIGssInputStream
extends GssInputStream {
    private static final int MAX_LEN = 0x2000000;
    protected byte[] header = new byte[4];
    protected int mode = -1;

    public GSIGssInputStream(InputStream in, GSSContext context) {
        super(in, context);
    }

    protected void readMsg() throws IOException {
        byte[] token = this.readToken();
        this.buff = (byte[])(token == null ? null : this.unwrap(token));
        this.index = 0;
    }

    public int getWrapMode() {
        return this.mode;
    }

    public byte[] readHandshakeToken() throws IOException {
        byte[] token = this.readToken();
        if (token == null) {
            throw new EOFException();
        }
        return token;
    }

    protected byte[] readToken() throws IOException {
        byte[] buf = null;
        if (SSLUtil.read(this.in, this.header, 0, this.header.length) < 0) {
            return null;
        }
        if (SSLUtil.isSSLPacket(this.header)) {
            this.mode = 1;
            int l2 = this.in.read();
            if (l2 < 0) {
                throw new EOFException();
            }
            short len = SSLUtil.toShort(this.header[3], (byte)l2);
            buf = new byte[5 + len];
            System.arraycopy(this.header, 0, buf, 0, this.header.length);
            buf[4] = (byte)l2;
            if (SSLUtil.read(this.in, buf, 5, len) < 0) {
                return null;
            }
        } else {
            this.mode = 2;
            int len = SSLUtil.toInt(this.header, 0);
            if (len > 0x2000000) {
                throw new IOException("Token length " + len + " > " + 0x2000000);
            }
            buf = new byte[len];
            if (SSLUtil.read(this.in, buf, 0, buf.length) < 0) {
                return null;
            }
        }
        return buf;
    }
}

