/*
 * Decompiled with CFR 0.152.
 */
package org.globus.util.http;

import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.globus.util.log4j.CoGLevel;

public class HttpResponse {
    private static Logger logger = Logger.getLogger((String)(class$org$globus$util$http$HttpResponse == null ? (class$org$globus$util$http$HttpResponse = HttpResponse.class$("org.globus.util.http.HttpResponse")) : class$org$globus$util$http$HttpResponse).getName());
    protected InputStream input;
    protected long charsRead = 0L;
    public String httpType = null;
    public String httpMsg = null;
    public int httpCode = -1;
    public int contentLength = -1;
    public String connection = null;
    public String contentType = null;
    public String server = null;
    public boolean chunked = false;
    static /* synthetic */ Class class$org$globus$util$http$HttpResponse;

    public HttpResponse(InputStream in) throws IOException {
        this.input = in;
        this.parse();
    }

    protected String readLine(InputStream in) throws IOException {
        StringBuffer buf = new StringBuffer();
        int length = 0;
        while (true) {
            int c;
            if ((c = in.read()) == -1 || c == 10 || length > 512) {
                ++this.charsRead;
                break;
            }
            if (c == 13) {
                in.read();
                this.charsRead += 2L;
                break;
            }
            buf.append((char)c);
            ++length;
        }
        this.charsRead += (long)length;
        return buf.toString();
    }

    public static String getRest(String line) {
        int pos = line.indexOf(":");
        if (pos == -1) {
            return null;
        }
        return line.substring(pos + 1).trim();
    }

    public void parseHttp(String line) {
        String tmp;
        int p1 = line.indexOf(" ");
        if (p1 == -1) {
            return;
        }
        this.httpType = line.substring(0, p1);
        int p2 = line.indexOf(" ", p1 + 1);
        if (p2 == -1) {
            tmp = line.substring(p2);
        } else {
            tmp = line.substring(p1, p2);
            this.httpMsg = line.substring(p2).trim();
        }
        this.httpCode = Integer.parseInt(tmp.trim());
    }

    private void parse() throws IOException {
        String line = this.readLine(this.input);
        if (logger.isEnabledFor((Priority)CoGLevel.TRACE)) {
            logger.log((Priority)CoGLevel.TRACE, (Object)line);
        }
        this.parseHttp(line);
        while ((line = this.readLine(this.input)).length() != 0) {
            if (logger.isEnabledFor((Priority)CoGLevel.TRACE)) {
                logger.log((Priority)CoGLevel.TRACE, (Object)line);
            }
            String tmp = HttpResponse.getRest(line);
            if (line.startsWith("Connection: ")) {
                this.connection = tmp;
                continue;
            }
            if (line.startsWith("Server: ")) {
                this.server = tmp;
                continue;
            }
            if (line.startsWith("Content-Type: ")) {
                this.contentType = tmp;
                continue;
            }
            if (line.startsWith("Content-Length: ")) {
                this.contentLength = Integer.parseInt(tmp.trim());
                continue;
            }
            if (!line.startsWith("Transfer-Encoding: chunked")) continue;
            this.chunked = true;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Http    : " + this.httpType + "\n");
        buf.append("Message : " + this.httpMsg + "\n");
        buf.append("Code    : " + this.httpCode + "\n");
        if (this.server != null) {
            buf.append("Server  : " + this.server + "\n");
        }
        buf.append("Length  : " + this.contentLength + "\n");
        buf.append("Chunked : " + this.chunked + "\n");
        buf.append("Type    : " + this.contentType + "\n");
        if (this.connection != null) {
            buf.append("Connection   : " + this.connection + "\n");
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

