/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.apache.axis.enum.Style;
import org.apache.axis.enum.Use;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.CollectionTE;
import org.apache.axis.wsdl.symbolTable.Element;
import org.apache.axis.wsdl.symbolTable.FaultInfo;
import org.apache.axis.wsdl.symbolTable.MimeInfo;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaBindingWriter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaStubWriter
extends JavaClassWriter {
    private BindingEntry bEntry;
    private Binding binding;
    private SymbolTable symbolTable;
    static String[] modeStrings = new String[]{"", "org.apache.axis.description.ParameterDesc.IN", "org.apache.axis.description.ParameterDesc.OUT", "org.apache.axis.description.ParameterDesc.INOUT"};
    static HashMap styles = new HashMap();
    static HashMap uses = new HashMap();

    protected JavaStubWriter(Emitter emitter, BindingEntry bEntry, SymbolTable symbolTable) {
        super(emitter, bEntry.getName() + "Stub", "stub");
        this.bEntry = bEntry;
        this.binding = bEntry.getBinding();
        this.symbolTable = symbolTable;
    }

    protected String getExtendsText() {
        return "extends org.apache.axis.client.Stub ";
    }

    protected String getImplementsText() {
        return "implements " + this.bEntry.getDynamicVar(JavaBindingWriter.INTERFACE_NAME) + " ";
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        PortType portType = this.binding.getPortType();
        HashSet types = this.getTypesInPortType(portType);
        boolean hasMIME = Utils.hasMIME(this.bEntry);
        if (types.size() > 0 || hasMIME) {
            pw.println("    private java.util.Vector cachedSerClasses = new java.util.Vector();");
            pw.println("    private java.util.Vector cachedSerQNames = new java.util.Vector();");
            pw.println("    private java.util.Vector cachedSerFactories = new java.util.Vector();");
            pw.println("    private java.util.Vector cachedDeserFactories = new java.util.Vector();");
        }
        pw.println();
        pw.println("    static org.apache.axis.description.OperationDesc [] _operations;");
        pw.println();
        this.writeOperationMap(pw);
        pw.println();
        pw.println("    public " + this.className + "() throws org.apache.axis.AxisFault {");
        pw.println("         this(null);");
        pw.println("    }");
        pw.println();
        pw.println("    public " + this.className + "(java.net.URL endpointURL, javax.xml.rpc.Service service) throws org.apache.axis.AxisFault {");
        pw.println("         this(service);");
        pw.println("         super.cachedEndpoint = endpointURL;");
        pw.println("    }");
        pw.println();
        pw.println("    public " + this.className + "(javax.xml.rpc.Service service) throws org.apache.axis.AxisFault {");
        pw.println("        if (service == null) {");
        pw.println("            super.service = new org.apache.axis.client.Service();");
        pw.println("        } else {");
        pw.println("            super.service = service;");
        pw.println("        }");
        int typeMappingCount = 0;
        if (types.size() > 0) {
            Iterator it = types.iterator();
            while (it.hasNext()) {
                TypeEntry type = (TypeEntry)it.next();
                if (type.getBaseType() != null && type.getRefType() == null || type instanceof CollectionTE || type instanceof Element || !type.isReferenced() || type.isOnlyLiteralReferenced()) continue;
                if (typeMappingCount == 0) {
                    this.writeSerializationDecls(pw, hasMIME, this.binding.getQName().getNamespaceURI());
                }
                this.writeSerializationInit(pw, type);
                ++typeMappingCount;
            }
        }
        if (typeMappingCount == 0 && hasMIME) {
            this.writeSerializationDecls(pw, hasMIME, this.binding.getQName().getNamespaceURI());
            ++typeMappingCount;
        }
        pw.println("    }");
        pw.println();
        pw.println("    private org.apache.axis.client.Call createCall() throws java.rmi.RemoteException {");
        pw.println("        try {");
        pw.println("            org.apache.axis.client.Call _call =");
        pw.println("                    (org.apache.axis.client.Call) super.service.createCall();");
        pw.println("            if (super.maintainSessionSet) {");
        pw.println("                _call.setMaintainSession(super.maintainSession);");
        pw.println("            }");
        pw.println("            if (super.cachedUsername != null) {");
        pw.println("                _call.setUsername(super.cachedUsername);");
        pw.println("            }");
        pw.println("            if (super.cachedPassword != null) {");
        pw.println("                _call.setPassword(super.cachedPassword);");
        pw.println("            }");
        pw.println("            if (super.cachedEndpoint != null) {");
        pw.println("                _call.setTargetEndpointAddress(super.cachedEndpoint);");
        pw.println("            }");
        pw.println("            if (super.cachedTimeout != null) {");
        pw.println("                _call.setTimeout(super.cachedTimeout);");
        pw.println("            }");
        pw.println("            if (super.cachedPortName != null) {");
        pw.println("                _call.setPortName(super.cachedPortName);");
        pw.println("            }");
        pw.println("            java.util.Enumeration keys = super.cachedProperties.keys();");
        pw.println("            while (keys.hasMoreElements()) {");
        pw.println("                java.lang.String key = (java.lang.String) keys.nextElement();");
        pw.println("                _call.setProperty(key, super.cachedProperties.get(key));");
        pw.println("            }");
        if (typeMappingCount > 0) {
            pw.println("            // " + Messages.getMessage("typeMap00"));
            pw.println("            // " + Messages.getMessage("typeMap01"));
            pw.println("            // " + Messages.getMessage("typeMap02"));
            pw.println("            // " + Messages.getMessage("typeMap03"));
            pw.println("            // " + Messages.getMessage("typeMap04"));
            pw.println("            synchronized (this) {");
            pw.println("                if (firstCall()) {");
            pw.println("                    // " + Messages.getMessage("mustSetStyle"));
            if (this.bEntry.hasLiteral()) {
                pw.println("                    _call.setEncodingStyle(null);");
            } else {
                Iterator iterator = this.bEntry.getBinding().getExtensibilityElements().iterator();
                while (iterator.hasNext()) {
                    UnknownExtensibilityElement unkElement;
                    QName name;
                    Object obj = iterator.next();
                    if (obj instanceof SOAPBinding) {
                        pw.println("                    _call.setSOAPVersion(org.apache.axis.soap.SOAPConstants.SOAP11_CONSTANTS);");
                        pw.println("                    _call.setEncodingStyle(org.apache.axis.Constants.URI_SOAP11_ENC);");
                        continue;
                    }
                    if (!(obj instanceof UnknownExtensibilityElement) || !(name = (unkElement = (UnknownExtensibilityElement)obj).getElementType()).getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/") || !name.getLocalPart().equals("binding")) continue;
                    pw.println("                    _call.setSOAPVersion(org.apache.axis.soap.SOAPConstants.SOAP12_CONSTANTS);");
                    pw.println("                    _call.setEncodingStyle(org.apache.axis.Constants.URI_SOAP12_ENC);");
                }
            }
            pw.println("                    for (int i = 0; i < cachedSerFactories.size(); ++i) {");
            pw.println("                        java.lang.Class cls = (java.lang.Class) cachedSerClasses.get(i);");
            pw.println("                        javax.xml.namespace.QName qName =");
            pw.println("                                (javax.xml.namespace.QName) cachedSerQNames.get(i);");
            pw.println("                        java.lang.Class sf = (java.lang.Class)");
            pw.println("                                 cachedSerFactories.get(i);");
            pw.println("                        java.lang.Class df = (java.lang.Class)");
            pw.println("                                 cachedDeserFactories.get(i);");
            pw.println("                        _call.registerTypeMapping(cls, qName, sf, df, false);");
            pw.println("                    }");
            pw.println("                }");
            pw.println("            }");
        }
        pw.println("            return _call;");
        pw.println("        }");
        pw.println("        catch (java.lang.Throwable t) {");
        pw.println("            throw new org.apache.axis.AxisFault(\"" + Messages.getMessage("badCall01") + "\", t);");
        pw.println("        }");
        pw.println("    }");
        pw.println();
        List operations = this.binding.getBindingOperations();
        int i = 0;
        while (i < operations.size()) {
            BindingOperation operation = (BindingOperation)operations.get(i);
            Parameters parameters = this.bEntry.getParameters(operation.getOperation());
            String soapAction = "";
            String opStyle = null;
            Iterator operationExtensibilityIterator = operation.getExtensibilityElements().iterator();
            while (operationExtensibilityIterator.hasNext()) {
                UnknownExtensibilityElement unkElement;
                QName name;
                Object obj = operationExtensibilityIterator.next();
                if (obj instanceof SOAPOperation) {
                    soapAction = ((SOAPOperation)obj).getSoapActionURI();
                    opStyle = ((SOAPOperation)obj).getStyle();
                    break;
                }
                if (!(obj instanceof UnknownExtensibilityElement) || !(name = (unkElement = (UnknownExtensibilityElement)obj).getElementType()).getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/") || !name.getLocalPart().equals("operation")) continue;
                if (unkElement.getElement().getAttribute("soapAction") != null) {
                    soapAction = unkElement.getElement().getAttribute("soapAction");
                }
                opStyle = unkElement.getElement().getAttribute("style");
            }
            Operation ptOperation = operation.getOperation();
            OperationType type = ptOperation.getStyle();
            if (type == OperationType.NOTIFICATION || type == OperationType.SOLICIT_RESPONSE) {
                pw.println(parameters.signature);
                pw.println();
            } else {
                this.writeOperation(pw, operation, parameters, soapAction, opStyle, type == OperationType.ONE_WAY, i);
            }
            ++i;
        }
    }

    private void writeOperationMap(PrintWriter pw) {
        List operations = this.binding.getBindingOperations();
        pw.println("    static {");
        pw.println("        _operations = new org.apache.axis.description.OperationDesc[" + operations.size() + "];");
        pw.println("        org.apache.axis.description.OperationDesc oper;");
        int i = 0;
        while (i < operations.size()) {
            BindingOperation operation = (BindingOperation)operations.get(i);
            Parameters parameters = this.bEntry.getParameters(operation.getOperation());
            String opStyle = null;
            Iterator operationExtensibilityIterator = operation.getExtensibilityElements().iterator();
            while (operationExtensibilityIterator.hasNext()) {
                UnknownExtensibilityElement unkElement;
                QName name;
                Object obj = operationExtensibilityIterator.next();
                if (obj instanceof SOAPOperation) {
                    opStyle = ((SOAPOperation)obj).getStyle();
                    break;
                }
                if (!(obj instanceof UnknownExtensibilityElement) || !(name = (unkElement = (UnknownExtensibilityElement)obj).getElementType()).getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/") || !name.getLocalPart().equals("operation")) continue;
                opStyle = unkElement.getElement().getAttribute("style");
            }
            Operation ptOperation = operation.getOperation();
            OperationType type = ptOperation.getStyle();
            if (type == OperationType.NOTIFICATION || type == OperationType.SOLICIT_RESPONSE) {
                pw.println(parameters.signature);
                pw.println();
            }
            String operName = operation.getName();
            String indent = "        ";
            pw.println(indent + "oper = new org.apache.axis.description.OperationDesc();");
            pw.println(indent + "oper.setName(\"" + operName + "\");");
            int j = 0;
            while (j < parameters.list.size()) {
                Parameter p = (Parameter)parameters.list.get(j);
                QName paramType = Utils.getXSIType(p);
                String javaType = null;
                if (p.getMIMEInfo() != null) {
                    MimeInfo mimeInfo = p.getMIMEInfo();
                    javaType = JavaUtils.mimeToJava(mimeInfo.getType()) + mimeInfo.getDimensions() + ".class, ";
                } else {
                    javaType = p.getType().getName();
                    javaType = javaType != null ? javaType + ".class, " : "null, ";
                }
                String paramNameText = Utils.getNewQName(p.getQName());
                String paramTypeText = Utils.getNewQName(paramType);
                boolean isInHeader = p.isInHeader();
                boolean isOutHeader = p.isOutHeader();
                pw.println("        oper.addParameter(" + paramNameText + ", " + paramTypeText + ", " + javaType + modeStrings[p.getMode()] + ", " + isInHeader + ", " + isOutHeader + ");");
                ++j;
            }
            if (parameters.returnParam != null) {
                QName returnType = Utils.getXSIType(parameters.returnParam);
                String javaType = null;
                if (parameters.returnParam.getMIMEInfo() != null) {
                    MimeInfo mimeInfo = parameters.returnParam.getMIMEInfo();
                    javaType = JavaUtils.mimeToJava(mimeInfo.getType()) + mimeInfo.getDimensions();
                } else {
                    javaType = parameters.returnParam.getType().getName();
                }
                javaType = javaType == null ? "" : javaType + ".class";
                pw.println("        oper.setReturnType(" + Utils.getNewQName(returnType) + ");");
                pw.println("        oper.setReturnClass(" + javaType + ");");
                QName returnQName = parameters.returnParam.getQName();
                if (returnQName != null) {
                    pw.println("        oper.setReturnQName(" + Utils.getNewQName(returnQName) + ");");
                }
                if (parameters.returnParam.isOutHeader()) {
                    pw.println("        oper.setReturnHeader(true);");
                }
            } else {
                pw.println("        oper.setReturnType(org.apache.axis.encoding.XMLType.AXIS_VOID);");
            }
            boolean hasMIME = Utils.hasMIME(this.bEntry, operation);
            Style style = Style.getStyle(opStyle, this.bEntry.getBindingStyle());
            Use use = this.bEntry.getInputBodyType(operation.getOperation());
            if (style == Style.DOCUMENT && this.symbolTable.isWrapped()) {
                style = Style.WRAPPED;
            }
            if (!hasMIME) {
                pw.println("        oper.setStyle(" + styles.get(style) + ");");
                pw.println("        oper.setUse(" + uses.get(use) + ");");
            }
            this.writeFaultInfo(pw, operation);
            pw.println(indent + "_operations[" + i + "] = oper;");
            pw.println("");
            ++i;
        }
        pw.println("    }");
    }

    private HashSet getTypesInPortType(PortType portType) {
        HashSet<TypeEntry> types = new HashSet<TypeEntry>();
        HashSet firstPassTypes = new HashSet();
        List operations = portType.getOperations();
        int i = 0;
        while (i < operations.size()) {
            Operation op = (Operation)operations.get(i);
            firstPassTypes.addAll(this.getTypesInOperation(op));
            ++i;
        }
        Iterator i2 = firstPassTypes.iterator();
        while (i2.hasNext()) {
            TypeEntry type = (TypeEntry)i2.next();
            if (types.contains(type)) continue;
            types.add(type);
            types.addAll(org.apache.axis.wsdl.symbolTable.Utils.getNestedTypes(type, this.symbolTable, true));
        }
        return types;
    }

    private HashSet getTypesInOperation(Operation operation) {
        Map faults;
        HashSet types = new HashSet();
        Vector<TypeEntry> v = new Vector<TypeEntry>();
        Parameters params = this.bEntry.getParameters(operation);
        int i = 0;
        while (i < params.list.size()) {
            Parameter p = (Parameter)params.list.get(i);
            v.add(p.getType());
            ++i;
        }
        if (params.returnParam != null) {
            v.add(params.returnParam.getType());
        }
        if ((faults = operation.getFaults()) != null) {
            Iterator i2 = faults.values().iterator();
            while (i2.hasNext()) {
                Fault f = (Fault)i2.next();
                this.partTypes(v, f.getMessage().getOrderedParts(null));
            }
        }
        int i3 = 0;
        while (i3 < v.size()) {
            types.add(v.get(i3));
            ++i3;
        }
        return types;
    }

    private void partTypes(Vector v, Collection parts) {
        Iterator i = parts.iterator();
        while (i.hasNext()) {
            Part part = (Part)i.next();
            QName qType = part.getTypeName();
            if (qType != null) {
                v.add(this.symbolTable.getType(qType));
                continue;
            }
            qType = part.getElementName();
            if (qType == null) continue;
            v.add(this.symbolTable.getElement(qType));
        }
    }

    private void writeFaultInfo(PrintWriter pw, BindingOperation bindOp) {
        HashMap faultMap = this.bEntry.getFaults();
        ArrayList faults = (ArrayList)faultMap.get(bindOp);
        if (faults == null) {
            return;
        }
        Iterator faultIt = ((AbstractList)faults).iterator();
        while (faultIt.hasNext()) {
            FaultInfo info = (FaultInfo)faultIt.next();
            QName qname = info.getQName();
            Message message = info.getMessage();
            if (qname == null) continue;
            String className = Utils.getFullExceptionName(message, this.symbolTable);
            pw.println("        oper.addFault(new org.apache.axis.description.FaultDesc(");
            pw.println("                      " + Utils.getNewQName(qname) + ",");
            pw.println("                      \"" + className + "\",");
            pw.println("                      " + Utils.getNewQName(info.getXMLType()) + ", ");
            pw.println("                      " + Utils.isFaultComplex(message, this.symbolTable));
            pw.println("                     ));");
        }
    }

    private void writeSerializationDecls(PrintWriter pw, boolean hasMIME, String namespace) {
        pw.println("            java.lang.Class cls;");
        pw.println("            javax.xml.namespace.QName qName;");
        pw.println("            java.lang.Class beansf = org.apache.axis.encoding.ser.BeanSerializerFactory.class;");
        pw.println("            java.lang.Class beandf = org.apache.axis.encoding.ser.BeanDeserializerFactory.class;");
        pw.println("            java.lang.Class enumsf = org.apache.axis.encoding.ser.EnumSerializerFactory.class;");
        pw.println("            java.lang.Class enumdf = org.apache.axis.encoding.ser.EnumDeserializerFactory.class;");
        pw.println("            java.lang.Class arraysf = org.apache.axis.encoding.ser.ArraySerializerFactory.class;");
        pw.println("            java.lang.Class arraydf = org.apache.axis.encoding.ser.ArrayDeserializerFactory.class;");
        pw.println("            java.lang.Class simplesf = org.apache.axis.encoding.ser.SimpleSerializerFactory.class;");
        pw.println("            java.lang.Class simpledf = org.apache.axis.encoding.ser.SimpleDeserializerFactory.class;");
        if (hasMIME) {
            pw.println("            java.lang.Class mimesf = org.apache.axis.encoding.ser.JAFDataHandlerSerializerFactory.class;");
            pw.println("            java.lang.Class mimedf = org.apache.axis.encoding.ser.JAFDataHandlerDeserializerFactory.class;");
            pw.println();
            QName qname = new QName(namespace, "DataHandler");
            pw.println("            qName = new javax.xml.namespace.QName(\"" + qname.getNamespaceURI() + "\", \"" + qname.getLocalPart() + "\");");
            pw.println("            cachedSerQNames.add(qName);");
            pw.println("            cls = javax.activation.DataHandler.class;");
            pw.println("            cachedSerClasses.add(cls);");
            pw.println("            cachedSerFactories.add(mimesf);");
            pw.println("            cachedDeserFactories.add(mimedf);");
            pw.println();
        }
    }

    private void writeSerializationInit(PrintWriter pw, TypeEntry type) {
        QName qname = type.getQName();
        pw.println("            qName = new javax.xml.namespace.QName(\"" + qname.getNamespaceURI() + "\", \"" + qname.getLocalPart() + "\");");
        pw.println("            cachedSerQNames.add(qName);");
        pw.println("            cls = " + type.getName() + ".class;");
        pw.println("            cachedSerClasses.add(cls);");
        if (type.getName().endsWith("[]")) {
            pw.println("            cachedSerFactories.add(arraysf);");
            pw.println("            cachedDeserFactories.add(arraydf);");
        } else if (type.getNode() != null && Utils.getEnumerationBaseAndValues(type.getNode(), this.symbolTable) != null) {
            pw.println("            cachedSerFactories.add(enumsf);");
            pw.println("            cachedDeserFactories.add(enumdf);");
        } else if (type.isSimpleType()) {
            pw.println("            cachedSerFactories.add(simplesf);");
            pw.println("            cachedDeserFactories.add(simpledf);");
        } else if (type.getBaseType() != null) {
            pw.println("            cachedSerFactories.add(null);");
            pw.println("            cachedDeserFactories.add(simpledf);");
        } else {
            pw.println("            cachedSerFactories.add(beansf);");
            pw.println("            cachedDeserFactories.add(beandf);");
        }
        pw.println();
    }

    private void writeOperation(PrintWriter pw, BindingOperation operation, Parameters parms, String soapAction, String opStyle, boolean oneway, int opIndex) {
        Style style;
        this.writeComment(pw, operation.getDocumentationElement());
        pw.println(parms.signature + " {");
        pw.println("        if (super.cachedEndpoint == null) {");
        pw.println("            throw new org.apache.axis.NoEndPointException();");
        pw.println("        }");
        pw.println("        org.apache.axis.client.Call _call = createCall();");
        pw.println("        _call.setOperation(_operations[" + opIndex + "]);");
        if (soapAction != null) {
            pw.println("        _call.setUseSOAPAction(true);");
            pw.println("        _call.setSOAPActionURI(\"" + soapAction + "\");");
        }
        boolean hasMIME = Utils.hasMIME(this.bEntry, operation);
        Use use = this.bEntry.getInputBodyType(operation.getOperation());
        if (use == Use.LITERAL) {
            pw.println("        _call.setEncodingStyle(null);");
            pw.println("        _call.setProperty(org.apache.axis.client.Call.SEND_TYPE_ATTR, Boolean.FALSE);");
        }
        if (hasMIME || use == Use.LITERAL) {
            pw.println("        _call.setProperty(org.apache.axis.AxisEngine.PROP_DOMULTIREFS, Boolean.FALSE);");
        }
        if ((style = Style.getStyle(opStyle, this.bEntry.getBindingStyle())) == Style.DOCUMENT && this.symbolTable.isWrapped()) {
            style = Style.WRAPPED;
        }
        Iterator iterator = this.bEntry.getBinding().getExtensibilityElements().iterator();
        while (iterator.hasNext()) {
            UnknownExtensibilityElement unkElement;
            QName name;
            Object obj = iterator.next();
            if (obj instanceof SOAPBinding) {
                pw.println("        _call.setSOAPVersion(org.apache.axis.soap.SOAPConstants.SOAP11_CONSTANTS);");
                continue;
            }
            if (!(obj instanceof UnknownExtensibilityElement) || !(name = (unkElement = (UnknownExtensibilityElement)obj).getElementType()).getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/") || !name.getLocalPart().equals("binding")) continue;
            pw.println("        _call.setSOAPVersion(org.apache.axis.soap.SOAPConstants.SOAP12_CONSTANTS);");
        }
        if (style == Style.WRAPPED) {
            Map partsMap = operation.getOperation().getInput().getMessage().getParts();
            Part p = (Part)partsMap.values().iterator().next();
            QName q = p.getElementName();
            pw.println("        _call.setOperationName(" + Utils.getNewQName(q) + ");");
        } else {
            QName elementQName = Utils.getOperationQName(operation, this.bEntry, this.symbolTable);
            if (elementQName != null) {
                pw.println("        _call.setOperationName(" + Utils.getNewQName(elementQName) + ");");
            }
        }
        pw.println();
        pw.println("        setRequestHeaders(_call);");
        pw.println("        setAttachments(_call);");
        if (this.bEntry.isOperationDIME(operation.getOperation().getName())) {
            pw.println("        _call.setProperty(_call.ATTACHMENT_ENCAPSULATION_FORMAT, _call.ATTACHMENT_ENCAPSULATION_FORMAT_DIME);");
        }
        if (oneway) {
            pw.print("        _call.invokeOneWay(");
        } else {
            pw.print("        java.lang.Object _resp = _call.invoke(");
        }
        pw.print("new java.lang.Object[] {");
        this.writeParameters(pw, parms);
        pw.println("});");
        pw.println();
        if (!oneway) {
            this.writeResponseHandling(pw, parms);
        }
        pw.println("    }");
        pw.println();
    }

    private void writeParameters(PrintWriter pw, Parameters parms) {
        boolean needComma = false;
        int i = 0;
        while (i < parms.list.size()) {
            Parameter p = (Parameter)parms.list.get(i);
            if (p.getMode() != 2) {
                if (needComma) {
                    pw.print(", ");
                } else {
                    needComma = true;
                }
                String javifiedName = Utils.xmlNameToJava(p.getName());
                if (p.getMode() != 1) {
                    javifiedName = javifiedName + ".value";
                }
                if (p.getMIMEInfo() == null) {
                    javifiedName = Utils.wrapPrimitiveType(p.getType(), javifiedName);
                }
                pw.print(javifiedName);
            }
            ++i;
        }
    }

    private void writeResponseHandling(PrintWriter pw, Parameters parms) {
        pw.println("        if (_resp instanceof java.rmi.RemoteException) {");
        pw.println("            throw (java.rmi.RemoteException)_resp;");
        pw.println("        }");
        int allOuts = parms.outputs + parms.inouts;
        if (allOuts > 0) {
            pw.println("        else {");
            pw.println("            extractAttachments(_call);");
            if (allOuts == 1) {
                if (parms.returnParam != null) {
                    this.writeOutputAssign(pw, "return ", parms.returnParam.getType(), parms.returnParam.getMIMEInfo(), "_resp");
                } else {
                    int i = 0;
                    Parameter p = (Parameter)parms.list.get(i);
                    while (p.getMode() == 1) {
                        p = (Parameter)parms.list.get(++i);
                    }
                    String javifiedName = Utils.xmlNameToJava(p.getName());
                    String qnameName = Utils.getNewQName(p.getQName());
                    pw.println("            java.util.Map _output;");
                    pw.println("            _output = _call.getOutputParams();");
                    this.writeOutputAssign(pw, javifiedName + ".value = ", p.getType(), p.getMIMEInfo(), "_output.get(" + qnameName + ")");
                }
            } else {
                pw.println("            java.util.Map _output;");
                pw.println("            _output = _call.getOutputParams();");
                int i = 0;
                while (i < parms.list.size()) {
                    Parameter p = (Parameter)parms.list.get(i);
                    String javifiedName = Utils.xmlNameToJava(p.getName());
                    String qnameName = Utils.getNewQName(p.getQName());
                    if (p.getMode() != 1) {
                        this.writeOutputAssign(pw, javifiedName + ".value = ", p.getType(), p.getMIMEInfo(), "_output.get(" + qnameName + ")");
                    }
                    ++i;
                }
                if (parms.returnParam != null) {
                    this.writeOutputAssign(pw, "return ", parms.returnParam.getType(), parms.returnParam.getMIMEInfo(), "_resp");
                }
            }
            pw.println("        }");
        } else {
            pw.println("        extractAttachments(_call);");
        }
    }

    private void writeOutputAssign(PrintWriter pw, String target, TypeEntry type, MimeInfo mimeInfo, String source) {
        if (type != null && type.getName() != null) {
            pw.println("            try {");
            pw.println("                " + target + Utils.getResponseString(type, mimeInfo, source));
            pw.println("            } catch (java.lang.Exception _exception) {");
            pw.println("                " + target + Utils.getResponseString(type, mimeInfo, "org.apache.axis.utils.JavaUtils.convert(" + source + ", " + type.getName() + ".class)"));
            pw.println("            }");
        } else {
            pw.println("              " + target + Utils.getResponseString(type, mimeInfo, source));
        }
    }

    static {
        styles.put(Style.DOCUMENT, "org.apache.axis.enum.Style.DOCUMENT");
        styles.put(Style.RPC, "org.apache.axis.enum.Style.RPC");
        styles.put(Style.MESSAGE, "org.apache.axis.enum.Style.MESSAGE");
        styles.put(Style.WRAPPED, "org.apache.axis.enum.Style.WRAPPED");
        uses.put(Use.ENCODED, "org.apache.axis.enum.Use.ENCODED");
        uses.put(Use.LITERAL, "org.apache.axis.enum.Use.LITERAL");
    }
}

