/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.GeneralRandomAccessFile;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.MetaDataTable;
import edu.sdsc.grid.io.RemoteFile;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBCommands;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import edu.sdsc.grid.io.srb.SRBMetaDataRecordList;
import edu.sdsc.grid.io.srb.SRBMetaDataSet;
import edu.sdsc.grid.io.srb.SRBRandomAccessFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Vector;

public class SRBFile
extends RemoteFile {
    public static final int MDAS_CATALOG = 0;
    public static final int LDAP_CATALOG = 1;
    public static final int FILE_CATALOG = 2;
    public static final String PATH_SEPARATOR = "/";
    public static final char PATH_SEPARATOR_CHAR = '/';
    static final int OPR_COPY = 0;
    static int MAX_NUMBER_OF_PARALLEL_THREADS = 4;
    static int MAX_NUMBER_OF_BULK_THREADS = 1;
    static int MIN_THREAD_SIZE = 30000000;
    static final int BULK_LOAD_BUFFER_SIZE = 0x200000;
    static final int MAX_BULK_FILE_SIZE = 0x200000;
    static final int MAX_REGISTRATION_FILES = 300;
    static final int LIST_CHECKSUM = 16;
    static final int COMPUTE_CHECKSUM = 128;
    static final int FORCE_CHECKSUM = 32;
    static String ZONE_AUTHORITY = "http://www.sdsc.edu/srb/cgi-bin/zoneList.cgi?zone=";
    static boolean USE_BULKCOPY = true;
    private static String MODIFY_DEFINABLE_METADATA_SEPERATOR = "|";
    static final int PATH_IS_UNKNOWN = 0;
    static final int PATH_IS_FILE = 1;
    static final int PATH_IS_DIRECTORY = 2;
    protected SRBFileSystem srbFileSystem;
    int catalogType = 0;
    String resource;
    String dataType = "generic";
    boolean deleteOnExit = false;
    static Vector uriFileSystems = new Vector();
    String originalFilePath;
    private int replicaNumber = -1;
    public boolean completeDirectoryList = true;
    int pathNameType = 0;
    String serverLocalPath = "";
    boolean useCache = false;
    private volatile int loadBufferCount = 0;
    int activeRegistrationThread = 0;
    int filesReadyToRegister = 0;

    public SRBFile(SRBFileSystem sRBFileSystem, String string) throws NullPointerException {
        this(sRBFileSystem, "", string);
        this.originalFilePath = string;
    }

    public SRBFile(SRBFileSystem sRBFileSystem, String string, String string2) throws NullPointerException, IllegalArgumentException {
        super(sRBFileSystem, string, string2);
        this.makePathCanonical(string);
        this.resource = sRBFileSystem.getDefaultStorageResource();
        this.originalFilePath = string != null ? (!string.equals("") ? string + PATH_SEPARATOR + string2 : string2) : string2;
    }

    public SRBFile(SRBFile sRBFile, String string) throws NullPointerException {
        this((SRBFileSystem)sRBFile.getFileSystem(), sRBFile.getPath(), string);
    }

    public SRBFile(URI uRI) throws NullPointerException, IOException {
        super(uRI);
        String string;
        if (!uRI.getScheme().equals("srb")) {
            throw new IllegalArgumentException();
        }
        SRBAccount sRBAccount = SRBFile.uriInitialAccount(uRI);
        String string2 = null;
        this.originalFilePath = string = uRI.getPath();
        this.setFileSystem(new SRBFileSystem(sRBAccount));
        string2 = SRBFile.getProperZone(this.srbFileSystem);
        this.srbFileSystem.setProxyMcatZone(string2);
        this.srbFileSystem.setMcatZone(string2);
        this.srbFileSystem.setDefaultStorageResource(SRBFile.getAvailableResource(this.srbFileSystem));
        if (string == null || string == "") {
            this.setFileName(PATH_SEPARATOR);
        } else {
            this.setFileName(string);
        }
        this.setFileSystem(SRBFile.uriTest(this.srbFileSystem));
    }

    protected void finalize() throws Throwable {
        if (this.deleteOnExit) {
            this.delete();
        }
        super.finalize();
        if (this.resource != null) {
            this.resource = null;
        }
        if (this.dataType != null) {
            this.dataType = null;
        }
    }

    static SRBAccount uriInitialAccount(URI uRI) throws IOException {
        String string = uRI.getHost();
        int n = uRI.getPort();
        String string2 = uRI.getPath();
        String string3 = uRI.getUserInfo();
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        int n2 = -1;
        if (string3 == null || string3 == "") {
            string4 = "public";
            string5 = "npaci";
            string6 = "CANDO";
            string7 = "/home/public.npaci/";
        } else {
            n2 = string3.indexOf(".");
            if (n2 < 0) {
                throw new MalformedURLException();
            }
            string4 = string3.substring(0, n2);
            if (n2 < 0) {
                throw new MalformedURLException();
            }
            if ((n2 = (string3 = string3.substring(n2 + 1)).indexOf(":")) > 0) {
                string5 = string3.substring(0, n2);
                string6 = string3.substring(n2 + 1);
            } else {
                string5 = string3;
            }
            string7 = "/home/" + string4 + "." + string5;
        }
        n2 = string.indexOf(".");
        if (n2 < 0) {
            URL uRL = new URL(ZONE_AUTHORITY + string);
            InputStream inputStream = uRL.openConnection().getInputStream();
            int n3 = -1;
            String string8 = null;
            byte[] byArray = new byte[1000];
            inputStream.read(byArray);
            string8 = new String(byArray);
            inputStream.read(byArray);
            string8 = string8 + new String(byArray);
            n2 = string8.indexOf("ns1:server");
            n3 = string8.indexOf("/ns1:server", n2 + 11);
            if (n2 < 0 || n3 < 0) {
                throw new ConnectException("Invalid zone name.");
            }
            string = string8.substring(n2 + 11, n3 - 1);
            n2 = string8.indexOf("ns1:port");
            if ((string8 = string8.substring(n2 + 9, (n3 = string8.indexOf("/ns1:port", n2 + 9)) - 1)) != null && string8.length() > 0) {
                n = Integer.parseInt(string8);
            }
        }
        if (n < 0) {
            n = 5544;
        }
        return new SRBAccount(string, n, string4, string6, string7, string5, "");
    }

    static String getProperZone(SRBFileSystem sRBFileSystem) throws IOException {
        if (sRBFileSystem.getVersionNumber() >= 3.0f) {
            String string = sRBFileSystem.getUserName();
            String string2 = sRBFileSystem.getDomainName();
            MetaDataRecordList[] metaDataRecordListArray = sRBFileSystem.query("zone name");
            if (metaDataRecordListArray == null) {
                MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", 10, string), MetaDataSet.newCondition("user domain", 0, string2)};
                MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("zone name")};
                metaDataRecordListArray = sRBFileSystem.query(metaDataConditionArray, metaDataSelectArray);
            }
            return metaDataRecordListArray[0].getValue("zone name").toString();
        }
        return null;
    }

    static String getAvailableResource(SRBFileSystem sRBFileSystem) throws IOException {
        MetaDataRecordList[] metaDataRecordListArray = null;
        if (sRBFileSystem.getVersionNumber() >= 3.0f) {
            MetaDataSelect[] metaDataSelectArray;
            String string = sRBFileSystem.getUserName();
            String string2 = sRBFileSystem.getDomainName();
            String string3 = sRBFileSystem.getMcatZone();
            MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("resource access privilege", 10, "%write%"), MetaDataSet.newCondition("user name used for resource access", 0, string), MetaDataSet.newCondition("user domn used for resource access", 0, string2), MetaDataSet.newCondition("user zone used for resource access", 0, string3)};
            metaDataRecordListArray = sRBFileSystem.query(metaDataConditionArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("resource name")});
            if (metaDataRecordListArray == null && (metaDataRecordListArray = sRBFileSystem.query("resource name")) == null) {
                throw new FileNotFoundException("No resources available");
            }
        }
        int n = (int)Math.round((double)(metaDataRecordListArray.length - 1) * Math.random());
        return metaDataRecordListArray[n].getValue("resource name").toString();
    }

    static synchronized SRBFileSystem uriTest(SRBFileSystem sRBFileSystem) {
        SRBFileSystem sRBFileSystem2 = null;
        int n = 0;
        while (n < uriFileSystems.size()) {
            sRBFileSystem2 = (SRBFileSystem)uriFileSystems.get(n);
            if (sRBFileSystem.equals(sRBFileSystem2)) {
                sRBFileSystem = sRBFileSystem2;
                return sRBFileSystem;
            }
            if (!sRBFileSystem2.isConnected()) {
                uriFileSystems.remove(n);
            }
            ++n;
        }
        uriFileSystems.add(sRBFileSystem);
        return sRBFileSystem;
    }

    protected void setFileName(String string) {
        int n;
        String string2 = System.getProperty("file.separator");
        if (string == null) {
            throw new NullPointerException("The file name cannot be null");
        }
        if (!string2.equals(PATH_SEPARATOR)) {
            n = string.lastIndexOf(string2);
            while (n >= 0 && string.substring(n + 1).length() > 0) {
                string = string.substring(0, n) + PATH_SEPARATOR + string.substring(n + 1);
                n = string.lastIndexOf(string2);
            }
        }
        this.fileName = string;
        if (this.fileName.length() > 1) {
            n = this.fileName.lastIndexOf(PATH_SEPARATOR);
            while (n == this.fileName.length() - 1 && n >= 0) {
                this.fileName = this.fileName.substring(0, n);
                n = this.fileName.lastIndexOf(PATH_SEPARATOR);
            }
            if (n >= 0 && this.fileName.substring(n + 1).length() > 0) {
                this.setDirectory(this.fileName.substring(0, n + 1));
                this.fileName = this.fileName.substring(n + 1);
            }
        }
    }

    protected void setDirectory(String string) {
        if (this.directory == null) {
            this.directory = new Vector();
        }
        if (string == null) {
            return;
        }
        String string2 = System.getProperty("file.separator");
        int n = string.lastIndexOf(string2);
        if (n >= 0 && string.substring(n + 1).length() > 0) {
            string = string.substring(0, n) + PATH_SEPARATOR + string.substring(n + 1);
            n = string.lastIndexOf(string2);
        }
        while (this.directory.size() > 0 && string.startsWith(PATH_SEPARATOR)) {
            string = string.substring(1);
        }
        n = string.indexOf(PATH_SEPARATOR);
        if (n >= 0) {
            do {
                this.directory.add(string.substring(0, n));
                while ((n = (string = string.substring(n + 1)).indexOf(PATH_SEPARATOR)) == 0) {
                }
            } while (n >= 0);
        }
        if (!string.equals("") && string != null) {
            this.directory.add(string);
        }
    }

    void makePathCanonical(String string) {
        int n = 0;
        boolean bl = false;
        String string2 = null;
        if (string == null) {
            string = "";
        }
        if (this.fileName.equals(PATH_SEPARATOR) && string == "") {
            return;
        }
        if (this.fileName.equals("") && string.equals("")) {
            String string3 = this.srbFileSystem.getHomeDirectory();
            int n2 = string3.lastIndexOf(PATH_SEPARATOR);
            this.setDirectory(string3.substring(0, n2));
            this.setFileName(string3.substring(n2 + 1));
            return;
        }
        if (string.startsWith(PATH_SEPARATOR)) {
            bl = true;
        }
        if (this.directory.size() > 0 && this.directory.get(0).toString().length() == 0) {
            bl = true;
        }
        if (!bl) {
            String string4 = this.srbFileSystem.getHomeDirectory();
            int n3 = string4.indexOf(PATH_SEPARATOR);
            if (n3 >= 0) {
                do {
                    this.directory.add(n, string4.substring(0, n3));
                    string4 = string4.substring(n3 + 1);
                    n3 = string4.indexOf(PATH_SEPARATOR);
                    ++n;
                } while (n3 > 0);
            }
            if (!string4.equals("") && string4 != null) {
                this.directory.add(n, string4);
            }
        }
        n = 0;
        while (n < this.directory.size()) {
            string2 = this.directory.get(n).toString();
            if (string2.equals(".")) {
                this.directory.remove(n);
                --n;
            } else if (string2.equals("..") && n >= 2) {
                this.directory.remove(n);
                this.directory.remove(n - 1);
                if (--n > 0) {
                    --n;
                }
            } else if (string2.equals("..")) {
                this.directory.remove(n);
                --n;
            } else if (string2.startsWith(PATH_SEPARATOR)) {
                while ((string2 = string2.substring(1)).startsWith(PATH_SEPARATOR)) {
                }
                this.directory.remove(n);
                this.directory.add(n, string2);
            }
            ++n;
        }
        if (this.fileName.equals(".")) {
            this.fileName = this.directory.get(this.directory.size() - 1).toString();
            this.directory.remove(this.directory.size() - 1);
        } else if (this.fileName.equals("..")) {
            if (this.directory.size() > 1) {
                this.fileName = this.directory.get(this.directory.size() - 2).toString();
                this.directory.remove(this.directory.size() - 1);
                this.directory.remove(this.directory.size() - 1);
            } else {
                this.fileName = PATH_SEPARATOR;
                this.directory.remove(this.directory.size() - 1);
            }
        }
        this.getReplicaNumber();
    }

    protected void setFileSystem(GeneralFileSystem generalFileSystem) throws IllegalArgumentException {
        if (generalFileSystem == null) {
            throw new IllegalArgumentException("Illegal fileSystem, cannot be null");
        }
        this.fileSystem = generalFileSystem;
        this.srbFileSystem = (SRBFileSystem)this.fileSystem;
    }

    public void setResource(String string) throws IOException, NullPointerException, IllegalArgumentException {
        if (string != null) {
            MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("resource name", 0, string)};
            MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("resource name")};
            MetaDataRecordList[] metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray);
            if (metaDataRecordListArray == null) {
                throw new IllegalArgumentException("Resource not found");
            }
            this.resource = string;
            if (this.isFile()) {
                boolean bl = true;
                metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 0, this.getParent()), MetaDataSet.newCondition("file name", 0, this.fileName)};
                metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray);
                if (metaDataRecordListArray != null) {
                    int n = 0;
                    while (n < metaDataRecordListArray.length) {
                        if (metaDataRecordListArray[n].getStringValue(0) == string) {
                            bl = false;
                            n = metaDataRecordListArray.length;
                        }
                        ++n;
                    }
                }
                if (bl) {
                    this.srbFileSystem.srbObjMove(this.catalogType, this.fileName, this.getParent(), null, this.resource, this.serverLocalPath, null);
                }
            }
        } else {
            throw new NullPointerException();
        }
    }

    public void setDataType(String string) throws IOException {
        if (string == null) {
            string = "generic";
        }
        if (this.isFile()) {
            if (this.getReplicaNumber() >= 0) {
                this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), null, null, string, null, 5);
            } else {
                this.srbFileSystem.srbModifyDataset(this.catalogType, this.getName(), this.getParent(), null, null, string, null, 5);
            }
        }
        this.dataType = string;
    }

    public void setReplicaNumber(int n) {
        if (n >= 0) {
            this.fileName = this.getName() + "&COPY=" + n;
            this.replicaNumber = n;
        } else {
            this.fileName = this.getName();
            this.replicaNumber = -1;
        }
    }

    public void setServerLocalPath(String string) {
        this.serverLocalPath = string;
    }

    public int getReplicaNumber() {
        if (this.replicaNumber >= 0) {
            return this.replicaNumber;
        }
        int n = this.fileName.indexOf("&COPY=");
        if (n >= 0) {
            this.replicaNumber = new Integer(this.fileName.substring(n + 6));
            return this.replicaNumber;
        }
        return -1;
    }

    public String getResource() throws IOException {
        if (this.isDirectory()) {
            return null;
        }
        if (this.resource != null) {
            return this.resource;
        }
        MetaDataRecordList[] metaDataRecordListArray = this.query("physical resource name");
        if (metaDataRecordListArray != null) {
            this.resource = metaDataRecordListArray[0].getValue("physical resource name").toString();
            return this.resource;
        }
        return null;
    }

    String getPhysicalPath() throws IOException {
        MetaDataRecordList[] metaDataRecordListArray = this.query("path name");
        metaDataRecordListArray = MetaDataRecordList.getAllResults(metaDataRecordListArray);
        return metaDataRecordListArray[0].getValue("path name").toString();
    }

    public String getDataType() throws IOException {
        if (this.isDirectory()) {
            return this.dataType;
        }
        MetaDataRecordList[] metaDataRecordListArray = this.query("data type name");
        if (metaDataRecordListArray == null) {
            return null;
        }
        return metaDataRecordListArray[0].getValue("data type name").toString();
    }

    public int getCatalogType() {
        return this.catalogType;
    }

    public final String getPathSeparator() {
        return PATH_SEPARATOR;
    }

    public final char getPathSeparatorChar() {
        return '/';
    }

    public GeneralFileSystem getFileSystem() throws NullPointerException {
        if (this.srbFileSystem != null) {
            return this.srbFileSystem;
        }
        throw new NullPointerException("fileSystem is null.");
    }

    public String getServerLocalPath() {
        if (this.serverLocalPath == null || this.serverLocalPath.equals("")) {
            block4: {
                try {
                    MetaDataRecordList[] metaDataRecordListArray = this.query("path name");
                    if (metaDataRecordListArray != null) {
                        this.serverLocalPath = metaDataRecordListArray[0].getStringValue(0);
                    }
                }
                catch (IOException iOException) {
                    if (SRBCommands.DEBUG <= 0) break block4;
                    iOException.printStackTrace();
                }
            }
            return this.serverLocalPath;
        }
        return this.serverLocalPath;
    }

    public MetaDataRecordList[] query(String string) throws IOException {
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection(string)};
        return this.query(metaDataSelectArray, SRBFileSystem.DEFAULT_RECORDS_WANTED);
    }

    public MetaDataRecordList[] query(String[] stringArray) throws IOException {
        return this.query(MetaDataSet.newSelection(stringArray), SRBFileSystem.DEFAULT_RECORDS_WANTED);
    }

    public MetaDataRecordList[] query(MetaDataSelect metaDataSelect) throws IOException {
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{metaDataSelect};
        return this.query(metaDataSelectArray, SRBFileSystem.DEFAULT_RECORDS_WANTED);
    }

    public MetaDataRecordList[] query(MetaDataSelect[] metaDataSelectArray) throws IOException {
        return this.query(metaDataSelectArray, SRBFileSystem.DEFAULT_RECORDS_WANTED);
    }

    public MetaDataRecordList[] query(MetaDataSelect[] metaDataSelectArray, int n) throws IOException {
        MetaDataCondition[] metaDataConditionArray = null;
        String string = null;
        int n2 = 0;
        String string2 = null;
        if (this.isDirectory()) {
            metaDataConditionArray = new MetaDataCondition[1];
            string = "directory name";
            n2 = 0;
            string2 = this.getAbsolutePath();
            metaDataConditionArray[0] = MetaDataSet.newCondition(string, n2, string2);
        } else {
            metaDataConditionArray = new MetaDataCondition[3];
            string = "directory name";
            n2 = 0;
            string2 = this.getParent();
            metaDataConditionArray[0] = MetaDataSet.newCondition(string, n2, string2);
            string = "file name";
            string2 = this.getName();
            metaDataConditionArray[1] = MetaDataSet.newCondition(string, n2, string2);
            if (this.getReplicaNumber() >= 0) {
                string = "file replication enum";
                string2 = "" + this.replicaNumber;
                metaDataConditionArray[2] = MetaDataSet.newCondition(string, n2, string2);
            }
        }
        return this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray, n);
    }

    public MetaDataRecordList[] query(MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray) throws IOException {
        return this.query(metaDataConditionArray, metaDataSelectArray, SRBFileSystem.DEFAULT_RECORDS_WANTED);
    }

    public MetaDataRecordList[] query(MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray, int n) throws IOException {
        MetaDataCondition[] metaDataConditionArray2 = null;
        String string = null;
        int n2 = 0;
        String string2 = null;
        if (this.isDirectory()) {
            metaDataConditionArray2 = new MetaDataCondition[metaDataConditionArray.length + 1];
            System.arraycopy(metaDataConditionArray, 0, metaDataConditionArray2, 0, metaDataConditionArray.length);
            string = "directory name";
            n2 = 0;
            string2 = this.getAbsolutePath();
            metaDataConditionArray2[metaDataConditionArray.length] = MetaDataSet.newCondition(string, n2, string2);
        } else {
            metaDataConditionArray2 = new MetaDataCondition[metaDataConditionArray.length + 3];
            System.arraycopy(metaDataConditionArray, 0, metaDataConditionArray2, 0, metaDataConditionArray.length);
            string = "directory name";
            n2 = 0;
            string2 = this.getParent();
            metaDataConditionArray2[metaDataConditionArray.length] = MetaDataSet.newCondition(string, n2, string2);
            string = "file name";
            string2 = this.fileName;
            metaDataConditionArray2[metaDataConditionArray.length + 1] = MetaDataSet.newCondition(string, n2, string2);
            if (this.getReplicaNumber() >= 0) {
                string = "file replication enum";
                string2 = "" + this.replicaNumber;
                metaDataConditionArray2[2] = MetaDataSet.newCondition(string, n2, string2);
            }
        }
        return this.srbFileSystem.query(metaDataConditionArray2, metaDataSelectArray, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void modifyMetaData(MetaDataRecordList metaDataRecordList) throws IOException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this.isFile();
        String string5 = null;
        if (this.serverLocalPath == null || this.serverLocalPath.equals("")) {
            if (this.getReplicaNumber() < 0 && bl3) {
                MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("path name"), MetaDataSet.newSelection("resource name")};
                MetaDataRecordList[] metaDataRecordListArray = this.query(metaDataSelectArray);
                if (metaDataRecordListArray == null) throw new FileNotFoundException("Vault path/resource not found.");
                string5 = metaDataRecordListArray[0].getValue("path name").toString();
                this.resource = metaDataRecordListArray[0].getValue("resource name").toString();
            }
        } else {
            string5 = this.serverLocalPath;
        }
        int n = -1;
        boolean bl4 = false;
        int n2 = 0;
        while (n2 < metaDataRecordList.getFieldCount()) {
            int n3;
            int n4;
            int n5;
            MetaDataTable metaDataTable;
            bl4 = metaDataRecordList.getValue(n2) == null;
            string4 = metaDataRecordList.getFieldName(n2);
            if (string4 == "file comments") {
                if (bl4) {
                    n = 12;
                } else {
                    n = 13;
                    string = metaDataRecordList.getStringValue(n2);
                }
            } else if (string4 == "size") {
                n = 4;
                string = metaDataRecordList.getStringValue(n2);
                bl = true;
            } else if (string4 == "data type name") {
                n = 5;
                string = metaDataRecordList.getStringValue(n2);
            } else if (string4 == "directory name") {
                n = 6;
                string = metaDataRecordList.getStringValue(n2);
            } else if (string4 == "offset") {
                n = 35;
                string = metaDataRecordList.getStringValue(n2);
            } else if (string4 == "is dirty") {
                n = 36;
                string = metaDataRecordList.getStringValue(n2);
            } else if (string4 == "file replication enum") {
                n = 132;
                string = metaDataRecordList.getStringValue(n2);
            } else if (string4 == "file lock num") {
                n = 85;
                string = metaDataRecordList.getStringValue(n2);
            } else if (string4 == "file checksum") {
                n = 137;
                string = metaDataRecordList.getStringValue(n2);
            } else if (string4 == "file hide") {
                n = 138;
                string = metaDataRecordList.getStringValue(n2);
            } else if (string4 == "file auditflag") {
                n = 139;
                string = metaDataRecordList.getStringValue(n2);
            } else if (string4 == "file pin val") {
                n = 140;
                string = metaDataRecordList.getStringValue(n2);
            } else if (string4 == "file expiry date") {
                n = 141;
                string = metaDataRecordList.getStringValue(n2);
            } else if (string4 == "file expire date 2") {
                n = 142;
                string = metaDataRecordList.getStringValue(n2);
            } else if (string4 == "file is compressed") {
                n = 143;
                string = metaDataRecordList.getStringValue(n2);
            } else if (string4 == "file is encrypted") {
                n = 144;
                string = metaDataRecordList.getStringValue(n2);
            } else if (string4 == "file name") {
                n = 29;
                string = metaDataRecordList.getStringValue(n2);
            } else if (string4 == "file annotation") {
                if (bl4) {
                    n = 39;
                } else {
                    n = 40;
                    string = metaDataRecordList.getStringValue(n2);
                    string2 = metaDataRecordList.getValue("file annotation position").toString();
                }
            } else if (string4 == "owner") {
                n = 15;
                string = metaDataRecordList.getStringValue(n2);
            } else if (string4 == "path name") {
                n = 126;
                string = metaDataRecordList.getStringValue(n2);
            } else if (string4 == "modification date") {
                n = 42;
                string = metaDataRecordList.getStringValue(n2);
            } else if (string4 == "file last access timestamp") {
                n = 76;
                string = metaDataRecordList.getStringValue(n2);
            } else if (string4 == "file class name") {
                if (bl4) {
                    n = 43;
                } else {
                    n = 44;
                    string = metaDataRecordList.getStringValue(n2);
                }
            } else if (string4 == "index name for file") {
                if (bl4) {
                    n = 45;
                } else {
                    n = 46;
                    string = metaDataRecordList.getStringValue(n2);
                }
            } else if (string4 == "index name for datatype") {
                if (bl4) {
                    n = 47;
                } else {
                    n = 48;
                    string = metaDataRecordList.getStringValue(n2);
                }
            } else if (string4 == "index name for directory") {
                if (bl4) {
                    n = 49;
                } else {
                    n = 50;
                    string = metaDataRecordList.getStringValue(n2);
                }
            } else if (string4 == "method name for file") {
                if (bl4) {
                    n = 51;
                } else {
                    n = 52;
                    string = metaDataRecordList.getStringValue(n2);
                }
            } else if (string4 == "method name for datatype") {
                if (bl4) {
                    n = 53;
                } else {
                    n = 54;
                    string = metaDataRecordList.getStringValue(n2);
                }
            } else if (string4 == "method name for directory") {
                if (bl4) {
                    n = 55;
                } else {
                    n = 56;
                    string = metaDataRecordList.getStringValue(n2);
                }
            } else if (string4 == "definable metadata for files") {
                if (bl4) {
                    if (string5 == null) {
                        this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), null, null, "-1", "", 63);
                    } else {
                        this.srbFileSystem.srbModifyDataset(this.catalogType, this.getName(), this.getParent(), this.resource, string5, "-1", "", 63);
                    }
                } else {
                    metaDataTable = metaDataRecordList.getTableValue(n2);
                    string2 = MODIFY_DEFINABLE_METADATA_SEPERATOR;
                    n5 = 0;
                    while (n5 < metaDataTable.getRowCount()) {
                        string = "";
                        n4 = metaDataTable.getColumnCount();
                        n3 = 0;
                        while (n3 < n4) {
                            string = n3 == n4 - 1 ? string + metaDataTable.getStringValue(n5, n3) : string + metaDataTable.getStringValue(n5, n3) + string2;
                            ++n3;
                        }
                        if (string5 == null) {
                            this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), null, null, string, string2, 147);
                        } else {
                            this.srbFileSystem.srbModifyDataset(this.catalogType, this.getName(), this.getParent(), this.resource, string5, string, string2, 147);
                        }
                        ++n5;
                    }
                }
            } else if (string4 == "definable metadata for directories") {
                if (bl4) {
                    this.srbFileSystem.srbModifyCollect(this.catalogType, this.getAbsolutePath(), "-1", string2, string3, 72);
                } else {
                    metaDataTable = metaDataRecordList.getTableValue(n2);
                    string2 = MODIFY_DEFINABLE_METADATA_SEPERATOR;
                    n5 = 0;
                    while (n5 < metaDataTable.getRowCount()) {
                        string = "";
                        n4 = metaDataTable.getColumnCount();
                        n3 = 0;
                        while (n3 < n4) {
                            string = n3 == n4 - 1 ? string + metaDataTable.getStringValue(n5, n3) : string + metaDataTable.getStringValue(n5, n3) + string2;
                            ++n3;
                        }
                        this.srbFileSystem.srbModifyCollect(this.catalogType, this.getAbsolutePath(), string, string2, string3, 148);
                        ++n5;
                    }
                }
            } else if (string4 == "directory annotation") {
                n = 111;
                string = metaDataRecordList.getStringValue(n2);
            } else if (string4 == "container for directory") {
                n = 146;
                string = metaDataRecordList.getStringValue(n2);
            } else if (string4 == "guid") {
                if (bl4) {
                    n = 169;
                } else {
                    if (string5 == null) {
                        this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), null, null, string, string2, 169);
                    } else {
                        this.srbFileSystem.srbModifyDataset(this.catalogType, this.getName(), this.getParent(), this.resource, string5, string, string2, 169);
                    }
                    n = 168;
                    string = metaDataRecordList.getStringValue(n2);
                    string2 = "1";
                }
            } else if (string4 == "directory link number") {
                if (bl4) {
                    n = 3212;
                    string = "0";
                } else {
                    n = 3212;
                    string = metaDataRecordList.getStringValue(n2) == "0" ? "0" : "1";
                }
            }
            if (n >= 0) {
                if (bl3) {
                    if (!bl2) {
                        if (string5 == null) {
                            this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), null, null, string, string2, n);
                        } else {
                            this.srbFileSystem.srbModifyDataset(this.catalogType, this.getName(), this.getParent(), this.resource, string5, string, string2, n);
                        }
                    }
                } else if (!bl) {
                    this.srbFileSystem.srbModifyCollect(this.catalogType, this.getAbsolutePath(), string, string2, string3, n);
                }
                n = -1;
            }
            ++n2;
        }
    }

    public String toString() {
        return new String("srb://" + this.srbFileSystem.getUserName() + "." + this.srbFileSystem.getDomainName() + "@" + this.srbFileSystem.getHost() + ":" + this.srbFileSystem.getPort() + this.getAbsolutePath());
    }

    public void copyTo(GeneralFile generalFile) throws IOException {
        this.copyTo(generalFile, false);
    }

    public void copyTo(GeneralFile generalFile, boolean bl) throws IOException {
        this.copyTo(generalFile, bl, USE_BULKCOPY);
    }

    public void copyTo(GeneralFile generalFile, boolean bl, boolean bl2) throws IOException {
        System.out.println("copyTo; from: " + this + " to: " + generalFile);
        if (generalFile == null) {
            throw new NullPointerException();
        }
        FileFactory.newFile(generalFile.getFileSystem(), generalFile.getAbsolutePath()).getParentFile().mkdirs();
        if (this.srbFileSystem.getVersionNumber() < 2.0f) {
            super.copyTo(generalFile, bl);
            return;
        }
        if (this.isDirectory()) {
            Object[] objectArray;
            if (generalFile instanceof LocalFile && this.srbFileSystem.getVersionNumber() >= 3.0f && bl2 && (USE_BULKCOPY || bl2)) {
                MetaDataSelect[] metaDataSelectArray;
                if (bl2) {
                    if (bl) {
                        generalFile.delete();
                    }
                    this.bulkUnload((LocalFile)generalFile);
                    return;
                }
                objectArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 10, this.getAbsolutePath() + "*")};
                MetaDataRecordList[] metaDataRecordListArray = this.query((MetaDataCondition[])objectArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("size")});
                if (metaDataRecordListArray != null) {
                    block0: do {
                        int n = 0;
                        while (n < metaDataRecordListArray.length) {
                            if (metaDataRecordListArray[n].getIntValue(0) > 0x200000) {
                                bl2 = false;
                                continue block0;
                            }
                            ++n;
                        }
                    } while ((metaDataRecordListArray = metaDataRecordListArray[0].getMoreResults()) != null && bl2 && !metaDataRecordListArray[0].isQueryComplete());
                }
                if (bl2) {
                    this.bulkUnload((LocalFile)generalFile);
                    return;
                }
            }
            objectArray = this.listFiles();
            generalFile.mkdir();
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    objectArray[n].copyTo(FileFactory.newFile(generalFile.getFileSystem(), generalFile.getAbsolutePath(), objectArray[n].getName()), bl);
                    ++n;
                }
            }
        } else if (this.isFile(false)) {
            if (generalFile.isDirectory()) {
                generalFile = FileFactory.newFile(generalFile, this.getName());
            }
            if (!bl && generalFile.exists()) {
                super.copyTo(generalFile, bl);
                return;
            }
            if (generalFile instanceof LocalFile) {
                int n = (int)this.length() / MIN_THREAD_SIZE;
                if (n > MAX_NUMBER_OF_PARALLEL_THREADS) {
                    n = MAX_NUMBER_OF_PARALLEL_THREADS;
                }
                if (this.srbFileSystem.getVersionNumber() >= 3.0f) {
                    this.srbFileSystem.srbObjGetClientInitiated(this.fileName, this.getParent(), generalFile, 0, n);
                } else {
                    this.srbFileSystem.srbObjGet(this.fileName, this.getParent(), this.length(), generalFile, bl);
                }
            } else if (generalFile instanceof SRBFile) {
                if (bl) {
                    generalFile.delete();
                }
                SRBRandomAccessFile sRBRandomAccessFile = new SRBRandomAccessFile(new SRBFile(this.srbFileSystem, this.getAbsolutePath()), "r");
                SRBRandomAccessFile sRBRandomAccessFile2 = new SRBRandomAccessFile(new SRBFile(this.srbFileSystem, ((SRBFile)generalFile).getAbsolutePath()), "rw");
                this.srbFileSystem.srbObjProxyOpr(0, sRBRandomAccessFile.getFD(), sRBRandomAccessFile2.getFD(), 0, 0, null, null, null, null, null, null, null);
                sRBRandomAccessFile.close();
                sRBRandomAccessFile2.close();
            } else {
                super.copyTo(generalFile, bl);
            }
        } else {
            throw new FileNotFoundException("Source file is not valid: " + this);
        }
    }

    public void copyFrom(GeneralFile generalFile) throws IOException {
        this.copyFrom(generalFile, false);
    }

    public void copyFrom(GeneralFile generalFile, boolean bl) throws IOException {
        this.copyFrom(generalFile, bl, USE_BULKCOPY);
    }

    public void copyFrom(GeneralFile generalFile, boolean bl, boolean bl2) throws IOException {
        System.out.println("copyTo; from: " + this + " to: " + generalFile);
        if (generalFile == null) {
            throw new NullPointerException();
        }
        this.getParentFile().mkdirs();
        if (this.srbFileSystem.getVersionNumber() < 2.0f) {
            super.copyFrom(generalFile, bl);
            return;
        }
        if (generalFile.isDirectory()) {
            if (generalFile instanceof LocalFile && this.srbFileSystem.getVersionNumber() >= 3.0f && bl2 && (USE_BULKCOPY || bl2)) {
                LocalFile[] localFileArray = null;
                localFileArray = this.isDirectory() ? new LocalFile[]{(LocalFile)generalFile} : (LocalFile[])generalFile.listFiles();
                this.bulkLoad(localFileArray, bl);
            } else {
                GeneralFile[] generalFileArray = generalFile.listFiles();
                this.mkdir();
                if (generalFileArray != null) {
                    int n = 0;
                    while (n < generalFileArray.length) {
                        FileFactory.newFile(this, generalFileArray[n].getName()).copyFrom(generalFileArray[n], bl);
                        ++n;
                    }
                }
            }
        } else if (generalFile.isFile()) {
            if (this.isDirectory()) {
                GeneralFile generalFile2 = FileFactory.newFile(this, generalFile.getName());
                generalFile2.copyFrom(generalFile, bl);
                return;
            }
            if (!bl && this.exists()) {
                super.copyFrom(generalFile, bl);
                return;
            }
            if (generalFile instanceof LocalFile) {
                if (bl) {
                    this.delete();
                }
                long l = generalFile.length();
                int n = 1;
                int n2 = 50000000;
                n = l / (long)n2 > 3L ? 4 : (int)l / n2 + 1;
                long l2 = this.srbFileSystem.srbObjPutClientInitiated(this.getName(), this.getParent(), this.resource, "", this.serverLocalPath, generalFile.getAbsolutePath(), l, 0, n);
                if (l2 == -99999999L) {
                    super.copyFrom(generalFile, bl);
                } else if (l2 < 0L) {
                    throw new SRBException("", (int)l2);
                }
            } else if (generalFile instanceof SRBFile) {
                if (bl) {
                    this.delete();
                }
                SRBRandomAccessFile sRBRandomAccessFile = new SRBRandomAccessFile(new SRBFile(this.srbFileSystem, ((SRBFile)generalFile).getAbsolutePath()), "r");
                SRBRandomAccessFile sRBRandomAccessFile2 = new SRBRandomAccessFile(new SRBFile(this.srbFileSystem, this.getAbsolutePath()), "rw");
                this.srbFileSystem.srbObjProxyOpr(0, sRBRandomAccessFile.getFD(), sRBRandomAccessFile2.getFD(), 0, 0, null, null, null, null, null, null, null);
                sRBRandomAccessFile.close();
                sRBRandomAccessFile2.close();
            } else {
                super.copyFrom(generalFile, bl);
            }
        } else {
            throw new FileNotFoundException("Source File is not valid: " + generalFile);
        }
    }

    public void copyFromLocal(String string) throws IOException {
        this.copyFrom(new LocalFile(string));
    }

    public void copyFromLocal(LocalFile localFile) throws IOException {
        this.copyFrom(localFile);
    }

    public void copyToLocal(String string) throws IOException {
        this.copyTo(new LocalFile(string));
    }

    public void copyToLocal(LocalFile localFile) throws IOException {
        this.copyTo(localFile);
    }

    public void copyToRemote(RemoteFile remoteFile) throws IOException {
        this.copyTo(remoteFile);
    }

    public long fileCopyStatus() {
        return this.srbFileSystem.fileCopyStatus();
    }

    public long[] getStat() throws IOException {
        long[] lArray = null;
        if (!this.exists()) {
            return null;
        }
        lArray = this.isDirectory() ? this.srbFileSystem.srbObjStat(0, this.getAbsolutePath(), 3) : this.srbFileSystem.srbObjStat(0, this.getAbsolutePath(), 0);
        if (lArray != null) {
            return lArray;
        }
        throw new IOException("Unable to obtain file stat");
    }

    void bulkLoad(LocalFile[] localFileArray, boolean bl) throws IOException {
        Vector vector;
        Vector vector2;
        block15: {
            long l = -1L;
            long l2 = 0L;
            byte[] byArray = new byte[0x200000];
            GeneralFile[] generalFileArray = new GeneralFile[MAX_NUMBER_OF_BULK_THREADS];
            GeneralRandomAccessFile[] generalRandomAccessFileArray = new GeneralRandomAccessFile[MAX_NUMBER_OF_BULK_THREADS];
            LoadThread loadThread = null;
            vector2 = new Vector();
            vector = new Vector();
            this.mkdir();
            int n = 0;
            while (n < MAX_NUMBER_OF_BULK_THREADS) {
                generalFileArray[n] = FileFactory.newFile(this, "placeholder");
                ++n;
            }
            generalFileArray[0] = SRBFile.createTempFile("BLoad", ".tmp", this);
            generalRandomAccessFileArray[0] = FileFactory.newRandomAccessFile(generalFileArray[0], "rw");
            RegistrationThread[] registrationThreadArray = new RegistrationThread[MAX_NUMBER_OF_BULK_THREADS];
            Thread[] threadArray = new Thread[MAX_NUMBER_OF_BULK_THREADS];
            int n2 = 0;
            while (n2 < MAX_NUMBER_OF_BULK_THREADS) {
                registrationThreadArray[n2] = new RegistrationThread(generalFileArray[n2].getAbsolutePath(), this);
                ++n2;
            }
            threadArray[0] = new Thread(registrationThreadArray[0]);
            loadThread = new LoadThread(generalRandomAccessFileArray, byArray, this);
            int n3 = 0;
            while (n3 < localFileArray.length) {
                this.loadBuffer(localFileArray[n3], loadThread, generalFileArray, threadArray, registrationThreadArray, null, vector2, vector);
                ++n3;
            }
            loadThread.keepLoading = false;
            loadThread.sendBuffer(0);
            try {
                int n4 = 0;
                while (n4 < MAX_NUMBER_OF_BULK_THREADS) {
                    if (generalRandomAccessFileArray[n4] != null) {
                        generalRandomAccessFileArray[n4].close();
                    }
                    if (registrationThreadArray[n4] != null) {
                        if (new SRBFile(this.srbFileSystem, registrationThreadArray[n4].bloadFilePath).exists()) {
                            registrationThreadArray[n4].register();
                        } else {
                            registrationThreadArray[n4].bloadFilePath = generalFileArray[n4].getAbsolutePath();
                            registrationThreadArray[n4].register();
                        }
                    }
                    if (generalFileArray[n4] != null) {
                        ((SRBFile)generalFileArray[n4]).delete(true);
                    }
                    ++n4;
                }
                int n5 = 0;
                while (n5 < MAX_NUMBER_OF_BULK_THREADS) {
                    if (threadArray[n5] != null && threadArray[n5].isAlive()) {
                        threadArray[n5].join();
                    }
                    ++n5;
                }
            }
            catch (InterruptedException interruptedException) {
                if (SRBCommands.DEBUG <= 0) break block15;
                interruptedException.printStackTrace();
            }
        }
        if (vector2.size() > 0) {
            int n = 0;
            while (n < vector2.size()) {
                ((SRBFile)vector.get(n)).copyFrom((GeneralFile)vector2.get(n), bl, false);
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void loadBuffer(GeneralFile var1_1, LoadThread var2_2, GeneralFile[] var3_3, Thread[] var4_4, RegistrationThread[] var5_5, String var6_6, Vector var7_7, Vector var8_8) throws IOException {
        block27: {
            block28: {
                block26: {
                    var9_9 = var1_1.length();
                    var11_10 = var1_1.exists();
                    var12_11 = var1_1.isDirectory();
                    var13_12 = var1_1.getName();
                    if (var1_1 == null || !var11_10) {
                        return;
                    }
                    if (!var12_11) break block26;
                    if (var6_6 == null || var6_6.equals("")) {
                        var6_6 = var13_12;
                        new SRBFile(this.srbFileSystem, this.getAbsolutePath(), var6_6).mkdir();
                    } else {
                        var6_6 = var6_6 + "/" + var13_12;
                        new SRBFile(this.srbFileSystem, this.getAbsolutePath(), var6_6).mkdir();
                    }
                    var14_13 = var1_1.listFiles();
                    if (var14_13 == null) {
                        return;
                    }
                    var15_15 = 0;
                    while (var15_15 < var14_13.length) {
                        this.loadBuffer(var14_13[var15_15], var2_2, var3_3, var4_4, var5_5, var6_6, var7_7, var8_8);
                        ++var15_15;
                    }
                    break block27;
                }
                if (var9_9 <= 0x200000L) break block28;
                var6_6 = var6_6 == null || var6_6.equals("") != false ? var13_12 : var6_6 + "/" + var13_12;
                var7_7.add(var1_1);
                var8_8.add(FileFactory.newFile(this, var6_6));
                break block27;
            }
            var14_14 = 0;
            ++this.filesReadyToRegister;
            if (var6_6 == null) {
                var5_5[this.activeRegistrationThread].addFile(var1_1, "");
            } else {
                var5_5[this.activeRegistrationThread].addFile(var1_1, var6_6);
            }
            var15_16 = var9_9;
            var17_17 = 0;
            var18_18 = null;
            try {
                var18_18 = FileFactory.newFileInputStream(var1_1);
                if (true) ** GOTO lbl71
            }
            catch (SecurityException var19_19) {
                if (SRBCommands.DEBUG > 0) {
                    var19_19.printStackTrace();
                }
                return;
            }
            catch (IOException var20_22) {
                if (SRBCommands.DEBUG > 0) {
                    var20_22.printStackTrace();
                }
                return;
            }
            do {
                if (var15_16 + (long)var2_2.loadBufferLength <= 0x200000L) {
                    var19_20 = this;
                    synchronized (var19_20) {
                        this.loadBufferCount = -1;
                    }
                    var17_17 = var18_18.read(var2_2.loadBuffer, var2_2.loadBufferLength, (int)var15_16);
                    if (var17_17 > 0) {
                        var15_16 -= (long)var17_17;
                        var14_14 += var17_17;
                        var2_2.loadBufferLength += var17_17;
                    }
                }
                if ((long)var2_2.loadBufferLength + var15_16 < 0x200000L) continue;
                var2_2.sendBuffer(0);
lbl71:
                // 3 sources

            } while (var15_16 > 0L);
            var18_18.close();
            if (this.filesReadyToRegister % 300 == 0) {
                var2_2.sendBuffer(0);
                var2_2.out[var2_2.randomIndex].close();
                var4_4[this.activeRegistrationThread].start();
                ++this.activeRegistrationThread;
                if (this.activeRegistrationThread >= SRBFile.MAX_NUMBER_OF_BULK_THREADS) {
                    this.activeRegistrationThread = 0;
                }
                if (var4_4[this.activeRegistrationThread] == null) {
                    var4_4[this.activeRegistrationThread] = new Thread(var5_5[this.activeRegistrationThread]);
                } else {
                    block25: {
                        try {
                            if (var4_4[this.activeRegistrationThread].isAlive()) {
                                var4_4[this.activeRegistrationThread].join();
                            }
                        }
                        catch (InterruptedException var19_21) {
                            if (SRBCommands.DEBUG <= 0) break block25;
                            var19_21.printStackTrace();
                        }
                    }
                    var4_4[this.activeRegistrationThread] = new Thread(var5_5[this.activeRegistrationThread]);
                }
                var3_3[this.activeRegistrationThread] = SRBFile.createTempFile("BLoad", ".tmp", var3_3[this.activeRegistrationThread].getParentFile());
                var5_5[this.activeRegistrationThread].setBloadFilePath(var3_3[this.activeRegistrationThread].getAbsolutePath());
                var2_2.restartRandom = true;
                var2_2.newRandom = var3_3[this.activeRegistrationThread];
                var2_2.randomIndex = this.activeRegistrationThread;
            }
        }
    }

    void bulkUnload(LocalFile localFile) throws IOException {
        int n = 0x8000000;
        if (this.exists()) {
            if (localFile.exists()) {
                localFile = new LocalFile(localFile, this.getName());
            } else {
                localFile.mkdir();
            }
            this.srbFileSystem.srbBulkUnload(this.catalogType, n, this.getAbsolutePath(), localFile.getAbsolutePath());
        }
        boolean bl = false;
        MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 10, this.getAbsolutePath() + "*")};
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("directory name"), MetaDataSet.newSelection("file name")};
        MetaDataRecordList[] metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray);
        metaDataSelectArray[1] = null;
        MetaDataRecordList[] metaDataRecordListArray2 = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray);
        if (metaDataRecordListArray != null && metaDataRecordListArray2 != null) {
            int n2 = 0;
            while (n2 < metaDataRecordListArray2.length) {
                String string = metaDataRecordListArray2[n2].getStringValue(0).substring(this.getAbsolutePath().length());
                int n3 = 0;
                while (n3 < metaDataRecordListArray.length) {
                    String string2 = metaDataRecordListArray[n3].getStringValue(1).substring(this.getAbsolutePath().length());
                    if (string2.equals(string)) {
                        bl = true;
                    }
                    ++n3;
                }
                if (!bl) {
                    new LocalFile(localFile, string).mkdirs();
                }
                bl = false;
                ++n2;
            }
        }
    }

    public String getPermissions() throws IOException {
        block6: {
            MetaDataSelect[] metaDataSelectArray;
            String string;
            String string2;
            MetaDataRecordList[] metaDataRecordListArray;
            block5: {
                MetaDataSelect[] metaDataSelectArray2;
                metaDataRecordListArray = null;
                string2 = this.srbFileSystem.getUserName();
                string = this.srbFileSystem.getDomainName();
                if (!this.isDirectory()) break block5;
                MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("access directory name", 0, this.getAbsolutePath()), MetaDataSet.newCondition("user name", 0, string2), MetaDataSet.newCondition("user domain", 0, string)};
                metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray2 = new MetaDataSelect[]{MetaDataSet.newSelection("access directory name"), MetaDataSet.newSelection("directory access constraint"), MetaDataSet.newSelection("user name"), MetaDataSet.newSelection("user domain")});
                if (metaDataRecordListArray == null) break block6;
                int n = 0;
                while (n < metaDataRecordListArray.length) {
                    if (metaDataRecordListArray[n].getValue("user name").equals(string2) && metaDataRecordListArray[n].getValue("user domain").equals(string)) {
                        return metaDataRecordListArray[n].getValue("directory access constraint").toString();
                    }
                    ++n;
                }
                break block6;
            }
            MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", 0, string2), MetaDataSet.newCondition("user domain", 0, string)};
            metaDataRecordListArray = this.query(metaDataConditionArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("access constraint"), MetaDataSet.newSelection("user name"), MetaDataSet.newSelection("user domain")});
            if (metaDataRecordListArray != null) {
                int n = 0;
                while (n < metaDataRecordListArray.length) {
                    if (metaDataRecordListArray[n].getValue("user name").equals(string2) && metaDataRecordListArray[n].getValue("user domain").equals(string)) {
                        return metaDataRecordListArray[n].getValue("access constraint").toString();
                    }
                    ++n;
                }
            }
        }
        return null;
    }

    public MetaDataRecordList[] getPermissions(boolean bl) throws IOException {
        if (this.isDirectory()) {
            MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("access directory name", 0, this.getAbsolutePath())};
            MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("directory access constraint"), MetaDataSet.newSelection("user name"), MetaDataSet.newSelection("user domain")};
            return this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray);
        }
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("access constraint"), MetaDataSet.newSelection("user name"), MetaDataSet.newSelection("user domain")};
        return this.query(metaDataSelectArray);
    }

    public void changePermissions(String string, String string2, String string3) throws IOException {
        this.changePermissions(string, string2, string3, false);
    }

    public void changePermissions(String string, String string2, String string3, boolean bl) throws IOException {
        int n = -1;
        if (string == null) {
            string = "";
        }
        if ((string = string.toLowerCase()).equals("n") || string.equals("null") || string.equals("")) {
            string = "";
        } else if (string.equals("r") || string.equals("read")) {
            string = "read";
        } else if (string.equals("w") || string.equals("write")) {
            string = "write";
        } else if (string.equals("rw")) {
            string = "all";
        } else if (string.equals("all") || string.equals("ownership")) {
            string = "all";
        } else if (string.equals("t") || string.equals("annotate")) {
            string = "annotate";
        } else if (string.equals("c") || string.equals("curate")) {
            string = "curate";
        } else {
            throw new IllegalArgumentException("Permission type not valid: " + string);
        }
        if (this.isDirectory()) {
            n = string == "" ? (bl ? 130 : 28) : (bl ? 128 : 27);
            this.srbFileSystem.srbModifyCollect(this.catalogType, this.getAbsolutePath(), string2, string3, string, n);
        } else {
            n = string == "" ? 9 : 8;
            this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), "", "", string2 + "@" + string3, string, n);
        }
    }

    public void replicate(String string) throws IOException {
        if (this.isDirectory()) {
            SRBFile[] sRBFileArray = (SRBFile[])this.listFiles();
            int n = 0;
            while (n < sRBFileArray.length) {
                if (sRBFileArray[n].isFile(false)) {
                    this.srbFileSystem.srbObjReplicate(this.catalogType, this.fileName, this.getParent(), string, null);
                } else {
                    sRBFileArray[n].replicate(string, false);
                }
                ++n;
            }
        } else {
            this.srbFileSystem.srbObjReplicate(this.catalogType, this.fileName, this.getParent(), string, null);
        }
    }

    private void replicate(String string, boolean bl) throws IOException {
        if (this.isDirectory(bl)) {
            SRBFile[] sRBFileArray = (SRBFile[])this.listFiles();
            int n = 0;
            while (n < sRBFileArray.length) {
                if (sRBFileArray[n].isFile(false)) {
                    this.srbFileSystem.srbObjReplicate(this.catalogType, this.fileName, this.getParent(), string, null);
                } else {
                    sRBFileArray[n].replicate(string, false);
                }
                ++n;
            }
        } else {
            this.srbFileSystem.srbObjReplicate(this.catalogType, this.fileName, this.getParent(), string, null);
        }
    }

    public void backup(String string) throws IOException {
        if (this.isDirectory()) {
            String[] stringArray = this.list();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].startsWith(PATH_SEPARATOR)) {
                    new SRBFile(this.srbFileSystem, stringArray[n]).backup(string);
                } else {
                    new SRBFile(this.srbFileSystem, this.getAbsolutePath() + PATH_SEPARATOR + stringArray[n]).backup(string);
                }
                ++n;
            }
        } else {
            this.srbFileSystem.srbBackupData(this.catalogType, this.fileName, this.getParent(), string, 0);
        }
    }

    public String checksum() throws IOException {
        if (this.isFile()) {
            byte[] byArray = this.srbFileSystem.srbObjChksum(this.getName(), this.getParent(), 16, null);
            if (byArray == null) {
                return this.checksum(true, true);
            }
            return new String(byArray);
        }
        return null;
    }

    public String checksum(boolean bl) throws IOException {
        return this.checksum(false, true);
    }

    private String checksum(boolean bl, boolean bl2) throws IOException {
        if (this.isFile(bl2)) {
            if (bl) {
                return new String(this.srbFileSystem.srbObjChksum(this.getName(), this.getParent(), 32, null));
            }
            return new String(this.srbFileSystem.srbObjChksum(this.getName(), this.getParent(), 128, null));
        }
        return null;
    }

    public void register(String string, long l) throws IOException {
        if (l < 0L) {
            l = 0L;
        }
        this.srbFileSystem.srbRegisterDataset(this.catalogType, this.getName(), this.dataType, this.resource, this.getParent(), string, l);
    }

    public InputStream executeProxyCommand(String string, String string2) throws IOException {
        return this.srbFileSystem.executeProxyCommand(string, string2, null, this.getPath(), -1);
    }

    public void link(SRBFile sRBFile) throws IOException {
        if (this.isDirectory()) {
            GeneralFile[] generalFileArray = this.listFiles();
            sRBFile.mkdir();
            int n = 0;
            while (n < generalFileArray.length) {
                SRBFile sRBFile2 = new SRBFile(sRBFile, generalFileArray[n].getName());
                ((SRBFile)generalFileArray[n]).link(sRBFile2);
                ++n;
            }
        } else {
            this.srbFileSystem.srbModifyDataset(0, this.fileName, this.getParent(), "", "", sRBFile.getName(), sRBFile.getParent(), 83);
        }
    }

    public boolean canRead() {
        block8: {
            MetaDataRecordList[] metaDataRecordListArray = null;
            String string = null;
            String string2 = this.srbFileSystem.getUserName();
            int n = 0;
            try {
                MetaDataSelect[] metaDataSelectArray;
                if (this.isDirectory()) {
                    MetaDataSelect[] metaDataSelectArray2;
                    MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", n, string2), MetaDataSet.newCondition("access directory name", n, this.getAbsolutePath())};
                    metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray2 = new MetaDataSelect[]{MetaDataSet.newSelection("directory access constraint")}, 3);
                    if (metaDataRecordListArray == null) {
                        return false;
                    }
                    int n2 = 0;
                    while (n2 < metaDataRecordListArray.length) {
                        if (metaDataRecordListArray[n2].getValue("directory access constraint") != null && ((string = metaDataRecordListArray[n2].getValue("directory access constraint").toString()).equals("all") || string.equals("read"))) {
                            return true;
                        }
                        ++n2;
                    }
                    break block8;
                }
                if (!this.isFile(false)) break block8;
                MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", n, string2), MetaDataSet.newCondition("directory name", n, this.getParent()), MetaDataSet.newCondition("file name", n, this.getName())};
                metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("access constraint")}, 3);
                if (metaDataRecordListArray == null) {
                    return false;
                }
                string = metaDataRecordListArray[0].getValue("access constraint").toString();
                if (string.equals("all") || string.equals("read")) {
                    return true;
                }
            }
            catch (IOException iOException) {
                if (SRBCommands.DEBUG <= 0) break block8;
                iOException.printStackTrace();
            }
        }
        return false;
    }

    boolean canRead(String string) {
        block9: {
            MetaDataRecordList[] metaDataRecordListArray = null;
            String string2 = null;
            String string3 = this.srbFileSystem.getUserName();
            int n = 0;
            try {
                if (string.equals("isDir")) {
                    MetaDataSelect[] metaDataSelectArray;
                    MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", n, string3), MetaDataSet.newCondition("access directory name", n, this.getAbsolutePath())};
                    metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("directory access constraint")}, 3);
                    if (metaDataRecordListArray == null) {
                        return false;
                    }
                    int n2 = 0;
                    while (n2 < metaDataRecordListArray.length) {
                        if (metaDataRecordListArray[n2].getValue("directory access constraint") != null && ((string2 = metaDataRecordListArray[n2].getValue("directory access constraint").toString()).equals("all") || string2.equals("read"))) {
                            return true;
                        }
                        ++n2;
                    }
                    break block9;
                }
                if (string.equals("isFile")) {
                    MetaDataSelect[] metaDataSelectArray;
                    MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", n, string3), MetaDataSet.newCondition("directory name", n, this.getParent()), MetaDataSet.newCondition("file name", n, this.getName())};
                    metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("access constraint")}, 3);
                    if (metaDataRecordListArray == null) {
                        return false;
                    }
                    string2 = metaDataRecordListArray[0].getValue("access constraint").toString();
                    if (string2.equals("all") || string2.equals("read")) {
                        return true;
                    }
                    break block9;
                }
                return this.canRead();
            }
            catch (IOException iOException) {
                if (SRBCommands.DEBUG <= 0) break block9;
                iOException.printStackTrace();
            }
        }
        return false;
    }

    public boolean canWrite() {
        block8: {
            MetaDataRecordList[] metaDataRecordListArray = null;
            String string = null;
            String string2 = this.srbFileSystem.getUserName();
            int n = 0;
            try {
                MetaDataSelect[] metaDataSelectArray;
                if (this.isDirectory()) {
                    MetaDataSelect[] metaDataSelectArray2;
                    MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", n, string2), MetaDataSet.newCondition("access directory name", n, this.getAbsolutePath())};
                    metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray2 = new MetaDataSelect[]{MetaDataSet.newSelection("directory access constraint")}, 3);
                    if (metaDataRecordListArray == null) {
                        return false;
                    }
                    int n2 = 0;
                    while (n2 < metaDataRecordListArray.length) {
                        if (metaDataRecordListArray[n2].getValue("directory access constraint") != null && ((string = metaDataRecordListArray[n2].getValue("directory access constraint").toString()).equals("all") || string.equals("write"))) {
                            return true;
                        }
                        ++n2;
                    }
                    break block8;
                }
                if (!this.isFile(false)) break block8;
                MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", n, string2), MetaDataSet.newCondition("directory name", n, this.getParent()), MetaDataSet.newCondition("file name", n, this.getName())};
                metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("access constraint")}, 3);
                if (metaDataRecordListArray == null) {
                    return false;
                }
                string = metaDataRecordListArray[0].getValue("access constraint").toString();
                if (string.equals("all") || string.equals("write")) {
                    return true;
                }
            }
            catch (IOException iOException) {
                if (SRBCommands.DEBUG <= 0) break block8;
                iOException.printStackTrace();
            }
        }
        return false;
    }

    boolean canWrite(String string) {
        block9: {
            MetaDataRecordList[] metaDataRecordListArray = null;
            String string2 = null;
            String string3 = this.srbFileSystem.getUserName();
            int n = 0;
            try {
                if (string.equals("isDir")) {
                    MetaDataSelect[] metaDataSelectArray;
                    MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", n, string3), MetaDataSet.newCondition("access directory name", n, this.getAbsolutePath())};
                    metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("directory access constraint")}, 3);
                    if (metaDataRecordListArray == null) {
                        return false;
                    }
                    int n2 = 0;
                    while (n2 < metaDataRecordListArray.length) {
                        if (metaDataRecordListArray[n2].getValue("directory access constraint") != null && ((string2 = metaDataRecordListArray[n2].getValue("directory access constraint").toString()).equals("all") || string2.equals("write"))) {
                            return true;
                        }
                        ++n2;
                    }
                    break block9;
                }
                if (string.equals("isFile")) {
                    MetaDataSelect[] metaDataSelectArray;
                    MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", n, string3), MetaDataSet.newCondition("directory name", n, this.getParent()), MetaDataSet.newCondition("file name", n, this.getName())};
                    metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("access constraint")}, 3);
                    if (metaDataRecordListArray == null) {
                        return false;
                    }
                    string2 = metaDataRecordListArray[0].getValue("access constraint").toString();
                    if (string2.equals("all") || string2.equals("write")) {
                        return true;
                    }
                    break block9;
                }
                return this.canWrite();
            }
            catch (IOException iOException) {
                if (SRBCommands.DEBUG <= 0) break block9;
                iOException.printStackTrace();
            }
        }
        return false;
    }

    public int compareTo(GeneralFile generalFile) {
        return generalFile.getAbsolutePath().compareTo(this.getAbsolutePath());
    }

    public int compareTo(Object object) throws ClassCastException {
        return this.compareTo((SRBFile)object);
    }

    public boolean createNewFile() throws IOException {
        block4: {
            try {
                if (!this.isFile()) {
                    this.getParentFile().mkdirs();
                    int n = this.srbFileSystem.srbObjCreate(this.catalogType, this.getName(), this.dataType, this.resource, this.getParent(), this.serverLocalPath, -1L);
                    this.srbFileSystem.srbObjClose(n);
                    return true;
                }
            }
            catch (SRBException sRBException) {
                if (SRBCommands.DEBUG > 0) {
                    sRBException.printStackTrace();
                }
                if (sRBException.getType() == -3210) break block4;
                throw sRBException;
            }
        }
        return false;
    }

    public static GeneralFile createTempFile(String string, String string2) throws IOException, IllegalArgumentException {
        return SRBFile.createTempFile(string, string2, null);
    }

    public static GeneralFile createTempFile(String string, String string2, GeneralFile generalFile) throws IOException, IllegalArgumentException {
        Object object;
        String string3 = "";
        int n = 0;
        while (n < 8) {
            string3 = string3 + (char)(65.0 + Math.random() * 25.0);
            ++n;
        }
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() < 3) {
            throw new IllegalArgumentException("Prefix string too short");
        }
        if (string2 == null) {
            string2 = ".tmp";
        }
        if (generalFile == null) {
            object = new SRBFileSystem();
            generalFile = new SRBFile((SRBFileSystem)object, ((GeneralFileSystem)object).getHomeDirectory(), "temp");
            generalFile.mkdir();
        }
        if (((SRBFile)(object = new SRBFile((SRBFile)generalFile, string + string3 + string2))).createNewFile()) {
            return object;
        }
        throw new IOException("The temp file already exists.");
    }

    public boolean delete() {
        return this.delete(false);
    }

    public boolean delete(boolean bl) {
        try {
            if (!bl && this.srbFileSystem.getVersionNumber() > 3.0f) {
                if (this.isDirectory()) {
                    this.srbFileSystem.srbModifyCollect(this.catalogType, this.getAbsolutePath(), "", "", "", 31);
                    return true;
                }
                if (this.isFile(false) && this.getReplicaNumber() < 0) {
                    this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), "", "", "", "", 174);
                    return true;
                }
                this.srbFileSystem.srbObjUnlink(this.fileName, this.getParent());
                return true;
            }
            if (this.isDirectory()) {
                this.srbFileSystem.srbModifyCollect(this.catalogType, this.getAbsolutePath(), "", "", "", 31);
                return true;
            }
            if (this.isFile(false)) {
                this.srbFileSystem.srbObjUnlink(this.fileName, this.getParent());
                return true;
            }
        }
        catch (IOException iOException) {
            if (SRBCommands.DEBUG > 0) {
                iOException.printStackTrace();
            }
            return false;
        }
        return false;
    }

    public void deleteOnExit() {
        this.deleteOnExit = true;
    }

    public boolean equals(Object object) {
        try {
            if (object == null) {
                return false;
            }
            SRBFile sRBFile = (SRBFile)object;
            return this.getAbsolutePath().equals(sRBFile.getAbsolutePath());
        }
        catch (ClassCastException classCastException) {
            if (SRBCommands.DEBUG > 0) {
                classCastException.printStackTrace();
            }
            return false;
        }
    }

    public boolean exists() {
        block6: {
            try {
                MetaDataRecordList[] metaDataRecordListArray = null;
                int n = 0;
                MetaDataCondition[] metaDataConditionArray = null;
                if (this.getReplicaNumber() >= 0) {
                    metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", n, this.getParent()), MetaDataSet.newCondition("file name", n, this.getName())};
                    metaDataConditionArray[1] = MetaDataSet.newCondition("file replication enum", n, this.replicaNumber);
                } else {
                    metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", n, this.getParent()), MetaDataSet.newCondition("file name", n, this.getName())};
                }
                MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file name")};
                metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray, 3);
                if (metaDataRecordListArray != null) {
                    return true;
                }
                metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", n, this.getAbsolutePath())};
                metaDataSelectArray[0] = MetaDataSet.newSelection("directory name");
                metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray, 3);
                if (metaDataRecordListArray != null) {
                    return true;
                }
            }
            catch (IOException iOException) {
                if (SRBCommands.DEBUG <= 0) break block6;
                iOException.printStackTrace();
            }
        }
        return false;
    }

    public GeneralFile getAbsoluteFile() {
        return new SRBFile(this.srbFileSystem, this.getAbsolutePath());
    }

    public String getAbsolutePath() {
        if (this.directory != null && !this.directory.isEmpty()) {
            int n = this.directory.size();
            String string = (String)this.directory.firstElement();
            int n2 = 1;
            while (n2 < n) {
                string = string + this.getPathSeparator() + this.directory.get(n2);
                ++n2;
            }
            return string + this.getPathSeparator() + this.getName();
        }
        return this.getName();
    }

    public GeneralFile getCanonicalFile() throws IOException {
        return new SRBFile(this.srbFileSystem, this.getCanonicalPath());
    }

    public String getCanonicalPath() throws IOException {
        if (this.directory != null && !this.directory.isEmpty()) {
            int n = this.directory.size();
            String string = (String)this.directory.firstElement();
            int n2 = 1;
            while (n2 < n) {
                string = string + this.getPathSeparator() + this.directory.get(n2);
                ++n2;
            }
            return string + this.getPathSeparator() + this.fileName;
        }
        return this.fileName;
    }

    public String getName() {
        int n = this.fileName.indexOf("&COPY=");
        if (n >= 0) {
            return this.fileName.substring(0, n);
        }
        return this.fileName;
    }

    public String getParent() {
        if (this.directory != null && !this.directory.isEmpty()) {
            int n = this.directory.size();
            String string = (String)this.directory.firstElement();
            int n2 = 1;
            while (n2 < n) {
                string = string + this.getPathSeparator() + this.directory.get(n2);
                ++n2;
            }
            return string;
        }
        return null;
    }

    public GeneralFile getParentFile() {
        return new SRBFile(this.srbFileSystem, this.getParent());
    }

    public String getPath() {
        return this.originalFilePath;
    }

    public int hashCode() {
        return this.getAbsolutePath().toLowerCase().hashCode() ^ 0x12D591;
    }

    public boolean isAbsolute() {
        return true;
    }

    public boolean isContainer() {
        return false;
    }

    public boolean isDirectory() {
        if (this.useCache) {
            return this.isDirectory(false);
        }
        return this.isDirectory(true);
    }

    public boolean isDirectory(boolean bl) {
        block6: {
            if (!bl && this.pathNameType != 0) {
                if (this.pathNameType == 1) {
                    return false;
                }
                if (this.pathNameType == 2) {
                    return true;
                }
            }
            MetaDataRecordList[] metaDataRecordListArray = null;
            MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 0, this.getAbsolutePath())};
            MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("directory name")};
            try {
                metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray, 3);
                if (metaDataRecordListArray != null) {
                    this.pathNameType = 2;
                    return true;
                }
            }
            catch (IOException iOException) {
                if (SRBCommands.DEBUG <= 0) break block6;
                iOException.printStackTrace();
            }
        }
        return false;
    }

    public boolean isFile() {
        if (this.useCache) {
            return this.isFile(false);
        }
        return this.isFile(true);
    }

    public boolean isFile(boolean bl) {
        block6: {
            if (this.pathNameType != 0 && !bl) {
                if (this.pathNameType == 1) {
                    return true;
                }
                if (this.pathNameType == 2) {
                    return false;
                }
            }
            MetaDataRecordList[] metaDataRecordListArray = null;
            MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 0, this.getParent()), MetaDataSet.newCondition("file name", 0, this.getName())};
            MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file name")};
            try {
                metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray, 3);
                if (metaDataRecordListArray != null) {
                    this.pathNameType = 1;
                    return true;
                }
            }
            catch (IOException iOException) {
                if (SRBCommands.DEBUG <= 0) break block6;
                iOException.printStackTrace();
            }
        }
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public long lastModified() {
        long l = 0L;
        MetaDataRecordList[] metaDataRecordListArray = null;
        try {
            metaDataRecordListArray = this.query("modification date");
            if (metaDataRecordListArray != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss");
                l = simpleDateFormat.parse(metaDataRecordListArray[0].getStringValue(0)).getTime();
            }
        }
        catch (IOException iOException) {
            if (SRBCommands.DEBUG > 0) {
                iOException.printStackTrace();
            }
            return 0L;
        }
        catch (ParseException parseException) {
            if (SRBCommands.DEBUG > 0) {
                parseException.printStackTrace();
            }
            return 0L;
        }
        return l;
    }

    public long length() {
        long l = 0L;
        MetaDataRecordList[] metaDataRecordListArray = null;
        try {
            metaDataRecordListArray = this.query("size");
        }
        catch (IOException iOException) {
            if (SRBCommands.DEBUG > 0) {
                iOException.printStackTrace();
            }
            return 0L;
        }
        if (metaDataRecordListArray != null) {
            l = Long.parseLong(metaDataRecordListArray[0].getStringValue(0));
        }
        return l;
    }

    public String[] list() {
        MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[1];
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file name")};
        MetaDataRecordList[] metaDataRecordListArray = null;
        MetaDataRecordList[] metaDataRecordListArray2 = null;
        MetaDataRecordList[] metaDataRecordListArray3 = null;
        Vector<String> vector = null;
        String string = null;
        try {
            string = this.isDirectory() ? this.getAbsolutePath() : this.getParent();
            metaDataConditionArray[0] = MetaDataSet.newCondition("directory name", 0, string);
            metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray, SRBFileSystem.DEFAULT_RECORDS_WANTED);
            if (this.completeDirectoryList) {
                metaDataRecordListArray = MetaDataRecordList.getAllResults(metaDataRecordListArray);
            }
            metaDataSelectArray[0] = MetaDataSet.newSelection("directory name");
            metaDataConditionArray[0] = MetaDataSet.newCondition("parent directory name", 0, string);
            metaDataRecordListArray2 = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray, SRBFileSystem.DEFAULT_RECORDS_WANTED);
            if (this.completeDirectoryList) {
                metaDataRecordListArray2 = MetaDataRecordList.getAllResults(metaDataRecordListArray2);
            }
            if (metaDataRecordListArray2 != null) {
                String string2 = null;
                String string3 = null;
                int n = 0;
                while (n < metaDataRecordListArray2.length) {
                    string2 = metaDataRecordListArray2[n].getStringValue(0);
                    string3 = string2.substring(string2.lastIndexOf(PATH_SEPARATOR) + 1);
                    metaDataRecordListArray2[n].setValue(0, string3);
                    ++n;
                }
            }
        }
        catch (IOException iOException) {
            if (SRBCommands.DEBUG > 0) {
                iOException.printStackTrace();
            }
            return null;
        }
        if (metaDataRecordListArray != null && metaDataRecordListArray2 != null) {
            metaDataRecordListArray3 = new SRBMetaDataRecordList[metaDataRecordListArray.length + metaDataRecordListArray2.length];
            System.arraycopy(metaDataRecordListArray, 0, metaDataRecordListArray3, 0, metaDataRecordListArray.length);
            System.arraycopy(metaDataRecordListArray2, 0, metaDataRecordListArray3, metaDataRecordListArray.length, metaDataRecordListArray2.length);
        } else if (metaDataRecordListArray != null) {
            metaDataRecordListArray3 = metaDataRecordListArray;
        } else if (metaDataRecordListArray2 != null) {
            metaDataRecordListArray3 = metaDataRecordListArray2;
        } else {
            return new String[0];
        }
        vector = new Vector<String>();
        int n = 0;
        while (n < metaDataRecordListArray3.length) {
            if (metaDataRecordListArray3[n].getStringValue(0) != null) {
                vector.add(metaDataRecordListArray3[n].getStringValue(0));
            }
            ++n;
        }
        return vector.toArray(new String[0]);
    }

    public String[] list(MetaDataCondition[] metaDataConditionArray) {
        if (metaDataConditionArray == null) {
            return this.list();
        }
        MetaDataCondition[] metaDataConditionArray2 = null;
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file name")};
        MetaDataRecordList[] metaDataRecordListArray = null;
        MetaDataRecordList[] metaDataRecordListArray2 = null;
        MetaDataRecordList[] metaDataRecordListArray3 = null;
        Vector<String> vector = null;
        String string = null;
        try {
            string = this.isDirectory() ? this.getAbsolutePath() : this.getParent();
            metaDataConditionArray2 = MetaDataSet.mergeConditions(MetaDataSet.newCondition("directory name", 0, string), metaDataConditionArray);
            metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray2, metaDataSelectArray, SRBFileSystem.DEFAULT_RECORDS_WANTED);
            if (this.completeDirectoryList) {
                metaDataRecordListArray = MetaDataRecordList.getAllResults(metaDataRecordListArray);
            }
            metaDataSelectArray[0] = MetaDataSet.newSelection("directory name");
            metaDataConditionArray2 = MetaDataSet.mergeConditions(MetaDataSet.newCondition("parent directory name", 0, string), (MetaDataCondition)null);
            metaDataRecordListArray2 = this.srbFileSystem.query(metaDataConditionArray2, metaDataSelectArray, SRBFileSystem.DEFAULT_RECORDS_WANTED);
            if (this.completeDirectoryList) {
                metaDataRecordListArray2 = MetaDataRecordList.getAllResults(metaDataRecordListArray2);
            }
            if (metaDataRecordListArray2 != null) {
                String string2 = null;
                String string3 = null;
                int n = 0;
                while (n < metaDataRecordListArray2.length) {
                    string2 = metaDataRecordListArray2[n].getStringValue(0);
                    string3 = string2.substring(string2.lastIndexOf(PATH_SEPARATOR) + 1);
                    metaDataRecordListArray2[n].setValue(0, string3);
                    ++n;
                }
            }
        }
        catch (IOException iOException) {
            if (SRBCommands.DEBUG > 0) {
                iOException.printStackTrace();
            }
            return null;
        }
        if (metaDataRecordListArray != null && metaDataRecordListArray2 != null) {
            metaDataRecordListArray3 = new SRBMetaDataRecordList[metaDataRecordListArray.length + metaDataRecordListArray2.length];
            System.arraycopy(metaDataRecordListArray, 0, metaDataRecordListArray3, 0, metaDataRecordListArray.length);
            System.arraycopy(metaDataRecordListArray2, 0, metaDataRecordListArray3, metaDataRecordListArray.length, metaDataRecordListArray2.length);
        } else if (metaDataRecordListArray != null) {
            metaDataRecordListArray3 = metaDataRecordListArray;
        } else if (metaDataRecordListArray2 != null) {
            metaDataRecordListArray3 = metaDataRecordListArray2;
        } else {
            return new String[0];
        }
        vector = new Vector<String>();
        int n = 0;
        while (n < metaDataRecordListArray3.length) {
            if (metaDataRecordListArray3[n].getStringValue(0) != null) {
                vector.add(metaDataRecordListArray3[n].getStringValue(0));
            }
            ++n;
        }
        return vector.toArray(new String[0]);
    }

    public static GeneralFile[] listRoots() {
        GeneralFile[] generalFileArray;
        block2: {
            generalFileArray = new GeneralFile[1];
            try {
                generalFileArray[0] = new SRBFile(new SRBFileSystem(), PATH_SEPARATOR);
            }
            catch (IOException iOException) {
                if (SRBCommands.DEBUG <= 0) break block2;
                iOException.printStackTrace();
            }
        }
        return generalFileArray;
    }

    public boolean mkdir() {
        block3: {
            try {
                if (!this.isDirectory()) {
                    this.srbFileSystem.srbCreateCollect(this.catalogType, this.getParent(), this.getName());
                    return true;
                }
            }
            catch (IOException iOException) {
                if (SRBCommands.DEBUG <= 0) break block3;
                iOException.printStackTrace();
            }
        }
        return false;
    }

    public boolean mkdirs() {
        if (!this.isDirectory()) {
            int n = this.directory.size();
            SRBFile sRBFile = new SRBFile(this.srbFileSystem, this.directory.get(0).toString());
            int n2 = 0;
            while (n2 < n) {
                if (!sRBFile.exists()) {
                    sRBFile.mkdir();
                    sRBFile = new SRBFile(sRBFile, this.directory.get(n2).toString());
                }
                ++n2;
            }
            this.mkdir();
            return true;
        }
        return false;
    }

    public boolean renameTo(GeneralFile generalFile) throws IllegalArgumentException {
        block20: {
            if (generalFile instanceof SRBFile) {
                try {
                    if (this.isFile()) {
                        if (this.getParent().equals(generalFile.getParent())) {
                            this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), "", this.serverLocalPath, generalFile.getName(), "", 29);
                        } else if (this.getName().equals(generalFile.getName())) {
                            this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), "", this.serverLocalPath, generalFile.getParent(), "", 6);
                        } else {
                            String string = generalFile.getName() + (long)Math.random();
                            this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), "", this.serverLocalPath, string, "", 29);
                            try {
                                this.srbFileSystem.srbModifyDataset(this.catalogType, string, this.getParent(), "", this.serverLocalPath, generalFile.getParent(), "", 6);
                            }
                            catch (IOException iOException) {
                                if (SRBCommands.DEBUG > 0) {
                                    iOException.printStackTrace();
                                }
                                this.srbFileSystem.srbModifyDataset(this.catalogType, string, this.getParent(), "", this.serverLocalPath, this.fileName, "", 29);
                            }
                            try {
                                this.srbFileSystem.srbModifyDataset(this.catalogType, string, generalFile.getParent(), "", this.serverLocalPath, generalFile.getName(), "", 29);
                            }
                            catch (IOException iOException) {
                                if (SRBCommands.DEBUG > 0) {
                                    iOException.printStackTrace();
                                }
                                this.srbFileSystem.srbModifyDataset(this.catalogType, string, generalFile.getParent(), "", this.serverLocalPath, this.getParent(), "", 6);
                                this.srbFileSystem.srbModifyDataset(this.catalogType, string, this.getParent(), "", this.serverLocalPath, this.fileName, "", 29);
                            }
                        }
                        this.directory = new Vector();
                        this.setFileName(generalFile.getAbsolutePath());
                        return true;
                    }
                    if (this.isDirectory(false)) {
                        this.srbFileSystem.srbModifyCollect(this.catalogType, this.getAbsolutePath(), generalFile.getAbsolutePath(), null, null, 30);
                        this.directory = new Vector();
                        this.setFileName(generalFile.getAbsolutePath());
                        return true;
                    }
                    if (!this.exists()) {
                        this.directory = new Vector();
                        this.setFileName(generalFile.getAbsolutePath());
                        return true;
                    }
                    break block20;
                }
                catch (IOException iOException) {
                    if (SRBCommands.DEBUG > 0) {
                        iOException.printStackTrace();
                    }
                    break block20;
                }
            }
            try {
                this.copyTo(generalFile, false);
                this.delete();
                this.directory = new Vector();
                this.setFileName(generalFile.getAbsolutePath());
                return true;
            }
            catch (IOException iOException) {
                if (SRBCommands.DEBUG > 0) {
                    iOException.printStackTrace();
                }
                return false;
            }
        }
        return false;
    }

    public boolean setLastModified(long l) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public boolean setReadOnly() {
        throw new UnsupportedOperationException();
    }

    public URI toURI() {
        URI uRI;
        block3: {
            uRI = null;
            try {
                if (this.isDirectory()) {
                    uRI = new URI("srb", this.srbFileSystem.getUserName() + "." + this.srbFileSystem.getDomainName(), this.srbFileSystem.getHost(), this.srbFileSystem.getPort(), this.getAbsolutePath() + PATH_SEPARATOR, "", "");
                    break block3;
                }
                uRI = new URI("srb", this.srbFileSystem.getUserName() + "." + this.srbFileSystem.getDomainName(), this.srbFileSystem.getHost(), this.srbFileSystem.getPort(), this.getAbsolutePath(), "", "");
            }
            catch (URISyntaxException uRISyntaxException) {
                if (SRBCommands.DEBUG <= 0) break block3;
                uRISyntaxException.printStackTrace();
            }
        }
        return uRI;
    }

    public URL toURL() throws MalformedURLException {
        URL uRL = null;
        uRL = this.isDirectory() ? new URL("srb://" + this.srbFileSystem.getUserName() + "." + this.srbFileSystem.getDomainName() + "@" + this.srbFileSystem.getHost() + ":" + this.srbFileSystem.getPort() + this.getAbsolutePath() + PATH_SEPARATOR) : new URL("srb://" + this.srbFileSystem.getUserName() + "." + this.srbFileSystem.getDomainName() + "@" + this.srbFileSystem.getHost() + ":" + this.srbFileSystem.getPort() + this.getAbsolutePath());
        return uRL;
    }

    class RegistrationThread
    implements Runnable {
        String bloadFilePath;
        Object mainThread;
        Vector files = new Vector();
        Vector paths = new Vector();

        RegistrationThread(String string, Object object) throws IOException {
            this.bloadFilePath = string;
            this.mainThread = object;
        }

        void setBloadFilePath(String string) {
            this.bloadFilePath = string;
        }

        void addFile(GeneralFile generalFile, String string) {
            this.files.add(generalFile);
            this.paths.add(string);
        }

        public void run() {
            block2: {
                try {
                    this.register();
                }
                catch (IOException iOException) {
                    if (SRBCommands.DEBUG <= 0) break block2;
                    iOException.printStackTrace();
                }
            }
        }

        SRBMetaDataRecordList[] getFileRegistry(int n) throws IOException {
            SRBMetaDataRecordList sRBMetaDataRecordList = null;
            SRBMetaDataRecordList[] sRBMetaDataRecordListArray = new SRBMetaDataRecordList[n];
            GeneralFile generalFile = null;
            Object var5_5 = null;
            Object var6_6 = null;
            Object var7_7 = null;
            String string = null;
            long l = 0L;
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                generalFile = (GeneralFile)this.files.get(n3);
                n2 = (int)((long)n2 + l);
                l = generalFile.length();
                string = (String)this.paths.get(n3);
                string = string == null || string.equals("") ? SRBFile.this.getAbsolutePath() : SRBFile.this.getAbsolutePath() + SRBFile.PATH_SEPARATOR + string;
                sRBMetaDataRecordList = new SRBMetaDataRecordList(SRBMetaDataSet.getField("file name"), generalFile.getName());
                sRBMetaDataRecordList.addRecord(SRBMetaDataSet.getField("directory name"), string);
                sRBMetaDataRecordList.addRecord(SRBMetaDataSet.getField("size"), l);
                sRBMetaDataRecordList.addRecord(SRBMetaDataSet.getField("offset"), n2);
                sRBMetaDataRecordListArray[n3] = sRBMetaDataRecordList;
                ++n3;
            }
            int n4 = 0;
            while (n4 < n) {
                try {
                    this.files.remove(0);
                    this.paths.remove(0);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (SRBCommands.DEBUG <= 0) break;
                    arrayIndexOutOfBoundsException.printStackTrace();
                    break;
                }
                ++n4;
            }
            return sRBMetaDataRecordListArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void register() throws IOException {
            Object object;
            int n = this.files.size();
            if (n > 0) {
                object = this.mainThread;
                synchronized (object) {
                    this.mainThread.notify();
                }
                SRBFile.this.srbFileSystem.srbBulkLoad(SRBFile.this.catalogType, this.bloadFilePath, this.getFileRegistry(n));
            }
            object = this.mainThread;
            synchronized (object) {
                this.mainThread.notify();
            }
        }
    }

    class LoadThread
    implements Runnable {
        GeneralRandomAccessFile[] out;
        byte[] loadBuffer;
        byte[] buffer2;
        boolean writeLoadBuffer = false;
        int loadBufferLength = 0;
        boolean keepLoading = true;
        boolean restartRandom = false;
        GeneralFile newRandom;
        int randomIndex;
        Object mainThread;

        LoadThread(GeneralRandomAccessFile[] generalRandomAccessFileArray, byte[] byArray, Object object) {
            this.out = generalRandomAccessFileArray;
            this.loadBuffer = byArray;
            this.mainThread = object;
        }

        public void run() {
            int n = Integer.MIN_VALUE;
        }

        void restartRandomAccessFile() throws IOException {
            this.out[this.randomIndex] = FileFactory.newRandomAccessFile(this.newRandom, "rw");
            this.restartRandom = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int sendBuffer(int n) throws IOException {
            if (this.loadBufferLength <= 0) {
                return n;
            }
            LoadThread loadThread = this;
            synchronized (loadThread) {
                if (this.restartRandom) {
                    this.restartRandomAccessFile();
                }
            }
            this.out[SRBFile.this.activeRegistrationThread].write(this.loadBuffer, 0, this.loadBufferLength);
            this.loadBufferLength = 0;
            SRBFile.this.loadBufferCount = 0;
            return n;
        }
    }
}

