/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.message.MessageElement;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.ServiceDataAttributes;
import org.globus.ogsa.ServiceDataSet;
import org.globus.ogsa.ServiceDataValueCallback;
import org.globus.ogsa.router.ReferenceRewriter;
import org.gridforum.ogsi.MutabilityType;
import org.gridforum.ogsi.ServiceDataType;
import org.w3c.dom.Element;

public class ServiceData {
    private ServiceDataSet serviceDataSet;
    private ArrayList values = new ArrayList();
    private ServiceDataValueCallback callback;
    private boolean notifiable = true;
    private Map properties;
    private QName name;
    private boolean modifiable = false;
    private MutabilityType mutability = EXTENDABLE;
    public static final MutabilityType STATIC = MutabilityType.value1;
    public static final MutabilityType CONSTANT = MutabilityType.value2;
    public static final MutabilityType EXTENDABLE = MutabilityType.value3;
    public static final MutabilityType MUTABLE = MutabilityType.value4;
    public static final QName HANDLE = new QName("http://www.gridforum.org/namespaces/2003/03/OGSI", "gridServiceHandle");
    public static final QName REFERENCE = new QName("http://www.gridforum.org/namespaces/2003/03/OGSI", "gridServiceReference");
    public static final QName INTERFACE = new QName("http://www.gridforum.org/namespaces/2003/03/OGSI", "interface");
    public static final QName FACTORY_LOCATOR = new QName("http://www.gridforum.org/namespaces/2003/03/OGSI", "factoryLocator");
    public static final QName TERMINATION = new QName("http://www.gridforum.org/namespaces/2003/03/OGSI", "terminationTime");
    public static final QName NAME = new QName("http://www.gridforum.org/namespaces/2003/03/OGSI", "serviceDataName");
    public static final QName FIND_EXTENSIBILITY = new QName("http://www.gridforum.org/namespaces/2003/03/OGSI", "findServiceDataExtensibility");
    public static final QName SET_EXTENSIBILITY = new QName("http://www.gridforum.org/namespaces/2003/03/OGSI", "setServiceDataExtensibility");
    public static final QName CREATE_EXTENSIBILITY = new QName("http://www.gridforum.org/namespaces/2003/03/OGSI", "createServiceExtensibility");
    public static final QName HANDLE_RESOLVER_SCHEME = new QName("http://www.gridforum.org/namespaces/2003/03/OGSI", "handleResolverScheme");
    public static final QName NOTIFIABLE_NAME = new QName("http://www.gridforum.org/namespaces/2003/03/OGSI", "notifiableServiceDataName");
    public static final QName SUBSCRIBE_EXTENSIBILITY = new QName("http://www.gridforum.org/namespaces/2003/03/OGSI", "subscribeExtensibility");
    public static final QName SUBSCRIPTION_EXPRESSION = new QName("http://www.gridforum.org/namespaces/2003/03/OGSI", "subscriptionExpression");
    public static final QName SINK_LOCATOR = new QName("http://www.gridforum.org/namespaces/2003/03/OGSI", "sinkLocator");
    public static final QName MEMBERSHIP_CONTENT_RULE = new QName("http://www.gridforum.org/namespaces/2003/03/OGSI", "membershipContentRule");
    public static final QName ENTRY = new QName("http://www.gridforum.org/namespaces/2003/03/OGSI", "entry");
    public static final QName MEMBER_LOCATOR = new QName("http://www.gridforum.org/namespaces/2003/03/OGSI", "memberServiceLocator");
    public static final QName CONTENT = new QName("http://www.gridforum.org/namespaces/2003/03/OGSI", "content");

    public ServiceData(ServiceDataSet serviceDataSet) {
        this.serviceDataSet = serviceDataSet;
    }

    public void init(ServiceDataType descriptor) {
        this.setModifiable(descriptor.isModifiable());
        this.setMutability(descriptor.getMutability());
    }

    public ServiceData(QName name) {
        this.name = name;
    }

    public ServiceData(QName name, ServiceDataSet serviceDataSet) {
        this.serviceDataSet = serviceDataSet;
        this.name = name;
    }

    public void setMutability(MutabilityType mutability) {
        this.mutability = mutability;
    }

    public MutabilityType getMutability() {
        return this.mutability;
    }

    public void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    public boolean getModifiable() {
        return this.modifiable;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName qname) {
        this.name = qname;
    }

    public Collection getValues() {
        if (this.callback == null) {
            return this.values;
        }
        return this.callback.getServiceDataValues(this.name);
    }

    public Object getValue() {
        if (this.values.size() > 0) {
            return this.values.get(0);
        }
        return null;
    }

    public void setValue(Object value) {
        if (value instanceof MessageElement) {
            this.setName(((MessageElement)value).getQName());
        }
        if (this.values.size() == 0) {
            this.values.add(value);
        } else {
            this.values.set(0, value);
        }
    }

    public void addValue(Object value) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        if (value instanceof MessageElement) {
            this.setName(((MessageElement)value).getQName());
        }
        this.values.add(value);
    }

    public Object getValue(int index) {
        return this.values.get(index);
    }

    public Object removeValue(int index) {
        return this.values.remove(index);
    }

    public boolean removeValue(Object obj) {
        return this.values.remove(obj);
    }

    public void resetValues() {
        this.values = null;
    }

    public void setValues(Collection collection) {
        this.values = collection instanceof ArrayList ? (ArrayList)collection : new ArrayList(collection);
    }

    public void setValues(Object[] values) {
        int i = 0;
        while (i < values.length) {
            this.values.add(values[i]);
            ++i;
        }
    }

    public void setNotifiable(boolean notifiable) {
        this.notifiable = notifiable;
    }

    public boolean isNotifiable() {
        return this.notifiable;
    }

    public void notifyChange() {
        this.serviceDataSet.notifyListeners(this);
    }

    public void notifyChangeWithAck() {
        this.serviceDataSet.notifyListenersWithAck(this);
    }

    public void setCallback(ServiceDataValueCallback callback) {
        this.callback = callback;
    }

    public synchronized MessageElement[] externalizeMessage() throws GridServiceException {
        try {
            Collection currentValues = this.getValues();
            if (currentValues != null && currentValues.size() > 0) {
                MessageElement[] messageElements = new MessageElement[currentValues.size()];
                int i = 0;
                Iterator iterator = currentValues.iterator();
                while (iterator.hasNext()) {
                    Object externalObj = ReferenceRewriter.externalize(iterator.next());
                    messageElements[i] = this.getMessageElement(externalObj);
                    ++i;
                }
                return messageElements;
            }
            return new MessageElement[0];
        }
        catch (Exception e) {
            throw new GridServiceException(e);
        }
    }

    private MessageElement getMessageElement(Object obj) throws Exception {
        Element element;
        if (obj instanceof MessageElement) {
            return (MessageElement)obj;
        }
        if (obj instanceof ServiceDataAttributes) {
            return this.getMessageElement((ServiceDataAttributes)obj);
        }
        if (obj instanceof Element && this.name.equals(new QName((element = (Element)obj).getNamespaceURI(), element.getLocalName()))) {
            return new MessageElement((Element)obj);
        }
        MessageElement messageElement = new MessageElement();
        messageElement.setQName(this.getName());
        messageElement.setObjectValue(obj);
        return messageElement;
    }

    private MessageElement getMessageElement(ServiceDataAttributes attributes) throws Exception {
        Element element;
        Object obj = attributes.getValue();
        MessageElement messageElement = null;
        if (obj instanceof Element && this.name.equals(new QName((element = (Element)obj).getNamespaceURI(), element.getLocalName()))) {
            messageElement = new MessageElement(element);
            attributes.populate(element);
            return messageElement;
        }
        messageElement = new MessageElement();
        messageElement.setQName(this.getName());
        attributes.populate(messageElement);
        messageElement.setObjectValue(obj);
        return messageElement;
    }

    public synchronized Element[] externalizeElement() throws GridServiceException {
        try {
            Collection currentValues = this.getValues();
            if (currentValues != null && currentValues.size() > 0) {
                Element[] elements = new Element[currentValues.size()];
                int i = 0;
                Iterator iterator = currentValues.iterator();
                while (iterator.hasNext()) {
                    Object externalObj = ReferenceRewriter.externalize(iterator.next());
                    MessageElement messageElement = this.getMessageElement(externalObj);
                    elements[i] = messageElement.getAsDOM();
                    ++i;
                }
                return elements;
            }
            return new Element[0];
        }
        catch (Exception e) {
            throw new GridServiceException(e);
        }
    }

    public synchronized String[] externalizeString() throws GridServiceException {
        try {
            Collection currentValues = this.getValues();
            if (currentValues != null && currentValues.size() > 0) {
                String[] strings = new String[currentValues.size()];
                int i = 0;
                Iterator iterator = currentValues.iterator();
                while (iterator.hasNext()) {
                    Object externalObj = ReferenceRewriter.externalize(iterator.next());
                    MessageElement messageElement = this.getMessageElement(externalObj);
                    strings[i] = messageElement.toString();
                    ++i;
                }
                return strings;
            }
            return new String[0];
        }
        catch (Exception e) {
            throw new GridServiceException(e);
        }
    }

    public synchronized void setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        return this.properties != null ? this.properties.get(name) : null;
    }

    public Map getProperties() {
        return this.properties;
    }
}

