/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa;

import org.apache.axis.message.MessageElement;
import org.gridforum.ogsi.ExtendedDateTimeType;
import org.gridforum.ogsi.HandleType;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class ServiceDataAttributes {
    private Object value;
    private ExtendedDateTimeType goodUntil;
    private ExtendedDateTimeType goodFrom;
    private ExtendedDateTimeType availableUntil;
    private HandleType originator;
    private static final String GOOD_UNTIL = "goodUntil";
    private static final String GOOD_FROM = "goodFrom";
    private static final String AVAILABLE_UNTIL = "availableUntil";
    private static final String ORIGINATOR = "originator";
    private static final String OGSI_PREFIX = "ogsi";
    private static final String GLOBUS_PREFIX = "gt";
    private static final String GOOD_UNTIL_PREFIX = "ogsi:goodUntil";
    private static final String GOOD_FROM_PREFIX = "ogsi:goodFrom";
    private static final String AVAILABLE_UNTIL_PREFIX = "ogsi:availableUntil";
    private static final String ORIGINATOR_PREFIX = "gt:originator";

    public ServiceDataAttributes(Object value) {
        this.value = value;
    }

    public ServiceDataAttributes(MessageElement messageElement) {
        Attributes attributes = messageElement.getAttributes();
        String temp = attributes.getValue(GOOD_UNTIL);
        if (temp == null) {
            temp = attributes.getValue("http://www.gridforum.org/namespaces/2003/03/OGSI", GOOD_UNTIL);
        }
        if (temp != null) {
            this.goodUntil = new ExtendedDateTimeType(temp);
        }
        if ((temp = attributes.getValue(GOOD_FROM)) == null) {
            temp = attributes.getValue("http://www.gridforum.org/namespaces/2003/03/OGSI", GOOD_FROM);
        }
        if (temp != null) {
            this.goodFrom = new ExtendedDateTimeType(temp);
        }
        if ((temp = attributes.getValue(AVAILABLE_UNTIL)) == null) {
            temp = attributes.getValue("http://www.gridforum.org/namespaces/2003/03/OGSI", AVAILABLE_UNTIL);
        }
        if (temp != null) {
            this.availableUntil = new ExtendedDateTimeType(temp);
        }
        if ((temp = attributes.getValue(ORIGINATOR)) == null) {
            temp = attributes.getValue("http://ogsa.globus.org/", ORIGINATOR);
        }
        if (temp != null) {
            this.originator = new HandleType(temp);
        }
        this.value = messageElement.getObjectValue();
    }

    public void setGoodUntil(ExtendedDateTimeType goodUntil) {
        this.goodUntil = goodUntil;
    }

    public void setGoodFrom(ExtendedDateTimeType goodFrom) {
        this.goodFrom = goodFrom;
    }

    public void setAvailableUntil(ExtendedDateTimeType availableUntil) {
        this.availableUntil = availableUntil;
    }

    public ExtendedDateTimeType getGoodUntil() {
        return this.goodUntil;
    }

    public ExtendedDateTimeType getGoodFrom() {
        return this.goodFrom;
    }

    public ExtendedDateTimeType getAvailableUntil() {
        return this.availableUntil;
    }

    public void setOriginator(HandleType originator) {
        this.originator = originator;
    }

    public HandleType getOriginator() {
        return this.originator;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void populate(MessageElement element) {
        block9: {
            boolean globusAdded = false;
            boolean ogsiAdded = false;
            if (this.goodUntil != null) {
                element.addAttribute(OGSI_PREFIX, "http://www.gridforum.org/namespaces/2003/03/OGSI", GOOD_UNTIL_PREFIX, this.goodUntil.toString());
                ogsiAdded = true;
            }
            if (this.goodFrom != null) {
                element.addAttribute(OGSI_PREFIX, "http://www.gridforum.org/namespaces/2003/03/OGSI", GOOD_FROM_PREFIX, this.goodFrom.toString());
                ogsiAdded = true;
            }
            if (this.availableUntil != null) {
                element.addAttribute(OGSI_PREFIX, "http://www.gridforum.org/namespaces/2003/03/OGSI", AVAILABLE_UNTIL_PREFIX, this.availableUntil.toString());
                ogsiAdded = true;
            }
            if (this.originator != null) {
                element.addAttribute(GLOBUS_PREFIX, "http://ogsa.globus.org/", ORIGINATOR_PREFIX, this.originator.toString());
                globusAdded = true;
            }
            if (ogsiAdded) {
                try {
                    element.addNamespaceDeclaration(OGSI_PREFIX, "http://www.gridforum.org/namespaces/2003/03/OGSI");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!globusAdded) break block9;
            try {
                element.addNamespaceDeclaration(GLOBUS_PREFIX, "http://ogsa.globus.org/");
            }
            catch (Exception e) {}
        }
    }

    public void populate(Element element) {
        if (this.goodUntil != null) {
            element.setAttributeNS("http://www.gridforum.org/namespaces/2003/03/OGSI", GOOD_UNTIL_PREFIX, this.goodUntil.toString());
        }
        if (this.goodFrom != null) {
            element.setAttributeNS("http://www.gridforum.org/namespaces/2003/03/OGSI", GOOD_FROM_PREFIX, this.goodFrom.toString());
        }
        if (this.availableUntil != null) {
            element.setAttributeNS("http://www.gridforum.org/namespaces/2003/03/OGSI", AVAILABLE_UNTIL_PREFIX, this.availableUntil.toString());
        }
        if (this.originator != null) {
            element.setAttributeNS("http://ogsa.globus.org/", ORIGINATOR_PREFIX, this.originator.toString());
        }
    }
}

