/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.client;

import javax.xml.rpc.Stub;
import org.globus.ogsa.utils.GetOpts;
import org.globus.ogsa.utils.GridServiceFactory;
import org.globus.ogsa.utils.MessageUtils;
import org.globus.ogsa.wsdl.GSR;
import org.gridforum.ogsi.Factory;
import org.gridforum.ogsi.HandleType;
import org.gridforum.ogsi.LocatorType;
import org.gridforum.ogsi.OGSIServiceGridLocator;
import org.gridforum.ogsi.WSDLReferenceType;

public class CreateService {
    public static void main(String[] args) {
        block6: {
            GetOpts opts = new GetOpts("Usage: CreateService [options] <factory handle> [id]", 1);
            String error = opts.parse(args);
            if (error != null) {
                System.err.println(error);
                return;
            }
            String handle = opts.getArg(0);
            try {
                OGSIServiceGridLocator factoryService = new OGSIServiceGridLocator();
                Factory factory = factoryService.getFactoryPort(new HandleType(handle));
                opts.setOptions((Stub)factory);
                String id = opts.getOptionalArg(1);
                if (id != null && id.startsWith("http://")) {
                    ((Stub)factory)._setProperty("org.globus.ogsa.RouterVia", (Object)id);
                }
                GridServiceFactory gridFactory = new GridServiceFactory(factory);
                LocatorType locator = gridFactory.createService(null, id);
                System.out.println("Service successfully created:");
                GSR reference = GSR.newInstance(locator);
                String location = reference.getHandle().toString();
                System.out.println("  Handle: " + location);
                System.out.println("  Termination Time: " + gridFactory.getTerminationTime().getAfter().toString());
                if (opts.isDebug()) {
                    WSDLReferenceType ref = (WSDLReferenceType)locator.getReference()[0];
                    System.out.println();
                    System.out.println("Reference:");
                    System.out.println(ref.get_any()[0].toString());
                }
            }
            catch (Exception e) {
                if (opts.isDebug()) {
                    System.err.println(MessageUtils.toString(e));
                    break block6;
                }
                System.err.println("Error: " + opts.getErrorMessage(e));
            }
        }
    }
}

