/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.client;

import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;
import org.globus.ogsa.utils.AnyHelper;
import org.globus.ogsa.utils.GetOpts;
import org.globus.ogsa.utils.MessageUtils;
import org.globus.ogsa.utils.QNameUtils;
import org.globus.ogsa.utils.QueryHelper;
import org.gridforum.ogsi.ExtensibilityType;
import org.gridforum.ogsi.GridService;
import org.gridforum.ogsi.HandleType;
import org.gridforum.ogsi.OGSIServiceGridLocator;

public class FindServiceDataByName {
    public static void main(String[] args) {
        block5: {
            GetOpts opts = new GetOpts("Usage: FindServiceDataByName [options] <service data name namespace>:<service data name>,... <handle>", 2);
            String error = opts.parse(args);
            if (error != null) {
                System.err.println(error);
                return;
            }
            String names = opts.getArg(0);
            String handle = opts.getArg(1);
            QName[] qnames = QNameUtils.toQNames(names);
            try {
                OGSIServiceGridLocator locator = new OGSIServiceGridLocator();
                GridService service = locator.getGridServicePort(new HandleType(handle));
                opts.setOptions((Stub)service);
                ExtensibilityType queryResult = service.findServiceData(QueryHelper.getNamesQuery(qnames));
                if (queryResult.get_any() == null) {
                    System.err.println("No Values Found");
                    return;
                }
                System.out.println("ServiceDataValues: " + AnyHelper.getAsString(queryResult));
            }
            catch (Exception e) {
                if (opts.isDebug()) {
                    System.err.println(MessageUtils.toString(e));
                    break block5;
                }
                System.err.println("Error: " + opts.getErrorMessage(e));
            }
        }
    }
}

