/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.client.reflection;

import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.apache.axis.client.Call;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.client.reflection.ReflectionException;
import org.globus.ogsa.client.reflection.ReflectionUtils;
import org.globus.ogsa.wsdl.GSR;

public class DynamicInvoker {
    protected static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$client$reflection$DynamicInvoker == null ? (class$org$globus$ogsa$client$reflection$DynamicInvoker = DynamicInvoker.class$("org.globus.ogsa.client.reflection.DynamicInvoker")) : class$org$globus$ogsa$client$reflection$DynamicInvoker).getName());
    private static int MESSAGE_STYLE_UNSUPPORTED = -1;
    private static int MESSAGE_STYLE_DOC_LITERAL = 0;
    private static int MESSAGE_STYLE_RPC_ENCODED = 1;
    GSR gsr = null;
    QName portTypeQName = null;
    OperationDesc operationDesc = null;
    Object[] parameters = null;
    static /* synthetic */ Class class$org$globus$ogsa$client$reflection$DynamicInvoker;
    static /* synthetic */ Class class$org$apache$axis$encoding$ser$BeanSerializerFactory;
    static /* synthetic */ Class class$org$apache$axis$encoding$ser$BeanDeserializerFactory;

    public DynamicInvoker(String gsh) throws Exception {
        this.gsr = new GSR(gsh + "?WSDL");
    }

    public GSR getGSR() {
        return this.gsr;
    }

    public void setMethodName(String methodName) throws GridServiceException, ReflectionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Selecting operation " + methodName));
        }
        this.operationDesc = null;
        this.portTypeQName = null;
        Collection portTypes = this.gsr.getPortTypes();
        Iterator portTypeIterator = portTypes.iterator();
        while (portTypeIterator.hasNext() && this.operationDesc == null) {
            this.portTypeQName = (QName)portTypeIterator.next();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\n\nSearching Port Type for Operation: " + this.portTypeQName));
            }
            Collection operations = ReflectionUtils.getOperationDescriptions(this.gsr.getWSDLDefinition(), this.gsr.getDocument(), this.portTypeQName);
            Iterator operationIterator = operations.iterator();
            while (operationIterator.hasNext() && this.operationDesc == null) {
                OperationDesc operationDesc = (OperationDesc)operationIterator.next();
                if (!operationDesc.getName().equals(methodName)) continue;
                this.operationDesc = operationDesc;
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("\nOperation: " + operationDesc.getName()));
            }
        }
    }

    protected Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] parameters) {
        this.parameters = parameters;
    }

    protected int getMessageStyle() throws GridServiceException {
        Definition wsdlDefinition = this.gsr.getWSDLDefinition();
        if (wsdlDefinition.getBindings().values().size() == 0) {
            Map map = wsdlDefinition.getImports();
            if (map == null) {
                return MESSAGE_STYLE_UNSUPPORTED;
            }
            Iterator imports = map.values().iterator();
            if (imports.hasNext()) {
                Vector importVector = (Vector)imports.next();
                if (importVector.size() == 0) {
                    return MESSAGE_STYLE_UNSUPPORTED;
                }
                Import importedDefinition = (Import)importVector.get(0);
                wsdlDefinition = importedDefinition.getDefinition();
            } else {
                return MESSAGE_STYLE_UNSUPPORTED;
            }
        }
        Binding binding = (Binding)wsdlDefinition.getBindings().values().toArray()[0];
        String bindingStyle = null;
        List extensibilityElements = binding.getExtensibilityElements();
        Iterator extensibilityElementIter = extensibilityElements.iterator();
        while (extensibilityElementIter.hasNext()) {
            ExtensibilityElement extensibilityElement = (ExtensibilityElement)extensibilityElementIter.next();
            if (!(extensibilityElement instanceof SOAPBinding)) continue;
            bindingStyle = ((SOAPBinding)extensibilityElement).getStyle();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Binding Style: " + bindingStyle));
        }
        String operationStyle = null;
        String inputName = null;
        String outputName = null;
        BindingOperation bindingOperation = binding.getBindingOperation(this.operationDesc.getName(), inputName, outputName);
        BindingInput operationInput = bindingOperation.getBindingInput();
        extensibilityElements = operationInput.getExtensibilityElements();
        extensibilityElementIter = extensibilityElements.iterator();
        while (extensibilityElementIter.hasNext()) {
            ExtensibilityElement extensibilityElement = (ExtensibilityElement)extensibilityElementIter.next();
            if (!(extensibilityElement instanceof SOAPBody)) continue;
            operationStyle = ((SOAPBody)extensibilityElement).getUse();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Operation Style: " + operationStyle));
        }
        if (bindingStyle.equals("document") && operationStyle.equals("literal")) {
            return MESSAGE_STYLE_DOC_LITERAL;
        }
        if (bindingStyle.equals("rpc") && operationStyle.equals("encoded")) {
            return MESSAGE_STYLE_RPC_ENCODED;
        }
        return MESSAGE_STYLE_UNSUPPORTED;
    }

    private void addParameters(Call call) {
        int parameterCount = this.operationDesc.getNumParams();
        int index = 0;
        while (index < parameterCount) {
            ParameterDesc parameterDesc = this.operationDesc.getParameter(index);
            QName parameterTypeQName = parameterDesc.getTypeQName();
            Class parameterType = parameterDesc.getJavaType();
            ParameterMode parameterMode = ReflectionUtils.getParameterMode(parameterDesc);
            call.addParameter(parameterDesc.getName(), parameterTypeQName, parameterType, parameterMode);
            ++index;
        }
    }

    public Object call() throws RemoteException, MalformedURLException, ReflectionException {
        Object returnObject = null;
        QName operationQName = null;
        if (this.operationDesc != null) {
            Call call = new Call(this.gsr.getEndpoint());
            int messageStyle = this.getMessageStyle();
            if (messageStyle == MESSAGE_STYLE_DOC_LITERAL) {
                call.setOperationStyle("wrapped");
                operationQName = new QName(this.portTypeQName.getNamespaceURI(), this.operationDesc.getName());
                call.setEncodingStyle(null);
            } else if (messageStyle == MESSAGE_STYLE_RPC_ENCODED) {
                call.setOperationStyle("rpc");
                operationQName = new QName(this.operationDesc.getName());
                call.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
            } else {
                logger.error((Object)"unsupported message style.  must be rpc-encoded or doc/literal");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\nSet operation style " + call.getOperationStyle()));
                logger.debug((Object)("\nSet encoding style " + call.getEncodingStyle()));
            }
            call.setProperty("sendMultiRefs", (Object)Boolean.FALSE);
            call.setProperty("send_type_attr", (Object)Boolean.FALSE);
            call.setReturnType(this.operationDesc.getReturnType());
            Class returnClass = ReflectionUtils.getClassForQName(this.operationDesc.getReturnType());
            if (!returnClass.isPrimitive() && !returnClass.isArray()) {
                call.registerTypeMapping(returnClass, this.operationDesc.getReturnType(), class$org$apache$axis$encoding$ser$BeanSerializerFactory == null ? (class$org$apache$axis$encoding$ser$BeanSerializerFactory = DynamicInvoker.class$("org.apache.axis.encoding.ser.BeanSerializerFactory")) : class$org$apache$axis$encoding$ser$BeanSerializerFactory, class$org$apache$axis$encoding$ser$BeanDeserializerFactory == null ? (class$org$apache$axis$encoding$ser$BeanDeserializerFactory = DynamicInvoker.class$("org.apache.axis.encoding.ser.BeanDeserializerFactory")) : class$org$apache$axis$encoding$ser$BeanDeserializerFactory);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("invoking operation " + operationQName));
                logger.debug((Object)("Call Return Type: " + call.getReturnType()));
            }
            if (this.parameters != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("parameter array length: " + this.parameters.length));
                }
                this.addParameters(call);
            } else {
                logger.warn((Object)"null parameter array before invocation");
            }
            returnObject = call.invoke(operationQName, this.parameters);
        }
        return returnObject;
    }

    public Object call(String methodName, Object[] parameters) throws RemoteException, MalformedURLException, ReflectionException {
        this.setMethodName(methodName);
        this.setParameters(parameters);
        return this.call();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

