/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.handlers;

import org.apache.axis.MessageContext;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.ServiceLifecycleMonitorImpl;
import org.globus.ogsa.utils.PerformanceLog;

public class PerformanceLifecycleHandler
extends ServiceLifecycleMonitorImpl {
    PerformanceLog serializationLogger;
    PerformanceLog logger;

    public PerformanceLifecycleHandler() {
        MessageContext context = MessageContext.getCurrentContext();
        String service = context.getTargetService();
        String logName = service.replace('/', '.');
        this.logger = new PerformanceLog("org.globus.ogsa.performance." + logName);
        this.serializationLogger = new PerformanceLog("org.globus.ogsa.performance.serialization." + logName);
    }

    public void preSerializationCall(GridContext context) throws GridServiceException {
        this.serializationLogger.start();
    }

    public void preCall(GridContext context) throws GridServiceException {
        this.logger.start();
    }

    public void postSerializationCall(GridContext context) throws GridServiceException {
        this.serializationLogger.stop(((MessageContext)context.getMessageContext()).getOperation().getName());
    }

    public void postCall(GridContext context) throws GridServiceException {
        this.logger.stop(((MessageContext)context.getMessageContext()).getOperation().getName());
    }
}

