/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.rpc.handler.MessageContext;
import org.apache.axis.AxisFault;
import org.apache.axis.handlers.BasicHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.axis.util.Util;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.QueryEngine;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.handlers.container.ContainerHandlerHelper;
import org.globus.ogsa.impl.core.handle.HandleHelper;
import org.globus.ogsa.impl.core.service.ServicePropertiesImpl;
import org.globus.ogsa.repository.ServiceActivationException;
import org.globus.ogsa.repository.ServiceNode;
import org.globus.ogsa.server.ServiceHost;
import org.globus.ogsa.utils.MessageUtils;
import org.globus.ogsa.utils.QueryHelper;

public class PersistentServiceHandler
extends BasicHandler {
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$handlers$PersistentServiceHandler == null ? (class$org$globus$ogsa$handlers$PersistentServiceHandler = PersistentServiceHandler.class$("org.globus.ogsa.handlers.PersistentServiceHandler")) : class$org$globus$ogsa$handlers$PersistentServiceHandler).getName());
    private static boolean isInitialized = false;
    private static Object initializationMutex = new Object();
    static /* synthetic */ Class class$org$globus$ogsa$handlers$PersistentServiceHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(org.apache.axis.MessageContext messageContext) throws AxisFault {
        try {
            ArrayList<String> activateOnStartup = null;
            ServiceNode root = null;
            Object object = initializationMutex;
            synchronized (object) {
                if (isInitialized) {
                    return;
                }
                isInitialized = true;
                logger.debug((Object)"Entry PersistentServiceHandler::invoke");
                root = ServiceNode.getRootNode();
                activateOnStartup = new ArrayList<String>();
                String configPath = (String)messageContext.getProperty("configPath");
                GridContext context = new GridContext((MessageContext)messageContext);
                String port = ServiceHost.getDefaultPort(context);
                String protocol = ServiceHost.getDefaultProtocol(context);
                if (configPath != null) {
                    configPath = configPath + File.separator;
                }
                ContainerConfig.initConfigPath(configPath);
                ContainerConfig config = ContainerConfig.getConfig();
                String containerProperty = System.getProperty("org.globus.ogsa.container");
                boolean clientContainer = containerProperty != null && containerProperty.equalsIgnoreCase("client");
                this.registerGlobalQueries();
                if (!clientContainer) {
                    this.initContainerHandlers();
                }
                Hashtable persistentServicesOptions = config.getPersistentServicesOptions();
                List persistentServicesList = config.getPersistentServicesList();
                Iterator iterator = persistentServicesList.iterator();
                while (iterator.hasNext()) {
                    String handleProtocol;
                    String bootstrap;
                    String service = (String)iterator.next();
                    Hashtable serviceOptions = (Hashtable)persistentServicesOptions.get(service);
                    if (clientContainer && ((bootstrap = (String)serviceOptions.get("bootstrap")) == null || !bootstrap.equalsIgnoreCase("true"))) continue;
                    String activate = (String)serviceOptions.get("activateOnStartup");
                    if (activate != null && activate.equalsIgnoreCase("TRUE")) {
                        activateOnStartup.add(service);
                    }
                    ServicePropertiesImpl deactivatedService = new ServicePropertiesImpl();
                    String handlePort = (String)serviceOptions.get("handlePort");
                    if (handlePort != null) {
                        deactivatedService.setProperty("handlePort", handlePort);
                    }
                    if ((handleProtocol = (String)serviceOptions.get("handleProtocol")) != null) {
                        deactivatedService.setProperty("handleProtocol", handleProtocol);
                    }
                    deactivatedService.setProperty("port", port);
                    deactivatedService.setProperty("protocol", protocol);
                    String handle = HandleHelper.getHandle("/" + ContainerConfig.getOgsiLocation() + service, deactivatedService);
                    deactivatedService.setProperty("Handle", handle);
                    deactivatedService.setProperty("name", service);
                    deactivatedService.setProperty("servicePath", service);
                    String type = (String)serviceOptions.get("type");
                    if (type == null || type.equalsIgnoreCase("persistent")) {
                        deactivatedService.setProperty("deactivatedPersistent", Boolean.TRUE);
                    } else {
                        deactivatedService.setProperty("deactivatedTransient", Boolean.TRUE);
                    }
                    root.bind(service, (Object)deactivatedService);
                }
            }
            if (activateOnStartup != null) {
                Iterator activateIterator = activateOnStartup.iterator();
                while (activateIterator.hasNext()) {
                    try {
                        String service = (String)activateIterator.next();
                        root.activate(service);
                    }
                    catch (ServiceActivationException sae) {
                        logger.error((Object)MessageUtils.toString(sae));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.toString(e));
            throw new AxisFault(MessageUtils.getMessage("persistentLoadError", new String[]{e.toString()}));
        }
        logger.debug((Object)"Exit PeristentServiceHandler::invoke");
    }

    public void generateWSDL(org.apache.axis.MessageContext messageContext) throws AxisFault {
        this.invoke(messageContext);
    }

    private void registerGlobalQueries() throws AxisFault {
        try {
            ContainerConfig config = ContainerConfig.getConfig();
            QueryEngine queryEngine = QueryHelper.getQueryEngine(config.getOption("queryEngine"));
            QueryHelper.registerEvaluators(queryEngine, config.getOption("queryEvaluators"));
            queryEngine.setGlobalEngine(queryEngine);
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.toString(e));
            throw new AxisFault(MessageUtils.getMessage("persistentLoadError", new String[]{e.toString()}));
        }
    }

    private void initContainerHandlers() throws AxisFault {
        try {
            ContainerConfig config = ContainerConfig.getConfig();
            ContainerHandlerHelper.runHandlers(config.getOption("containerHandlers"));
        }
        catch (Exception e) {
            throw new AxisFault(MessageUtils.getMessage("containerHandlersError", new String[]{e.toString()}));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Util.registerTransport();
    }
}

