/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.handlers;

import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.utils.XMLUtils;
import org.globus.ogsa.router.ReferenceRewriter;
import org.globus.ogsa.utils.ContextUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class RoutingHandler
extends BasicHandler {
    protected SOAPHeaderElement getRouterHeader(MessageContext messageContext) throws AxisFault {
        Message message = messageContext.getCurrentMessage();
        SOAPEnvelope envelope = message.getSOAPEnvelope();
        SOAPHeaderElement header = envelope.getHeaderByName("http://ogsa.globus.org/", "router");
        if (header == null) {
            return null;
        }
        messageContext.setProperty("org.globus.ogsa.RouterHeader", (Object)header);
        return header;
    }

    protected SOAPHeaderElement setRouterHeader(MessageContext messageContext) throws AxisFault {
        String routerVia = (String)ContextUtils.getProperty(messageContext, "org.globus.ogsa.RouterVia");
        if (routerVia == null) {
            return null;
        }
        Message message = messageContext.getCurrentMessage();
        SOAPEnvelope envelope = message.getSOAPEnvelope();
        Document doc = null;
        try {
            doc = XMLUtils.newDocument();
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Exception)e);
        }
        Element element = doc.createElementNS("http://ogsa.globus.org/", "router");
        element.setAttribute("via", routerVia);
        SOAPHeaderElement header = new SOAPHeaderElement(element);
        header.setMustUnderstand(false);
        envelope.addHeader(header);
        return header;
    }

    protected SOAPHeaderElement setResponseRouterHeader(MessageContext messageContext) throws AxisFault {
        SOAPHeaderElement header = (SOAPHeaderElement)messageContext.getProperty("org.globus.ogsa.RouterHeader");
        if (header == null) {
            return null;
        }
        Message message = messageContext.getCurrentMessage();
        if (message == null) {
            return null;
        }
        if (messageContext.isPropertyTrue("org.globus.ogsa.ContainsReference")) {
            SOAPEnvelope envelope = message.getSOAPEnvelope();
            envelope.addHeader(header);
            try {
                ReferenceRewriter.rewrite(header, envelope);
            }
            catch (Exception e) {
                throw AxisFault.makeFault((Exception)e);
            }
        }
        return header;
    }
}

