/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.core.logging;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.ServiceData;
import org.globus.ogsa.core.logging.GroupLogAttribute;
import org.globus.ogsa.core.logging.InvalidDestinationFaultElement;
import org.globus.ogsa.core.logging.InvalidLevelFaultElement;
import org.globus.ogsa.core.logging.LogAttributeElement;
import org.globus.ogsa.core.logging.LogMessageElement;
import org.globus.ogsa.core.logging.UnableToPersistFaultElement;
import org.globus.ogsa.core.logging.UnknownGroupNameFaultElement;
import org.globus.ogsa.core.logging.UnknownNameFaultElement;
import org.globus.ogsa.impl.core.logging.OGSALog4jLog;
import org.globus.ogsa.impl.core.logging.OGSALogFactory;
import org.globus.ogsa.impl.core.logging.test.OgsiLoggingTasks;
import org.globus.ogsa.impl.ogsi.PersistentGridServiceImpl;
import org.globus.ogsa.utils.MessageUtils;
import org.globus.ogsa.utils.QNameUtils;

public class OgsiLogging
extends PersistentGridServiceImpl {
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$impl$core$logging$OgsiLogging == null ? (class$org$globus$ogsa$impl$core$logging$OgsiLogging = OgsiLogging.class$("org.globus.ogsa.impl.core.logging.OgsiLogging")) : class$org$globus$ogsa$impl$core$logging$OgsiLogging).getName());
    OGSALogFactory logfactory = null;
    static boolean pair_with_our_logfactory = false;
    static boolean i_am_active = false;
    public static final String LOGGING_SERVICE_PORT_TYPE_NS = "http://ogsa.globus.org/core/logging";
    public static final QName TRANSIENT_ATTRIBUTES = new QName("http://ogsa.globus.org/core/logging", "TransientAttributes");
    private ServiceData TransientAttributesSD = null;
    public static final QName PERSISTENT_ATTRIBUTES = new QName("http://ogsa.globus.org/core/logging", "PersistentAttributes");
    private ServiceData PersistentAttributesSD = null;
    public static final QName LOG_BUFFER_SIZE = new QName("http://ogsa.globus.org/core/logging", "LogBufferSize");
    private ServiceData LogBufferSizeSD = null;
    public static final QName LOG_MESSAGES = new QName("http://ogsa.globus.org/core/logging", "LogMessages");
    private ServiceData LogMessagesSD = null;
    private int logBufferSize = 10;
    private int nextSlot = 0;
    private LogMessageElement[] snapshot = new LogMessageElement[10];
    private LogAttributeElement[] snaploggers = new LogAttributeElement[10];
    private LinkedList buffer_window = new LinkedList();
    private long lastNotify = System.currentTimeMillis();
    private int maxBufferSize = 100;
    private int logBufferSizeMax = 100;
    private String logDestinationBasePath = "";
    private static String base_path_key = "logDestinationBasePath";
    static /* synthetic */ Class class$org$globus$ogsa$impl$core$logging$OgsiLogging;

    public OgsiLogging() {
        super("Logging Service");
    }

    public void postCreate(GridContext context) throws GridServiceException {
        this.LogMessagesSD = this.serviceData.create(LOG_MESSAGES);
        this.serviceData.add(this.LogMessagesSD);
        this.LogMessagesSD.setCallback(this);
        this.LogMessagesSD.setNotifiable(true);
        this.LogBufferSizeSD = this.serviceData.create(LOG_BUFFER_SIZE);
        this.LogBufferSizeSD.setValue(new Integer(this.logBufferSize));
        this.serviceData.add(this.LogBufferSizeSD);
        this.TransientAttributesSD = this.serviceData.create(TRANSIENT_ATTRIBUTES);
        this.serviceData.add(this.TransientAttributesSD);
        this.PersistentAttributesSD = this.serviceData.create(PERSISTENT_ATTRIBUTES);
        this.serviceData.add(this.PersistentAttributesSD);
        super.postCreate(context);
    }

    public void activate(GridContext context) throws GridServiceException {
        i_am_active = true;
        logger.info((Object)"OgsiLogging service activated");
        if (pair_with_our_logfactory) {
            try {
                this.reflectTransientAttributes();
                this.reflectPersistentAttributes();
                this.logfactory.logging_service_ActiveState(true);
            }
            catch (Exception e2) {
                logger.error((Object)(" Ogsi Logging service, error during service data init e=" + e2.toString()));
            }
        }
        super.activate(context);
    }

    public void deactivate(GridContext context) throws GridServiceException {
        i_am_active = false;
        logger.info((Object)"OgsiLogging service de-activated");
        if (pair_with_our_logfactory) {
            this.logfactory.logging_service_ActiveState(false);
        }
        super.deactivate(context);
    }

    public void preDestroy(GridContext context) throws GridServiceException {
        logger.info((Object)"OgsiLogging service destroyed");
        super.preDestroy(context);
    }

    public void postPersistentCreate(GridContext context) throws GridServiceException {
        LogMessageElement firstMessage = new LogMessageElement();
        try {
            this.logfactory = (OGSALogFactory)LogFactory.getFactory();
            if (this.logfactory.rasLogFactorySelfTest(this)) {
                firstMessage.setLevel("info");
            }
            firstMessage.setMessage("OgsiLogging service instantiated successfully");
            logger.info((Object)firstMessage.getMessage());
            pair_with_our_logfactory = true;
            String Value = (String)this.getProperty("logBufferSize");
            if (Value != null) {
                this.logBufferSize = Integer.parseInt(Value);
            }
            this.LogBufferSizeSD.setValue(new Integer(this.logBufferSize));
            String mValue = (String)this.getProperty("logBufferSizeMax");
            if (mValue != null) {
                this.logBufferSizeMax = Integer.parseInt(mValue);
            }
            this.maxBufferSize = this.logBufferSizeMax;
        }
        catch (Exception e) {
            pair_with_our_logfactory = false;
            firstMessage.setLevel("error");
            firstMessage.setMessage("Ogsi Logging service requires complementary Ogsi LogFactory installed via commons, service not viable.\n  exception caught was=" + e.toString() + "\n" + " A file named commons-logging.properties should be placed in a classpath searchable area. \n" + " It should contain the following line as contents: \n\n" + " org.apache.commons.logging.LogFactory=org.globus.ogsa.impl.core.logging...OGSALogFactory\n");
            logger.error((Object)firstMessage.getMessage());
        }
        if (pair_with_our_logfactory) {
            try {
                LogMessageElement warnMessage;
                this.reflectTransientAttributes();
                try {
                    this.reflectPersistentAttributes();
                }
                catch (Exception e) {
                    warnMessage = new LogMessageElement();
                    warnMessage.setLevel("warn");
                    warnMessage.setMessage(" Ogsi unable to init persistent data,  ogsilogging.properties file not located." + e.toString());
                    logger.warn((Object)warnMessage.getMessage());
                    this.addToMessageBucket(warnMessage);
                }
                try {
                    this.logDestinationBasePath = this.logfactory.getLogDestinationBasePath();
                }
                catch (Exception e) {
                    warnMessage = new LogMessageElement();
                    warnMessage.setLevel("warn");
                    warnMessage.setMessage(" Ogsi service has found no logDestinationBasePath, base append suspended." + e.toString());
                    logger.warn((Object)warnMessage.getMessage());
                    this.addToMessageBucket(warnMessage);
                }
                this.logfactory.logging_service_ActiveState(true);
                i_am_active = true;
            }
            catch (Exception e2) {
                firstMessage.setLevel("error");
                firstMessage.setMessage(" Ogsi Logging service, error during service data init e=" + e2.toString());
                logger.error((Object)firstMessage.getMessage());
            }
        }
        this.addToMessageBucket(firstMessage);
        super.postPersistentCreate(context);
    }

    public void setTransientAttribute(LogAttributeElement aLogAttributeElement) throws RemoteException, InvalidDestinationFaultElement, InvalidLevelFaultElement {
        this.serviceCheck();
        LogAttributeElement theLogAttributeElement = aLogAttributeElement;
        String aValue = null;
        String name = theLogAttributeElement.getAttributeName();
        String mode = theLogAttributeElement.getDestination();
        String level = theLogAttributeElement.getLevel();
        String tag = theLogAttributeElement.getGroupName();
        this.levelCheck(level);
        this.destinationCheck(mode);
        aValue = level.equals("") ? mode : (tag.equals("") || tag == null ? mode + "," + level : mode + "," + level + "," + tag);
        this.logfactory.setAttribute(name, aValue);
        this.reflectTransientAttributes();
    }

    public void removeTransientAttribute(String name) throws RemoteException, UnknownNameFaultElement {
        this.serviceCheck();
        if (!this.logfactory.hasAttribute(name)) {
            throw new UnknownNameFaultElement();
        }
        this.logfactory.removeAttribute(name);
        this.reflectTransientAttributes();
    }

    public void setPersistentAttribute(LogAttributeElement aLogAttributeElement) throws RemoteException, InvalidDestinationFaultElement, InvalidLevelFaultElement, UnableToPersistFaultElement {
        this.serviceCheck();
        LogAttributeElement theLogAttributeElement = aLogAttributeElement;
        String aValue = null;
        String name = theLogAttributeElement.getAttributeName();
        String mode = theLogAttributeElement.getDestination();
        String level = theLogAttributeElement.getLevel();
        String tag = theLogAttributeElement.getGroupName();
        this.levelCheck(level);
        this.destinationCheck(mode);
        aValue = level.equals("") ? mode : (tag.equals("") || tag == null ? mode + "," + level : mode + "," + level + "," + tag);
        this.logfactory.setAttributeConfig(name, aValue);
        this.reflectPersistentAttributes();
    }

    public void removePersistentAttribute(String name) throws RemoteException, UnableToPersistFaultElement, UnknownNameFaultElement {
        this.serviceCheck();
        if (!this.logfactory.hasAttributeConfig(name)) {
            throw new UnknownNameFaultElement();
        }
        this.logfactory.removeAttributeConfig(name);
        this.reflectPersistentAttributes();
    }

    public void changeGroupTransientAttribute(GroupLogAttribute gla) throws RemoteException, InvalidDestinationFaultElement, InvalidLevelFaultElement, UnknownGroupNameFaultElement {
        String tag = gla.getGroup();
        String mode = gla.getDestination();
        String level = gla.getLevel();
        boolean foundSomething = false;
        this.serviceCheck();
        this.levelCheck(level);
        this.destinationCheck(mode);
        String[] logers = this.getAttributeNames();
        foundSomething = false;
        int i = 0;
        while (i < logers.length) {
            String attributes = null;
            String theMode = null;
            String theLevel = null;
            String theTag = null;
            attributes = this.getAttributeRuntime(logers[i]);
            StringTokenizer st = new StringTokenizer(attributes, ",");
            int numToks = st.countTokens();
            if (numToks > 1) {
                if (numToks < 3) {
                    theMode = st.nextToken(",");
                    theLevel = st.nextToken();
                } else if (numToks < 4) {
                    theMode = st.nextToken(",");
                    theLevel = st.nextToken(",");
                    theTag = st.nextToken();
                }
            }
            if (theTag != null && (tag.trim().equals("*") || tag.trim().equals(theTag.trim()))) {
                foundSomething = true;
                String newValue = mode.trim().equals("*") ? theMode : mode.trim();
                newValue = level.trim().equals("*") ? newValue + "," + theLevel : newValue + "," + level.trim();
                newValue = newValue + "," + theTag.trim();
                this.logfactory.setAttribute(logers[i], newValue);
            }
            ++i;
        }
        if (!foundSomething) {
            throw new UnknownGroupNameFaultElement();
        }
        this.reflectTransientAttributes();
    }

    public void changeGroupPersistentAttribute(GroupLogAttribute gla) throws RemoteException, InvalidDestinationFaultElement, InvalidLevelFaultElement, UnableToPersistFaultElement, UnknownGroupNameFaultElement {
        String tag = gla.getGroup();
        String mode = gla.getDestination();
        String level = gla.getLevel();
        boolean foundSomething = false;
        this.serviceCheck();
        this.levelCheck(level);
        this.destinationCheck(mode);
        String[] logers = this.getAttributeNamesConfig();
        foundSomething = false;
        int i = 0;
        while (i < logers.length) {
            String attributes = null;
            String theMode = null;
            String theLevel = null;
            String theTag = null;
            attributes = this.getAttributeConfig(logers[i]);
            StringTokenizer st = new StringTokenizer(attributes, ",");
            int numToks = st.countTokens();
            if (numToks > 1) {
                if (numToks < 3) {
                    theMode = st.nextToken(",");
                    theLevel = st.nextToken();
                } else if (numToks < 4) {
                    theMode = st.nextToken(",");
                    theLevel = st.nextToken(",");
                    theTag = st.nextToken();
                }
            }
            if (theTag != null && (tag.trim().equals("*") || tag.trim().equals(theTag.trim()))) {
                foundSomething = true;
                String newValue = mode.trim().equals("*") ? theMode : mode.trim();
                newValue = level.trim().equals("*") ? newValue + "," + theLevel : newValue + "," + level.trim();
                newValue = newValue + "," + theTag.trim();
                this.logfactory.setAttributeConfig(logers[i], newValue);
            }
            ++i;
        }
        if (!foundSomething) {
            throw new UnknownGroupNameFaultElement();
        }
        this.reflectPersistentAttributes();
    }

    private String[] getAttributeNames() {
        return this.logfactory.getAttributeNames();
    }

    private String[] getAttributeNamesConfig() throws UnableToPersistFaultElement {
        return this.logfactory.getAttributeNamesConfig();
    }

    public void saveTransientAttributes() throws RemoteException, UnableToPersistFaultElement {
        this.serviceCheck();
        this.logfactory.saveRuntime();
        this.reflectPersistentAttributes();
    }

    public void loadPersistentAttributes() throws RemoteException, UnableToPersistFaultElement {
        this.serviceCheck();
        this.logfactory.loadAttributes();
        this.reflectTransientAttributes();
    }

    private String getAttributeRuntime(String name) {
        return this.logfactory.getAttribute(name).toString();
    }

    private String getAttributeConfig(String name) throws UnableToPersistFaultElement {
        return this.logfactory.getAttributeConfig(name).toString();
    }

    public void setLogBufferSize(int size) throws RemoteException {
        this.serviceCheck();
        LogMessageElement msg = new LogMessageElement();
        if (size < 0) {
            OgsiLoggingTasks ogsiLoggingTasks = new OgsiLoggingTasks((long)(size * -1));
        } else {
            if (size > this.maxBufferSize) {
                size = this.maxBufferSize;
            }
            this.LogBufferSizeSD.setValue(new Integer(size));
            msg.setLevel("info");
            msg.setMessage("Log view size changed to[" + size + "]");
            this.addToMessageBucket(msg);
        }
    }

    private boolean serviceCheck() throws RemoteException {
        if (!pair_with_our_logfactory) {
            try {
                this.logfactory = (OGSALogFactory)LogFactory.getFactory();
                if (this.logfactory.rasLogFactorySelfTest(this)) {
                    pair_with_our_logfactory = true;
                }
            }
            catch (Exception e) {
                pair_with_our_logfactory = false;
                logger.error((Object)" Ogsi Logging service request not serviceable, proper logFactory installation required. \n A file named commons-logging.properties should be placed in a classpath locatable area. \n It should contain the following line as contents: \n\n org.apache.commons.logging.LogFactory=org.globus.ogsa.impl.core.logging....OGSALogFactory\n");
                throw new RemoteException("Ogsi LogFactory not installed");
            }
        }
        if (!i_am_active) {
            throw new RemoteException("Ogsi function requested on inactive service");
        }
        return true;
    }

    private void levelCheck(String level) throws InvalidLevelFaultElement {
        if (!(level.equalsIgnoreCase("debug") || level.equalsIgnoreCase("all") || level.equalsIgnoreCase("off") || level.equalsIgnoreCase(" ") || level.equalsIgnoreCase("") || level.equalsIgnoreCase("trace") || level.equalsIgnoreCase("error") || level.equalsIgnoreCase("info") || level.equalsIgnoreCase("warn") || level.equalsIgnoreCase("fatal"))) {
            throw new InvalidLevelFaultElement();
        }
    }

    private void destinationCheck(String mode) throws InvalidDestinationFaultElement {
        if (!(mode.equalsIgnoreCase("console") || mode.equalsIgnoreCase(" ") || mode.equalsIgnoreCase(""))) {
            OGSALog4jLog log = new OGSALog4jLog(Logger.getLogger((String)"dummy"));
            String filename = this.logDestinationBasePath.trim() + mode;
            try {
                FileAppender fileApp = new FileAppender((Layout)log.thePattern, filename, true);
                log.getLogger().addAppender((Appender)fileApp);
                log.getLogger().removeAppender((Appender)fileApp);
                fileApp.close();
            }
            catch (Exception e) {
                logger.error((Object)("OGSA service detected invalid destination=" + filename + " exception was:" + e.toString()));
                throw new InvalidDestinationFaultElement();
            }
        }
    }

    private LogAttributeElement[] getTransientAttributeArraySnapshot() {
        String[] logers = this.getAttributeNames();
        LogAttributeElement[] snapshotlogs = new LogAttributeElement[logers.length];
        int i = 0;
        while (i < logers.length) {
            String attributes = null;
            String theMode = null;
            String theLevel = null;
            String theTag = null;
            attributes = this.getAttributeRuntime(logers[i]);
            StringTokenizer st = new StringTokenizer(attributes, ",");
            int numToks = st.countTokens();
            if (numToks > 1) {
                if (numToks < 3) {
                    theMode = st.nextToken(",");
                    theLevel = st.nextToken();
                } else if (numToks < 4) {
                    theMode = st.nextToken(",");
                    theLevel = st.nextToken(",");
                    theTag = st.nextToken();
                }
            } else {
                theMode = st.nextToken(",").trim();
            }
            snapshotlogs[i] = new LogAttributeElement();
            snapshotlogs[i].setAttributeName(logers[i]);
            snapshotlogs[i].setDestination(theMode);
            snapshotlogs[i].setLevel(theLevel);
            snapshotlogs[i].setGroupName(theTag);
            ++i;
        }
        return snapshotlogs;
    }

    private LogAttributeElement[] getPersistentAttributeArraySnapshot() throws UnableToPersistFaultElement {
        String[] logers = this.getAttributeNamesConfig();
        LogAttributeElement[] snapshotlogs = new LogAttributeElement[logers.length];
        int i = 0;
        while (i < logers.length) {
            String attributes = null;
            String theMode = null;
            String theLevel = null;
            String theTag = null;
            attributes = this.getAttributeConfig(logers[i]);
            StringTokenizer st = new StringTokenizer(attributes, ",");
            int numToks = st.countTokens();
            if (numToks > 1) {
                if (numToks < 3) {
                    theMode = st.nextToken(",");
                    theLevel = st.nextToken();
                } else if (numToks < 4) {
                    theMode = st.nextToken(",");
                    theLevel = st.nextToken(",");
                    theTag = st.nextToken();
                }
            } else {
                theMode = st.nextToken(",").trim();
            }
            snapshotlogs[i] = new LogAttributeElement();
            snapshotlogs[i].setAttributeName(logers[i]);
            snapshotlogs[i].setDestination(theMode);
            snapshotlogs[i].setLevel(theLevel);
            snapshotlogs[i].setGroupName(theTag);
            ++i;
        }
        return snapshotlogs;
    }

    public synchronized void reflectTransientAttributes() {
        this.snaploggers = this.getTransientAttributeArraySnapshot();
        try {
            this.serviceData.delete(TRANSIENT_ATTRIBUTES);
            this.TransientAttributesSD = this.serviceData.create(TRANSIENT_ATTRIBUTES);
            this.serviceData.add(this.TransientAttributesSD);
            this.TransientAttributesSD.setValues(this.snaploggers);
        }
        catch (GridServiceException gse) {
            logger.error((Object)(" OGSI Logservice encountered SD error=" + gse.toString()));
        }
    }

    public synchronized void reflectPersistentAttributes() {
        this.snaploggers = null;
        try {
            this.snaploggers = this.getPersistentAttributeArraySnapshot();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.serviceData.delete(PERSISTENT_ATTRIBUTES);
            this.PersistentAttributesSD = this.serviceData.create(PERSISTENT_ATTRIBUTES);
            this.serviceData.add(this.PersistentAttributesSD);
            this.PersistentAttributesSD.setValues(this.snaploggers);
        }
        catch (GridServiceException gse) {
            logger.error((Object)(" OGSI Logservice encountered SD error=" + gse.toString()));
        }
    }

    public Collection getServiceDataValues(QName qname) {
        try {
            if (QNameUtils.equalsLocally(qname, LOG_MESSAGES)) {
                if (this.buffer_window.size() == 0) {
                    return null;
                }
                LogMessageElement[] logholder = new LogMessageElement[this.buffer_window.size()];
                logholder = this.buffer_window.toArray(logholder);
                LinkedList<LogMessageElement> view = new LinkedList<LogMessageElement>();
                int i = logholder.length;
                while (i > 0) {
                    view.add(logholder[i - 1]);
                    --i;
                }
                return view;
            }
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.toString(e));
        }
        return super.getServiceDataValues(qname);
    }

    public synchronized void addToMessageBucket(LogMessageElement lm) {
        int newsize = (Integer)this.LogBufferSizeSD.getValue();
        if (newsize < this.logBufferSize && this.nextSlot > newsize) {
            int dropCount = this.nextSlot - newsize;
            int i = 0;
            while (i < dropCount) {
                this.buffer_window.removeFirst();
                ++i;
            }
            this.nextSlot = newsize;
        }
        this.logBufferSize = newsize;
        if (this.logBufferSize == 0) {
            return;
        }
        ++this.nextSlot;
        if (this.nextSlot > this.logBufferSize) {
            this.buffer_window.removeFirst();
            this.buffer_window.addLast(lm);
            this.nextSlot = this.logBufferSize;
        } else {
            this.buffer_window.addLast(lm);
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastNotify > 1500L) {
            this.LogMessagesSD.notifyChange();
            this.lastNotify = currentTime;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

