/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.core.notification;

import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.NotificationProvider;
import org.globus.ogsa.NotificationSinkCallback;
import org.globus.ogsa.ServiceData;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.client.managers.NotificationSinkManager;
import org.globus.ogsa.impl.core.notification.DefaultJMSToOgsaConverter;
import org.globus.ogsa.impl.core.notification.DefaultOgsaToJMSConverter;
import org.globus.ogsa.impl.core.notification.JMSAdapterException;
import org.globus.ogsa.impl.core.notification.JMSToOgsaConverter;
import org.globus.ogsa.impl.core.notification.OgsaToJMSConverter;
import org.globus.ogsa.impl.ogsi.GridServiceImpl;
import org.globus.ogsa.utils.MessageUtils;
import org.gridforum.ogsi.ExtensibilityType;
import org.gridforum.ogsi.FaultType;
import org.gridforum.ogsi.HandleType;
import org.gridforum.ogsi.ServiceNotDestroyedFaultType;

public class JMSAdapter
extends GridServiceImpl {
    private TopicConnectionFactory jmsTopicConnectionFactory;
    private InitialContext jndiContext;
    private Hashtable initContextParams = new Hashtable();
    private NotificationSinkManager ogsaNotificationManager;
    private Map listenerMap = new HashMap();
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$impl$core$notification$JMSAdapter == null ? (class$org$globus$ogsa$impl$core$notification$JMSAdapter = JMSAdapter.class$("org.globus.ogsa.impl.core.notification.JMSAdapter")) : class$org$globus$ogsa$impl$core$notification$JMSAdapter).getName());
    static /* synthetic */ Class class$org$globus$ogsa$impl$core$notification$JMSAdapter;

    public JMSAdapter() {
        super("JMSAdapter");
    }

    public void postCreate(GridContext context) throws GridServiceException {
        super.postCreate(context);
        ServiceProperties factoryProp = (ServiceProperties)this.getProperty("factory");
        this.setInitialJndiProperty("java.naming.factory.initial", (String)factoryProp.getProperty("java.naming.factory.initial"));
        this.setInitialJndiProperty("java.naming.provider.url", (String)factoryProp.getProperty("java.naming.provider.url"));
        this.setInitialJndiProperty("java.naming.factory.url.pkgs", (String)factoryProp.getProperty("java.naming.factory.url.pkgs"));
    }

    public void setInitialJndiProperty(String key, String value) {
        if (value != null) {
            this.initContextParams.put(key, value);
        } else if (this.initContextParams.containsKey(key)) {
            this.initContextParams.remove(key);
        }
    }

    public void start(String jmsTopicFactoryName) throws JMSAdapterException {
        try {
            this.jndiContext = new InitialContext(this.initContextParams);
            this.jmsTopicConnectionFactory = (TopicConnectionFactory)this.jndiContext.lookup(jmsTopicFactoryName);
            this.ogsaNotificationManager = NotificationSinkManager.getManager();
            this.ogsaNotificationManager.startListening(false);
            logger.debug((Object)("JMSAdapter started with jmsTopicFactoryName = " + jmsTopicFactoryName));
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.getMessage("startJMSAdapterError"), (Throwable)e);
            throw new JMSAdapterException(MessageUtils.getMessage("startJMSAdapterError"), e);
        }
    }

    public void disconnectTopic(String jmsTopicName) {
        Object obj = this.listenerMap.get(jmsTopicName);
        ((AdapterListener)obj).disconnect();
        this.listenerMap.remove(jmsTopicName);
        logger.debug((Object)("disconnected from jms topic: " + jmsTopicName));
    }

    public void stop() {
        Iterator iter = this.listenerMap.keySet().iterator();
        while (iter.hasNext()) {
            this.disconnectTopic((String)iter.next());
        }
        try {
            if (this.ogsaNotificationManager != null) {
                this.ogsaNotificationManager.stopListening();
                logger.debug((Object)"JMSAdapter stopped");
            }
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.getMessage("stopJMSAdapterError"), (Throwable)e);
        }
        this.ogsaNotificationManager = null;
    }

    public void destroy() throws RemoteException, FaultType, ServiceNotDestroyedFaultType {
        this.stop();
        super.destroy();
    }

    public void finalize() {
        this.stop();
    }

    public void jmsToOgsaSimple(String topicName) throws JMSAdapterException {
        this.jmsToOgsa(topicName, topicName, null);
    }

    public void jmsToOgsa(String jmsTopicName, String ogsaTopicName, String jmsToOgsaConverterClassName) throws JMSAdapterException {
        if (this.ogsaNotificationManager == null) {
            throw new JMSAdapterException(MessageUtils.getMessage("notStartedJMSAdapterError"));
        }
        try {
            JMSToOgsaConverter converter = jmsToOgsaConverterClassName != null && jmsToOgsaConverterClassName.length() > 0 ? (JMSToOgsaConverter)Class.forName(jmsToOgsaConverterClassName).newInstance() : new DefaultJMSToOgsaConverter();
            ServiceData topicData = this.serviceData.create(ogsaTopicName);
            this.serviceData.add(topicData);
            Topic topic = (Topic)this.jndiContext.lookup(jmsTopicName);
            TopicConnection topicConnection = this.jmsTopicConnectionFactory.createTopicConnection();
            TopicSession topicSession = topicConnection.createTopicSession(false, 1);
            TopicSubscriber topicSubscriber = topicSession.createSubscriber(topic);
            JMSListener listener = new JMSListener(this, topicConnection, ogsaTopicName, null, converter);
            topicSubscriber.setMessageListener((MessageListener)listener);
            topicConnection.start();
            this.listenerMap.put(jmsTopicName, listener);
            logger.debug((Object)("connected jms topic: " + jmsTopicName + " to ogsa topic: " + ogsaTopicName));
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.getMessage("jmsToOgsaListenerStartError"), (Throwable)e);
            throw new JMSAdapterException(MessageUtils.getMessage("jmsToOgsaListenerStartError"), e);
        }
    }

    public void ogsaToJMSSimple(String ogsaSourceUrlString, String topicName) throws JMSAdapterException {
        this.ogsaToJMS(ogsaSourceUrlString, topicName, topicName, null);
    }

    public void ogsaToJMS(String ogsaSourceUrlString, String ogsaTopicName, String jmsTopicName, String ogsaToJMSConverterClassName) throws JMSAdapterException {
        if (this.ogsaNotificationManager == null) {
            throw new JMSAdapterException(MessageUtils.getMessage("notStartedJMSAdapterError"));
        }
        try {
            OgsaToJMSConverter converter = ogsaToJMSConverterClassName != null && ogsaToJMSConverterClassName.length() > 0 ? (OgsaToJMSConverter)Class.forName(ogsaToJMSConverterClassName).newInstance() : new DefaultOgsaToJMSConverter();
            Topic jmsTopic = (Topic)this.jndiContext.lookup(jmsTopicName);
            TopicConnection jmsTopicConnection = this.jmsTopicConnectionFactory.createTopicConnection();
            TopicSession jmsTopicSession = jmsTopicConnection.createTopicSession(false, 1);
            TopicPublisher jmsTopicPublisher = jmsTopicSession.createPublisher(jmsTopic);
            URL ogsaSourceUrl = new URL(ogsaSourceUrlString);
            OGSAListener listener = new OGSAListener(this, jmsTopicConnection, jmsTopicSession, jmsTopicPublisher, converter, this.ogsaNotificationManager, ogsaSourceUrl);
            this.ogsaNotificationManager.addListener(ogsaTopicName, null, new HandleType(ogsaSourceUrl.toString()), (NotificationSinkCallback)listener);
            this.listenerMap.put(jmsTopicName, listener);
            logger.debug((Object)("connected ogsa source url: " + ogsaSourceUrlString + "wtih ogsa topic:" + ogsaTopicName + " to jms topic: " + jmsTopicName));
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.getMessage("ogsaToJmsListenerStartError"), (Throwable)e);
            throw new JMSAdapterException(MessageUtils.getMessage("ogsaToJmsListenerStartError"), e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class JMSListener
    extends AdapterListener
    implements MessageListener {
        String ogsaTopicName;
        NotificationProvider ogsaSource;
        JMSToOgsaConverter converter;

        public JMSListener(JMSAdapter _jmsAdapter, TopicConnection _jmsTopicConnection, String _ogsaTopicName, NotificationProvider _ogsaSource, JMSToOgsaConverter _converter) {
            super(_jmsAdapter, _jmsTopicConnection);
            this.ogsaTopicName = _ogsaTopicName;
            this.ogsaSource = _ogsaSource;
            this.converter = _converter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Message jmsMessage) {
            try {
                Object ogsaMessage = this.converter.convertToOgsa(jmsMessage);
                JMSAdapter jMSAdapter = this.jmsAdapter;
                synchronized (jMSAdapter) {
                    ServiceData topicData = this.jmsAdapter.serviceData.get(this.ogsaTopicName);
                    topicData.setValue(ogsaMessage);
                    topicData.notifyChange();
                }
            }
            catch (Exception e) {
                logger.error((Object)MessageUtils.getMessage("jmsOgsaConvertError"), (Throwable)e);
            }
        }
    }

    public static class OGSAListener
    extends AdapterListener
    implements NotificationSinkCallback {
        TopicSession jmsTopicSession;
        TopicPublisher jmsTopicPublisher;
        OgsaToJMSConverter converter;
        HashMap properties = new HashMap();
        NotificationSinkManager ogsaNotificationManager;
        URL ogsaSourceUrl;

        public OGSAListener(JMSAdapter _jmsAdapter, TopicConnection _jmsTopicConnection, TopicSession _jmsTopicSession, TopicPublisher _jmsTopicPublisher, OgsaToJMSConverter _converter, NotificationSinkManager _ogsaNotificationManager, URL _ogsaSourceUrl) {
            super(_jmsAdapter, _jmsTopicConnection);
            this.jmsTopicSession = _jmsTopicSession;
            this.jmsTopicPublisher = _jmsTopicPublisher;
            this.converter = _converter;
            this.ogsaNotificationManager = _ogsaNotificationManager;
            this.ogsaSourceUrl = _ogsaSourceUrl;
        }

        public void deliverNotification(ExtensibilityType any) throws RemoteException {
            try {
                Message jmsMessage = this.converter.convertToJMS(any, this.jmsTopicSession);
                this.jmsTopicPublisher.publish(jmsMessage);
            }
            catch (Exception e) {
                logger.error((Object)MessageUtils.getMessage("ogsaJmsConvertError"), (Throwable)e);
            }
        }

        public void disconnect() {
            super.disconnect();
            try {
                String sinkID = (String)this.getProperty("sinkID");
                this.ogsaNotificationManager.removeListener(sinkID);
            }
            catch (Exception e) {
                logger.error((Object)MessageUtils.getMessage("disconnectOgsaListenerError"), (Throwable)e);
            }
        }

        public void setProperty(String key, Object obj) {
            this.properties.put(key, obj);
        }

        public Object getProperty(String key) {
            return this.properties.get(key);
        }

        public Object getPersistentProperty(String key) {
            return null;
        }

        public void setPersistentProperty(String key, Object obj) {
        }

        public void flush() {
        }
    }

    public static class AdapterListener {
        TopicConnection jmsTopicConnection;
        JMSAdapter jmsAdapter;

        public AdapterListener(JMSAdapter _jmsAdapter, TopicConnection _jmsTopicConnection) {
            this.jmsAdapter = _jmsAdapter;
            this.jmsTopicConnection = _jmsTopicConnection;
        }

        public void disconnect() {
            try {
                this.jmsTopicConnection.close();
            }
            catch (Exception e) {
                logger.error((Object)MessageUtils.getMessage("jmsListenerStopError"), (Throwable)e);
            }
        }
    }
}

