/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.ogsi;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceBase;
import org.globus.ogsa.GridServiceCallback;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.NotificationProvider;
import org.globus.ogsa.OperationProvider;
import org.globus.ogsa.ServiceData;
import org.globus.ogsa.ServiceDataListener;
import org.globus.ogsa.ServiceDataSet;
import org.globus.ogsa.ServiceDataValueCallback;
import org.globus.ogsa.TopicAlreadyExistsException;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.impl.core.notification.NotificationSubscriptionData;
import org.globus.ogsa.impl.ogsi.FactoryProvider;
import org.globus.ogsa.impl.ogsi.MessageNotification;
import org.globus.ogsa.impl.ogsi.SubscriptionEntry;
import org.globus.ogsa.impl.ogsi.TopicEntry;
import org.globus.ogsa.repository.ServiceNode;
import org.globus.ogsa.server.ServiceHost;
import org.globus.ogsa.types.notification.NotificationSourceTopicElement;
import org.globus.ogsa.types.notification.NotificationSourceTopicType;
import org.globus.ogsa.utils.AnyHelper;
import org.globus.ogsa.utils.FaultHelper;
import org.globus.ogsa.utils.MessageUtils;
import org.globus.ogsa.utils.QNameUtils;
import org.gridforum.ogsi.ExtendedDateTimeType;
import org.gridforum.ogsi.ExtensibilityNotSupportedFaultType;
import org.gridforum.ogsi.ExtensibilityType;
import org.gridforum.ogsi.ExtensibilityTypeFaultType;
import org.gridforum.ogsi.FaultType;
import org.gridforum.ogsi.HandleType;
import org.gridforum.ogsi.LocatorType;
import org.gridforum.ogsi.SubscribeByNameType;
import org.gridforum.ogsi.TargetInvalidFaultType;
import org.gridforum.ogsi.TerminationTimeType;
import org.gridforum.ogsi.holders.LocatorTypeHolder;
import org.gridforum.ogsi.holders.TerminationTimeTypeHolder;

public class NotificationSourceProvider
implements NotificationProvider,
ServiceDataListener,
OperationProvider,
ServiceDataValueCallback,
GridServiceCallback {
    private static final QName[] operations = new QName[]{new QName("http://www.gridforum.org/namespaces/2003/03/OGSI", "subscribe")};
    protected GridServiceBase base;
    protected FactoryProvider factoryProvider;
    private Hashtable subscriptions = new Hashtable();
    private Hashtable topics = new Hashtable();
    private String startTime;
    private long counter = 0L;
    private ServiceDataSet serviceDataSet;
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$impl$ogsi$NotificationSourceProvider == null ? (class$org$globus$ogsa$impl$ogsi$NotificationSourceProvider = NotificationSourceProvider.class$("org.globus.ogsa.impl.ogsi.NotificationSourceProvider")) : class$org$globus$ogsa$impl$ogsi$NotificationSourceProvider).getName());
    static /* synthetic */ Class class$org$globus$ogsa$impl$ogsi$NotificationSourceProvider;
    static /* synthetic */ Class class$org$gridforum$ogsi$TargetInvalidFaultType;
    static /* synthetic */ Class class$org$gridforum$ogsi$SubscribeByNameType;

    public void preCreate(GridServiceBase base) throws GridServiceException {
    }

    public void postCreate(GridContext context) throws GridServiceException {
    }

    public void activate(GridContext context) throws GridServiceException {
        logger.debug((Object)"Activating NotificationSource");
        FactoryProvider provider = this.getFactoryProvider((MessageContext)context.getMessageContext());
        provider.activate(context);
    }

    public void deactivate(GridContext context) throws GridServiceException {
        logger.debug((Object)"Deactivating NotificationSource");
        FactoryProvider provider = this.getFactoryProvider((MessageContext)context.getMessageContext());
        provider.deactivate(context);
    }

    public void preDestroy(GridContext context) throws GridServiceException {
    }

    public QName[] getOperations() {
        return operations;
    }

    public void initialize(GridServiceBase base) throws GridServiceException {
        this.startTime = new Date().toString();
        this.base = base;
        base.setProperty("notificationSource", this);
        this.serviceDataSet = base.getServiceDataSet();
        this.addServiceData();
    }

    public Collection getServiceDataValues(QName qname) {
        try {
            if (QNameUtils.equalsLocally(qname, ServiceData.NOTIFIABLE_NAME)) {
                ArrayList<QName> list = new ArrayList<QName>();
                Iterator iterator = this.serviceDataSet.iterator();
                while (iterator.hasNext()) {
                    ServiceData data = (ServiceData)iterator.next();
                    if (!data.isNotifiable()) continue;
                    list.add(data.getName());
                }
                return list;
            }
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.toString(e));
        }
        return new ArrayList();
    }

    public String getSubscriptionID() {
        ++this.counter;
        return this.startTime + "-" + this.hashCode() + "-" + this.counter;
    }

    public synchronized String addSubscription(QName subscriptionName, HandleType handle, String subscriptionID) throws TargetInvalidFaultType {
        TopicEntry topicEntry = (TopicEntry)this.topics.get(subscriptionName);
        if (topicEntry == null) {
            ServiceData obj = null;
            try {
                obj = this.serviceDataSet.get(subscriptionName);
            }
            catch (Exception e) {
                logger.error((Object)MessageUtils.toString(e));
                throw new TargetInvalidFaultType();
            }
            if (obj == null) {
                throw (TargetInvalidFaultType)FaultHelper.makeFault(class$org$gridforum$ogsi$TargetInvalidFaultType == null ? (class$org$gridforum$ogsi$TargetInvalidFaultType = NotificationSourceProvider.class$("org.gridforum.ogsi.TargetInvalidFaultType")) : class$org$gridforum$ogsi$TargetInvalidFaultType, MessageUtils.getMessage("serviceDataNotFound", new String[]{"" + subscriptionName}));
            }
            this.serviceDataSet.registerListener(this);
            topicEntry = new TopicEntry(subscriptionName);
            this.topics.put(subscriptionName, topicEntry);
        }
        SubscriptionEntry subscriptionEntry = new SubscriptionEntry(handle, topicEntry);
        if (subscriptionID == null) {
            subscriptionID = this.getSubscriptionID();
        }
        this.subscriptions.put(subscriptionID, subscriptionEntry);
        topicEntry.subscriptions.put(subscriptionID, subscriptionEntry);
        return subscriptionID;
    }

    public synchronized void removeSubscription(String id) throws TargetInvalidFaultType {
        logger.debug((Object)("remove subscription " + id));
        SubscriptionEntry subscription = (SubscriptionEntry)this.subscriptions.remove(id);
        if (subscription == null) {
            FaultHelper.makeFault(class$org$gridforum$ogsi$TargetInvalidFaultType == null ? (class$org$gridforum$ogsi$TargetInvalidFaultType = NotificationSourceProvider.class$("org.gridforum.ogsi.TargetInvalidFaultType")) : class$org$gridforum$ogsi$TargetInvalidFaultType, MessageUtils.getMessage("subscriptionNotFoundError"));
        }
        subscription.topic.subscriptions.remove(id);
    }

    public void addTopic(String topic, QName messageType) throws TopicAlreadyExistsException, GridServiceException {
        this.addTopic(new QName("http://types.ogsa.globus.org/notification", topic), messageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTopic(QName topic, QName messageType) throws TopicAlreadyExistsException, GridServiceException {
        NotificationSourceProvider notificationSourceProvider = this;
        synchronized (notificationSourceProvider) {
            if (this.topics.get(topic) != null) {
                throw new TopicAlreadyExistsException(topic.toString());
            }
            this.topics.put(topic, new TopicEntry(messageType));
        }
        ServiceData serviceData = this.serviceDataSet.create(topic);
        NotificationSourceTopicElement topicElement = new NotificationSourceTopicElement();
        NotificationSourceTopicType topicType = new NotificationSourceTopicType();
        topicType.setMessageType(messageType);
        topicElement.setNotificationSourceTopic(topicType);
        serviceData.setValue(topicElement);
        this.serviceDataSet.add(serviceData);
    }

    public void serviceDataChanged(ServiceData data, boolean ack) {
        block3: {
            try {
                if (ack) {
                    this.notifyWithAck(data.getName(), (Object)data.externalizeMessage(), data.getProperties());
                    break block3;
                }
                this.notify(data.getName(), (Object)data.externalizeMessage(), data.getProperties());
            }
            catch (Exception e) {
                logger.error((Object)MessageUtils.toString(e));
            }
        }
    }

    public void notify(String topic, Object messageData) {
        this.notify(new QName("http://types.ogsa.globus.org/notification", topic), messageData);
    }

    public void notify(QName topic, Object messageData) {
        this.notify(topic, messageData, null, false);
    }

    public void notifyWithAck(String topic, Object messageData) {
        this.notify(new QName("http://types.ogsa.globus.org/notification", topic), messageData, null, true);
    }

    public void notifyWithAck(QName topic, Object messageData) {
        this.notify(topic, messageData, null, true);
    }

    public void notify(String topic, Object messageData, Map properties) {
        this.notify(new QName("http://types.ogsa.globus.org/notification", topic), messageData, properties, false);
    }

    public void notify(QName topic, Object messageData, Map properties) {
        this.notify(topic, messageData, properties, false);
    }

    public void notifyWithAck(QName topic, Object messageData, Map properties) {
        this.notify(topic, messageData, properties, true);
    }

    public void notifyWithAck(String topic, Object messageData, Map properties) {
        this.notify(new QName("http://types.ogsa.globus.org/notification", topic), messageData, properties, true);
    }

    public void notify(QName topic, Object messageData, Map properties, boolean ack) {
        TopicEntry entry = (TopicEntry)this.topics.get(topic);
        if (entry == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Notify - no listeners to notify for topic: " + topic.toString()));
            }
            return;
        }
        ArrayList<MessageNotification> threads = new ArrayList<MessageNotification>();
        Enumeration enumeration = entry.subscriptions.elements();
        while (enumeration.hasMoreElements()) {
            SubscriptionEntry subscriptionEntry = (SubscriptionEntry)enumeration.nextElement();
            try {
                logger.debug((Object)("notify " + topic + " " + subscriptionEntry.handle));
                MessageNotification notification = new MessageNotification(subscriptionEntry, messageData, properties);
                notification.start();
                if (!ack) continue;
                threads.add(notification);
            }
            catch (Exception e) {
                logger.error((Object)MessageUtils.getMessage("sinkError", new String[]{"" + subscriptionEntry.handle}));
                logger.error((Object)MessageUtils.toString(e));
            }
        }
        Iterator iterator = threads.iterator();
        while (iterator.hasNext()) {
            Thread thread = (Thread)iterator.next();
            try {
                thread.join();
            }
            catch (Exception e) {
                logger.error((Object)MessageUtils.toString(e));
            }
        }
    }

    protected String getNotificationFactoryProperty(MessageContext ctx) {
        String accessProtocol = ServiceHost.getDefaultProtocol(new GridContext((javax.xml.rpc.handler.MessageContext)ctx));
        String notificationFactory = "notificationFactory";
        if (!accessProtocol.equalsIgnoreCase("http")) {
            notificationFactory = accessProtocol.toLowerCase() + "." + "notificationFactory";
        }
        return notificationFactory;
    }

    public void subscribe(ExtensibilityType subscriptionExpression, LocatorType sink, ExtendedDateTimeType expirationTime, LocatorTypeHolder subscriptionInstanceLocator, TerminationTimeTypeHolder currentTerminationTime) throws RemoteException, FaultType, TargetInvalidFaultType, ExtensibilityNotSupportedFaultType, ExtensibilityTypeFaultType {
        SubscribeByNameType subscription = (SubscribeByNameType)AnyHelper.getAsSingleObject(subscriptionExpression, class$org$gridforum$ogsi$SubscribeByNameType == null ? (class$org$gridforum$ogsi$SubscribeByNameType = NotificationSourceProvider.class$("org.gridforum.ogsi.SubscribeByNameType")) : class$org$gridforum$ogsi$SubscribeByNameType);
        QName[] serviceDataName = subscription.getName();
        QName[] serviceDataKey = new QName[serviceDataName.length];
        int i = 0;
        while (i < serviceDataKey.length) {
            try {
                serviceDataKey[i] = this.serviceDataSet.checkMatching(serviceDataName[i]);
            }
            catch (Exception e) {
                throw FaultHelper.makeFault(class$org$gridforum$ogsi$TargetInvalidFaultType == null ? (class$org$gridforum$ogsi$TargetInvalidFaultType = NotificationSourceProvider.class$("org.gridforum.ogsi.TargetInvalidFaultType")) : class$org$gridforum$ogsi$TargetInvalidFaultType, MessageUtils.getMessage("serviceDataLookupError", new String[]{"" + serviceDataName[i]}));
            }
            if (serviceDataKey[i] == null) {
                throw FaultHelper.makeFault(class$org$gridforum$ogsi$TargetInvalidFaultType == null ? (class$org$gridforum$ogsi$TargetInvalidFaultType = NotificationSourceProvider.class$("org.gridforum.ogsi.TargetInvalidFaultType")) : class$org$gridforum$ogsi$TargetInvalidFaultType, MessageUtils.getMessage("serviceDataNotFound", new String[]{"" + serviceDataName[i]}));
            }
            ++i;
        }
        logger.debug((Object)("Subscription:" + serviceDataKey));
        String lifecycle = (String)this.base.getProperty("lifecycle");
        NotificationSubscriptionData input = new NotificationSubscriptionData(serviceDataKey, sink.getHandle()[0], (String)this.base.getProperty("servicePath"));
        MessageContext ctx = MessageContext.getCurrentContext();
        ctx.setProperty("or.globus.ogsa.startupState", (Object)input);
        FactoryProvider factory = this.getFactoryProvider(ctx);
        TerminationTimeType termination = new TerminationTimeType();
        termination.setAfter(expirationTime);
        if (lifecycle != null && lifecycle.equalsIgnoreCase("persistent")) {
            factory.createPersistentService(termination, null, subscriptionInstanceLocator, currentTerminationTime, null);
        } else {
            factory.createService(termination, null, subscriptionInstanceLocator, currentTerminationTime, null);
        }
    }

    private synchronized FactoryProvider getFactoryProvider(MessageContext context) throws GridServiceException {
        if (this.factoryProvider != null) {
            return this.factoryProvider;
        }
        String notificationFactory = this.getNotificationFactoryProperty(context);
        String serviceName = ContainerConfig.getConfig().getOption(notificationFactory);
        if (serviceName == null) {
            throw new GridServiceException(MessageUtils.getMessage("notificationServiceNotDefined", new String[]{notificationFactory}));
        }
        GridServiceBase factoryServiceBase = (GridServiceBase)ServiceNode.getRootNode().activate(serviceName);
        this.factoryProvider = (FactoryProvider)factoryServiceBase.getOperationProvider(FactoryProvider.operations[0]);
        return this.factoryProvider;
    }

    private void addServiceData() throws GridServiceException {
        ServiceData serviceData = this.serviceDataSet.create(ServiceData.NOTIFIABLE_NAME);
        serviceData.setCallback(this);
        this.serviceDataSet.add(serviceData);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

