/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.authentication.wssec;

import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.impl.security.authentication.wssec.WSConstants;
import org.globus.ogsa.impl.security.authentication.wssec.WSSecurityEngine;
import org.globus.ogsa.impl.security.authentication.wssec.WSSecurityFault;
import org.globus.ogsa.impl.security.util.EnvelopeConverter;
import org.w3c.dom.Document;

public abstract class WSSecurityBasicHandler
extends GenericHandler {
    private static Log log = LogFactory.getLog((String)(class$org$globus$ogsa$impl$security$authentication$wssec$WSSecurityBasicHandler == null ? (class$org$globus$ogsa$impl$security$authentication$wssec$WSSecurityBasicHandler = WSSecurityBasicHandler.class$("org.globus.ogsa.impl.security.authentication.wssec.WSSecurityBasicHandler")) : class$org$globus$ogsa$impl$security$authentication$wssec$WSSecurityBasicHandler).getName());
    private static final QName[] HEADERS = new QName[]{WSConstants.WSSE_QNAME};
    static /* synthetic */ Class class$org$globus$ogsa$impl$security$authentication$wssec$WSSecurityBasicHandler;

    public boolean handleMessage(SOAPMessageContext ctx, WSSecurityEngine engine) {
        SOAPMessage msg = ctx.getMessage();
        try {
            SOAPEnvelope env = msg.getSOAPPart().getEnvelope();
            Document doc = engine.processSecurityHeader(env, (MessageContext)ctx);
            if (doc != null) {
                log.debug((Object)"Setting new envelope");
                EnvelopeConverter converter = EnvelopeConverter.getInstance();
                SOAPMessage newMsg = converter.toSOAPMessage(doc);
                ctx.setMessage(newMsg);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error processing message", (Throwable)e);
            throw WSSecurityFault.makeFault(e);
        }
        return true;
    }

    public QName[] getHeaders() {
        return HEADERS;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

